/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.form.Form;
import org.minimalj.frontend.form.element.CheckBoxFormElement;
import org.minimalj.frontend.form.element.Enable;
import org.minimalj.frontend.form.element.ObjectFormElement;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.Keys;
import org.minimalj.model.Rendering;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.mock.Mocking;
import org.minimalj.util.resources.Resources;

public class EnumSetFormElement<E extends Set<Enum<?>>>
extends ObjectFormElement<E>
implements Enable,
Mocking {
    private final Class enumClass;
    private final Collection allowedValues;

    public EnumSetFormElement(PropertyInterface property, boolean editable) {
        this(property, null, editable);
    }

    public EnumSetFormElement(E key, E allowedValues) {
        this(Keys.getProperty(key), allowedValues, true);
    }

    public EnumSetFormElement(PropertyInterface property, E allowedValues, boolean editable) {
        super(property, editable);
        this.enumClass = GenericUtils.getGenericClass(property.getType());
        this.allowedValues = allowedValues != null ? allowedValues : EnumUtils.valueList(this.enumClass);
    }

    @Override
    public void mock() {
        HashSet<Enum> newValues = new HashSet<Enum>();
        for (Object object : this.allowedValues) {
            if (!(Math.random() < 0.5)) continue;
            Enum value = (Enum)object;
            newValues.add(value);
        }
        this.setValue(newValues);
    }

    @Override
    protected Form<E> createForm() {
        Form form = new Form(true);
        for (Object object : this.allowedValues) {
            Enum value = (Enum)object;
            form.lineWithoutCaption(new CheckBoxFormElement(new EnumSetFormElementProperty(value), EnumUtils.getText((Enum)object), true));
        }
        return form;
    }

    @Override
    protected void show(E objects) {
        for (Object object : objects) {
            if (object instanceof Rendering) {
                this.add((Rendering)object, new Action[0]);
                continue;
            }
            this.add(Rendering.render(object, Rendering.RenderType.PLAIN_TEXT), new Action[0]);
        }
    }

    @Override
    protected Action[] getActions() {
        return new Action[]{new EnumSetFormElementEditor()};
    }

    private class EnumSetFormElementProperty
    extends CheckBoxFormElement.CheckBoxProperty {
        private final Enum<?> value;

        public EnumSetFormElementProperty(Enum<?> value) {
            this.value = value;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return EnumSetFormElement.this.enumClass;
        }

        @Override
        public String getName() {
            return this.value.name();
        }

        @Override
        public String getPath() {
            return this.value.name();
        }

        @Override
        public Class<?> getClazz() {
            return EnumSetFormElement.this.enumClass;
        }

        @Override
        public Boolean getValue(Object object) {
            Set set = (Set)object;
            return set.contains(this.value);
        }

        @Override
        public void setValue(Object object, Object newValue) {
            Set set = (Set)object;
            if (Boolean.TRUE.equals(newValue)) {
                set.add(this.value);
            } else {
                set.remove(this.value);
            }
        }
    }

    public class EnumSetFormElementEditor
    extends ObjectFormElement.ObjectFormElementEditor {
        public EnumSetFormElementEditor() {
            super(EnumSetFormElement.this);
        }

        @Override
        protected Object[] getNameArguments() {
            return new Object[]{Resources.getString(GenericUtils.getGenericClass(EnumSetFormElement.this.getProperty().getType()))};
        }

        @Override
        public E createObject() {
            return new HashSet((Collection)EnumSetFormElement.this.getValue());
        }

        @Override
        public Void save(E edited) {
            ((Set)EnumSetFormElement.this.getValue()).clear();
            ((Set)EnumSetFormElement.this.getValue()).addAll(edited);
            return null;
        }
    }
}

