/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.util.List;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.AbstractFormElement;
import org.minimalj.frontend.form.element.Enable;
import org.minimalj.model.CodeItem;
import org.minimalj.model.EnumUtils;
import org.minimalj.model.Keys;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.mock.Mocking;

public class EnumFormElement<E extends Enum<E>>
extends AbstractFormElement<E>
implements Enable,
Mocking {
    private final Class<E> enumClass;
    private final Frontend.Input<CodeItem<E>> comboBox;

    public EnumFormElement(PropertyInterface property) {
        this(property, (List<E>)null);
    }

    public EnumFormElement(E key, List<E> allowedValues) {
        this(Keys.getProperty(key), allowedValues);
    }

    public EnumFormElement(PropertyInterface property, List<E> allowedValues) {
        super(property);
        this.enumClass = property.getClazz();
        List<CodeItem<E>> itemList = allowedValues != null ? EnumUtils.itemList(allowedValues) : EnumUtils.itemList(this.enumClass);
        this.comboBox = Frontend.getInstance().createComboBox(itemList, this.listener());
        this.setDefault();
    }

    @Override
    public Frontend.IComponent getComponent() {
        return this.comboBox;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.comboBox.setEditable(enabled);
    }

    private void setDefault() {
        E defolt = EnumUtils.getDefault(this.enumClass);
        if (!((Enum)defolt).equals(this.getValue())) {
            this.setValue(defolt);
            this.fireChange();
        }
    }

    @Override
    public E getValue() {
        if (this.comboBox.getValue() != null) {
            return (E)((Enum)this.comboBox.getValue().getKey());
        }
        return null;
    }

    @Override
    public void setValue(E value) {
        CodeItem<E> item = null;
        if (value != null) {
            List<CodeItem<E>> itemList = EnumUtils.itemList(this.enumClass);
            for (CodeItem<E> i : itemList) {
                if (!((Enum)i.getKey()).equals(value)) continue;
                item = i;
                break;
            }
        }
        this.comboBox.setValue(item);
    }

    @Override
    public void mock() {
        if (Math.random() < 0.2) {
            this.setDefault();
        } else {
            List<E> valueList = EnumUtils.valueList(this.enumClass);
            int index = (int)(Math.random() * (double)valueList.size());
            this.setValue((E)((Enum)valueList.get(index)));
        }
    }
}

