/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.AbstractFormElement;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.properties.VirtualProperty;
import org.minimalj.util.resources.Resources;

public class CheckBoxFormElement
extends AbstractFormElement<Boolean> {
    private final Frontend.Input<Boolean> checkBox;

    public CheckBoxFormElement(PropertyInterface property, boolean editable) {
        this(property, Resources.getPropertyName(property, ".checkBoxText"), editable);
    }

    public CheckBoxFormElement(PropertyInterface property, String text, boolean editable) {
        super(property);
        this.checkBox = Frontend.getInstance().createCheckBox(this.listener(), text);
        this.checkBox.setEditable(editable);
    }

    @Override
    public Frontend.IComponent getComponent() {
        return this.checkBox;
    }

    @Override
    public Boolean getValue() {
        return this.checkBox.getValue();
    }

    @Override
    public void setValue(Boolean value) {
        this.checkBox.setValue(Boolean.TRUE.equals(value));
    }

    public static abstract class CheckBoxProperty
    extends VirtualProperty {
        @Override
        public Class<?> getDeclaringClass() {
            return Object.class;
        }

        @Override
        public Class<?> getClazz() {
            return Boolean.class;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public abstract Boolean getValue(Object var1);

        @Override
        public abstract void setValue(Object var1, Object var2);
    }
}

