/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import org.minimalj.frontend.form.element.NumberFormElement;
import org.minimalj.model.Keys;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.model.validation.InvalidValues;
import org.minimalj.util.StringUtils;
import org.minimalj.util.mock.Mocking;

public class BigDecimalFormElement
extends NumberFormElement<BigDecimal>
implements Mocking {
    private final NumberFormat format;

    public BigDecimalFormElement(Object key, boolean editable) {
        this(Keys.getProperty(key), editable);
    }

    public BigDecimalFormElement(PropertyInterface property, boolean editable) {
        super(property, editable);
        this.format = this.createFormat(property);
    }

    protected NumberFormat createFormat(PropertyInterface property) {
        DecimalFormat format = new DecimalFormat();
        if (this.decimalPlaces > 0) {
            ((NumberFormat)format).setMaximumFractionDigits(this.decimalPlaces);
        } else {
            ((NumberFormat)format).setMaximumFractionDigits(0);
        }
        ((NumberFormat)format).setMinimumFractionDigits(0);
        ((NumberFormat)format).setGroupingUsed(false);
        return format;
    }

    @Override
    public BigDecimal parse(String text) {
        if (!StringUtils.isEmpty(text)) {
            try {
                BigDecimal value = new BigDecimal(text);
                if (value.signum() < 0 && !this.signed) {
                    return InvalidValues.createInvalidBigDecimal(text);
                }
                if ((value = value.stripTrailingZeros()).precision() > this.size) {
                    return InvalidValues.createInvalidBigDecimal(text);
                }
                if (value.scale() > this.decimalPlaces) {
                    return InvalidValues.createInvalidBigDecimal(text);
                }
                return value;
            }
            catch (NumberFormatException nfe) {
                return InvalidValues.createInvalidBigDecimal(text);
            }
        }
        return null;
    }

    @Override
    public String render(BigDecimal number) {
        String string = null;
        if (number != null) {
            if (InvalidValues.isInvalid(number)) {
                string = InvalidValues.getInvalidValue(number);
            } else {
                BigDecimal correctScale = number.setScale(this.format.getMaximumFractionDigits(), 1);
                return this.format.format(correctScale);
            }
        }
        return string;
    }

    @Override
    public void mock() {
        Random random = new Random();
        StringBuilder s = new StringBuilder(this.size);
        for (int i = 0; i < this.size; ++i) {
            s.append((char)(48 + random.nextInt(10)));
        }
        BigDecimal value = new BigDecimal(s.toString());
        value = value.movePointLeft(this.decimalPlaces);
        if (this.signed && random.nextBoolean()) {
            value = value.negate();
        }
        this.setValue(value);
    }
}

