/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.form.element;

import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.form.element.FormElement;
import org.minimalj.model.Keys;
import org.minimalj.model.properties.PropertyInterface;
import org.minimalj.util.ChangeListener;

public abstract class AbstractFormElement<T>
implements FormElement<T> {
    private final PropertyInterface property;
    private Frontend.InputComponentListener forwardingChangeListener;
    private ChangeListener<FormElement<?>> changeListener;

    protected AbstractFormElement(Object key) {
        this(Keys.getProperty(key));
    }

    protected AbstractFormElement(PropertyInterface property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        this.property = property;
    }

    @Override
    public PropertyInterface getProperty() {
        return this.property;
    }

    protected Frontend.InputComponentListener listener() {
        if (this.forwardingChangeListener == null) {
            this.forwardingChangeListener = new ForwardingChangeListener();
        }
        return this.forwardingChangeListener;
    }

    @Override
    public void setChangeListener(ChangeListener<FormElement<?>> changeListener) {
        if (changeListener == null) {
            throw new IllegalArgumentException("ChangeListener must not be null");
        }
        if (this.changeListener != null) {
            throw new IllegalStateException("ChangeListener can only be set once");
        }
        this.changeListener = changeListener;
    }

    protected void fireChange() {
        if (this.changeListener != null) {
            this.changeListener.changed(this);
        }
    }

    private class ForwardingChangeListener
    implements Frontend.InputComponentListener {
        private ForwardingChangeListener() {
        }

        @Override
        public void changed(Frontend.IComponent source) {
            AbstractFormElement.this.fireChange();
        }
    }
}

