/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.minimalj.application.DevMode;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.editor.ObjectValidator;
import org.minimalj.frontend.editor.WizardStep;
import org.minimalj.frontend.form.Form;
import org.minimalj.frontend.page.IDialog;
import org.minimalj.model.validation.Validation;
import org.minimalj.model.validation.ValidationMessage;
import org.minimalj.util.ChangeListener;
import org.minimalj.util.ExceptionUtils;
import org.minimalj.util.mock.Mocking;

public abstract class Wizard<RESULT>
extends Action {
    private static final Logger logger = Logger.getLogger(Wizard.class.getName());
    private Object stepObject;
    private WizardStep step;
    private Form form;
    private final EditorChangeListener changeListener = new EditorChangeListener();
    private final List<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
    private final FinishAction finishAction = new FinishAction();
    private final NextWizardStepAction nextAction = new NextWizardStepAction();
    private final PreviousWizardStepAction previousAction = new PreviousWizardStepAction();
    private final CancelAction cancelAction = new CancelAction();
    private IDialog dialog;
    private Frontend.SwitchContent switchContent;
    private int stepIndex;

    public Wizard() {
    }

    public Wizard(String actionName) {
        super(actionName);
    }

    public String getTitle() {
        return this.getName();
    }

    @Override
    public void action() {
        this.switchContent = Frontend.getInstance().createSwitchContent();
        this.stepIndex = 0;
        this.step = this.getFirstStep();
        this.switchStep();
        this.dialog = Frontend.showDialog(this.getTitle(), this.switchContent, this.nextAction, this.cancelAction, this.createActions());
    }

    private Action[] createActions() {
        List<Action> additionalActions = this.createAdditionalActions();
        Action[] actions = new Action[additionalActions.size() + 4];
        for (int index = 0; index < additionalActions.size(); ++index) {
            actions[index] = additionalActions.get(index);
        }
        actions[index++] = this.cancelAction;
        actions[index++] = this.previousAction;
        actions[index++] = this.nextAction;
        actions[index++] = this.finishAction;
        return actions;
    }

    protected List<Action> createAdditionalActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (DevMode.isActive()) {
            actions.add(new FillWithDemoDataAction());
        }
        return actions;
    }

    private void switchStep() {
        this.stepObject = this.step.createObject();
        this.form = this.step.createForm();
        this.form.setChangeListener(this.changeListener);
        this.form.setObject(this.stepObject);
        this.validate(this.stepObject);
        this.switchContent.show(this.form.getContent());
        this.previousAction.setEnabled(this.stepIndex > 0);
    }

    protected abstract WizardStep<?> getFirstStep();

    private void validate(Object stepObject) {
        this.validationMessages.clear();
        if (stepObject instanceof Validation) {
            this.validationMessages.addAll(((Validation)stepObject).validateNullSafe());
        }
        ObjectValidator.validate(stepObject, this.validationMessages, this.form.getProperties());
        if (this.step instanceof Validation) {
            this.validationMessages.addAll(((Validation)((Object)this.step)).validateNullSafe());
        }
        this.form.indicate(this.validationMessages);
        this.nextAction.setValidationMessages(this.validationMessages);
        this.finishAction.setValidationMessages(this.validationMessages);
    }

    private void next(Object object) {
        ++this.stepIndex;
        this.step = this.step.getNextStep();
        this.switchStep();
    }

    private void previous() {
        --this.stepIndex;
        this.step = this.step.getPreviousStep();
        this.switchStep();
    }

    protected int getStepIndex() {
        return this.stepIndex;
    }

    private void finish() {
        try {
            RESULT result = this.save();
            this.dialog.closeDialog();
            this.finished(result);
        }
        catch (Exception x) {
            ExceptionUtils.logReducedStackTrace(logger, x);
            Frontend.showError(x.getLocalizedMessage());
            return;
        }
    }

    protected abstract RESULT save();

    protected void finished(RESULT result) {
    }

    protected WizardStep getStep() {
        return this.step;
    }

    protected boolean canFinish() {
        return true;
    }

    public void cancel() {
        this.dialog.closeDialog();
    }

    protected void fillWithDemoData() {
        if (this.stepObject instanceof Mocking) {
            ((Mocking)this.stepObject).mock();
            this.form.setObject(this.stepObject);
        } else {
            this.form.mock();
        }
    }

    private class FillWithDemoDataAction
    extends Action {
        private FillWithDemoDataAction() {
        }

        @Override
        public void action() {
            Wizard.this.fillWithDemoData();
            Wizard.this.validate(Wizard.this.stepObject);
        }
    }

    private class CancelAction
    extends Action {
        private CancelAction() {
        }

        @Override
        public void action() {
            Wizard.this.cancel();
        }
    }

    protected final class FinishAction
    extends Action {
        private String description;
        private boolean enabled = false;

        protected FinishAction() {
        }

        @Override
        public void action() {
            Wizard.this.finish();
        }

        public void setValidationMessages(List<ValidationMessage> validationMessages) {
            boolean valid = validationMessages == null || validationMessages.isEmpty();
            this.description = valid ? "Eingaben speichern und Wizard beenden" : ValidationMessage.formatHtml(validationMessages);
            this.enabled = valid & Wizard.this.canFinish();
            this.fireChange();
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    protected final class PreviousWizardStepAction
    extends Action {
        protected PreviousWizardStepAction() {
        }

        @Override
        public void action() {
            Wizard.this.previous();
        }
    }

    protected final class NextWizardStepAction
    extends Action {
        private String description;
        private boolean valid = false;

        protected NextWizardStepAction() {
        }

        @Override
        public void action() {
            Wizard.this.next(Wizard.this.stepObject);
        }

        public void setValidationMessages(List<ValidationMessage> validationMessages) {
            this.valid = validationMessages == null || validationMessages.isEmpty();
            this.description = this.valid ? "Speichern und zum n\u00e4chsten Schritt" : ValidationMessage.formatHtml(validationMessages);
            this.fireChange();
        }

        @Override
        public boolean isEnabled() {
            return this.valid;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private class EditorChangeListener
    implements ChangeListener<Form<?>> {
        private EditorChangeListener() {
        }

        @Override
        public void changed(Form<?> form) {
            Wizard.this.validate(Wizard.this.stepObject);
            Wizard.this.finishAction.setValidationMessages(Wizard.this.validationMessages);
        }
    }
}

