/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.minimalj.application.DevMode;
import org.minimalj.frontend.Frontend;
import org.minimalj.frontend.action.Action;
import org.minimalj.frontend.editor.ObjectValidator;
import org.minimalj.frontend.form.Form;
import org.minimalj.frontend.page.IDialog;
import org.minimalj.model.validation.Validation;
import org.minimalj.model.validation.ValidationMessage;
import org.minimalj.util.ChangeListener;
import org.minimalj.util.CloneHelper;
import org.minimalj.util.ExceptionUtils;
import org.minimalj.util.GenericUtils;
import org.minimalj.util.mock.Mocking;
import org.minimalj.util.resources.Resources;

public abstract class Editor<T, RESULT>
extends Action {
    private static final Logger logger = Logger.getLogger(Editor.class.getName());
    private T object;
    private Form<T> form;
    private SaveAction saveAction;
    private IDialog dialog;

    public Editor() {
    }

    public Editor(String actionName) {
        super(actionName);
    }

    @Override
    protected Object[] getNameArguments() {
        Class<?> editedClass = this.getEditedClass();
        if (editedClass != null) {
            String resourceName = Resources.getResourceName(editedClass);
            return new Object[]{Resources.getString(resourceName)};
        }
        return null;
    }

    protected Class<?> getEditedClass() {
        return GenericUtils.getGenericClass(this.getClass());
    }

    public String getTitle() {
        return this.getName();
    }

    @Override
    public void action() {
        this.object = this.createObject();
        this.form = this.createForm();
        this.saveAction = new SaveAction();
        this.validate();
        this.form.setChangeListener(new EditorChangeListener());
        this.form.setObject(this.object);
        this.dialog = Frontend.showDialog(this.getTitle(), this.form.getContent(), this.saveAction, new CancelAction(), this.createActions());
    }

    private Action[] createActions() {
        List<Action> additionalActions = this.createAdditionalActions();
        Action[] actions = new Action[additionalActions.size() + 2];
        for (int index = 0; index < additionalActions.size(); ++index) {
            actions[index] = additionalActions.get(index);
        }
        actions[index++] = new CancelAction();
        actions[index++] = this.saveAction;
        return actions;
    }

    protected List<Action> createAdditionalActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (DevMode.isActive()) {
            actions.add(new FillWithDemoDataAction());
        }
        return actions;
    }

    protected abstract T createObject();

    protected T getObject() {
        return this.object;
    }

    protected abstract Form<T> createForm();

    private void validate() {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        if (this.object instanceof Validation) {
            validationMessages.addAll(((Validation)this.object).validateNullSafe());
        }
        ObjectValidator.validate(this.object, validationMessages, this.form.getProperties());
        this.validate(this.object, validationMessages);
        this.form.indicate(validationMessages);
        this.saveAction.setValidationMessages(validationMessages);
    }

    protected void validate(T object, List<ValidationMessage> validationMessages) {
    }

    private void save() {
        try {
            RESULT result = this.save(this.object);
            if (this.closeWith(result)) {
                this.dialog.closeDialog();
                this.finished(result);
            }
        }
        catch (Exception x) {
            ExceptionUtils.logReducedStackTrace(logger, x);
            Frontend.showError(x.getLocalizedMessage() != null ? x.getLocalizedMessage() : x.getClass().getSimpleName());
            return;
        }
    }

    protected boolean closeWith(RESULT result) {
        return true;
    }

    protected abstract RESULT save(T var1);

    protected void finished(RESULT result) {
    }

    public void cancel() {
        this.dialog.closeDialog();
    }

    protected void fillWithDemoData() {
        if (this.object instanceof Mocking) {
            ((Mocking)this.object).mock();
            this.form.setObject(this.object);
        } else {
            this.form.mock();
        }
    }

    public static abstract class NewObjectEditor<T>
    extends SimpleEditor<T> {
        public NewObjectEditor() {
        }

        public NewObjectEditor(String actionName) {
            super(actionName);
        }

        @Override
        protected T createObject() {
            Class<?> clazz = GenericUtils.getGenericClass(this.getClass());
            Object newInstance = CloneHelper.newInstance(clazz);
            return (T)newInstance;
        }
    }

    public static abstract class SimpleEditor<T>
    extends Editor<T, T> {
        public SimpleEditor() {
        }

        public SimpleEditor(String actionName) {
            super(actionName);
        }
    }

    private class FillWithDemoDataAction
    extends Action {
        private FillWithDemoDataAction() {
        }

        @Override
        public void action() {
            Editor.this.fillWithDemoData();
            Editor.this.validate();
        }
    }

    private class CancelAction
    extends Action {
        private CancelAction() {
        }

        @Override
        public void action() {
            Editor.this.cancel();
        }
    }

    protected final class SaveAction
    extends Action {
        private String description;
        private boolean valid = false;

        protected SaveAction() {
        }

        @Override
        public void action() {
            Editor.this.save();
        }

        public void setValidationMessages(List<ValidationMessage> validationMessages) {
            this.valid = validationMessages == null || validationMessages.isEmpty();
            this.description = ValidationMessage.formatHtml(validationMessages);
            this.fireChange();
        }

        @Override
        public boolean isEnabled() {
            return this.valid;
        }

        @Override
        public String getDescription() {
            return this.description != null ? this.description : super.getDescription();
        }
    }

    private class EditorChangeListener
    implements ChangeListener<Form<?>> {
        private EditorChangeListener() {
        }

        @Override
        public void changed(Form<?> form) {
            Editor.this.validate();
        }
    }
}

