/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.frontend.action;

import java.text.MessageFormat;
import org.minimalj.util.StringUtils;
import org.minimalj.util.resources.Resources;

public abstract class Action {
    private final String name;
    private String description;
    private boolean enabled = true;
    private ActionChangeListener changeListener;

    protected Action() {
        String resourceName = Resources.getResourceName(this.getClass());
        Object[] nameArguments = this.getNameArguments();
        this.name = nameArguments != null ? MessageFormat.format(Resources.getString(resourceName), nameArguments) : Resources.getString(resourceName);
        String descriptionResourceName = resourceName + ".description";
        if (Resources.isAvailable(descriptionResourceName)) {
            this.description = Resources.getString(descriptionResourceName);
        }
    }

    protected Object[] getNameArguments() {
        return null;
    }

    protected Action(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.fireChange();
        }
    }

    public void setDescription(String description) {
        if (!StringUtils.equals(this.description, description)) {
            this.description = description;
            this.fireChange();
        }
    }

    protected void fireChange() {
        if (this.changeListener != null) {
            this.changeListener.change();
        }
    }

    public abstract void action();

    public void setChangeListener(ActionChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public static interface ActionChangeListener {
        public void change();
    }
}

