/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.backend.repository;

import java.util.List;
import org.minimalj.backend.repository.ReadTransaction;
import org.minimalj.repository.Repository;
import org.minimalj.repository.sql.SqlRepository;
import org.minimalj.util.IdUtils;

public class ReadHistoryTransaction<ENTITY>
extends ReadTransaction<ENTITY, List<ENTITY>> {
    private static final long serialVersionUID = 1L;
    private final Object id;
    private final int maxResults;

    public ReadHistoryTransaction(ENTITY object) {
        super(object.getClass());
        this.id = IdUtils.getId(object);
        this.maxResults = Integer.MAX_VALUE;
    }

    public ReadHistoryTransaction(Class<ENTITY> clazz, Object id) {
        this(clazz, id, Integer.MAX_VALUE);
    }

    public ReadHistoryTransaction(Class<ENTITY> clazz, Object id, int maxResults) {
        super(clazz);
        this.id = id;
        this.maxResults = maxResults;
    }

    @Override
    public List<ENTITY> execute(Repository repository) {
        if (repository instanceof SqlRepository) {
            SqlRepository sqlRepository = (SqlRepository)repository;
            List result = sqlRepository.loadHistory(this.getEntityClazz(), this.id, this.maxResults);
            return result;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " works only with " + SqlRepository.class.getSimpleName());
    }
}

