/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.backend.repository;

import org.minimalj.backend.repository.ReadTransaction;
import org.minimalj.repository.Repository;
import org.minimalj.repository.sql.SqlRepository;

public class ReadEntityTransaction<ENTITY>
extends ReadTransaction<ENTITY, ENTITY> {
    private static final long serialVersionUID = 1L;
    private final Object id;
    private final Integer time;

    public ReadEntityTransaction(Class<ENTITY> clazz, Object id) {
        this(clazz, id, null);
    }

    public ReadEntityTransaction(Class<ENTITY> clazz, Object id, Integer time) {
        super(clazz);
        this.id = id;
        this.time = time;
    }

    @Override
    protected ENTITY execute(Repository repository) {
        Object result;
        if (this.time == null) {
            result = repository.read(this.getEntityClazz(), this.id);
        } else if (repository instanceof SqlRepository) {
            SqlRepository sqlRepository = (SqlRepository)repository;
            result = sqlRepository.readVersion(this.getEntityClazz(), this.id, this.time);
        } else {
            throw new IllegalStateException(this.getClass().getSimpleName() + " works only with " + SqlRepository.class.getSimpleName());
        }
        return result;
    }
}

