/*
 * Decompiled with CFR 0.152.
 */
package org.minimalj.backend;

import java.util.List;
import java.util.Objects;
import org.minimalj.application.Configuration;
import org.minimalj.backend.SocketBackend;
import org.minimalj.backend.repository.CountTransaction;
import org.minimalj.backend.repository.DeleteEntityTransaction;
import org.minimalj.backend.repository.InsertTransaction;
import org.minimalj.backend.repository.ReadCriteriaTransaction;
import org.minimalj.backend.repository.ReadEntityTransaction;
import org.minimalj.backend.repository.SaveTransaction;
import org.minimalj.backend.repository.UpdateTransaction;
import org.minimalj.repository.Repository;
import org.minimalj.repository.TransactionalRepository;
import org.minimalj.repository.query.Query;
import org.minimalj.security.Authentication;
import org.minimalj.security.Authorization;
import org.minimalj.transaction.Isolation;
import org.minimalj.transaction.Transaction;
import org.minimalj.transaction.TransactionAnnotations;

public class Backend {
    private static Backend instance;
    private Repository repository = null;
    private Boolean authenticationActive = null;
    private Authentication authentication = null;
    private InheritableThreadLocal<Transaction<?>> currentTransaction = new InheritableThreadLocal();

    public static Backend create() {
        String backendAddress = Configuration.get("MjBackendAddress");
        String backendPort = Configuration.get("MjBackendPort", "8020");
        if (backendAddress != null) {
            return new SocketBackend(backendAddress, Integer.valueOf(backendPort));
        }
        if (Configuration.available("MjBackend")) {
            return Configuration.getClazz("MjBackend", Backend.class, new Object[0]);
        }
        return new Backend();
    }

    public static void setInstance(Backend instance) {
        Objects.nonNull(instance);
        if (Backend.instance != null) {
            throw new IllegalStateException("Not allowed to change instance of " + Backend.class.getSimpleName());
        }
        Backend.instance = instance;
        instance.init();
    }

    public static Backend getInstance() {
        if (instance == null) {
            Backend.setInstance(Backend.create());
        }
        return instance;
    }

    protected void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        if (!this.isInTransaction()) {
            throw new IllegalStateException("Repository may only be accessed from within a " + Transaction.class.getSimpleName());
        }
        if (this.repository == null) {
            this.repository = Repository.create();
        }
        return this.repository;
    }

    protected Authentication createAuthentication() {
        return Authentication.create();
    }

    public final Authentication getAuthentication() {
        if (this.authentication == null && this.authenticationActive == null) {
            this.authentication = this.createAuthentication();
            this.authenticationActive = this.authentication != null;
        }
        return this.authentication;
    }

    public boolean isAuthenticationActive() {
        return this.getAuthentication() != null;
    }

    public boolean isInTransaction() {
        return this.currentTransaction.get() != null;
    }

    public static <T> T read(Class<T> clazz, Object id) {
        return Backend.execute(new ReadEntityTransaction<T>(clazz, id, null));
    }

    public static <T> List<T> find(Class<T> clazz, Query query) {
        return (List)Backend.execute(new ReadCriteriaTransaction<T>(clazz, query));
    }

    public static <T> long count(Class<T> clazz, Query query) {
        return Backend.execute(new CountTransaction<T>(clazz, query));
    }

    public static <T> Object insert(T object) {
        return Backend.execute(new InsertTransaction<T>(object));
    }

    public static <T> void update(T object) {
        Backend.execute(new UpdateTransaction<T>(object));
    }

    public static <T> T save(T object) {
        return Backend.execute(new SaveTransaction<T>(object));
    }

    public static <T> void delete(Class<T> clazz, Object id) {
        Backend.execute(new DeleteEntityTransaction<T>(clazz, id));
    }

    public static <T> T execute(Transaction<T> transaction) {
        return Backend.getInstance().doExecute(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doExecute(Transaction<T> transaction) {
        if (this.isAuthenticationActive()) {
            Authorization.check(transaction);
        }
        try {
            this.currentTransaction.set(transaction);
            if (this.getRepository() instanceof TransactionalRepository) {
                TransactionalRepository transactionalRepository = (TransactionalRepository)this.getRepository();
                T t = this.doExecute(transaction, transactionalRepository);
                return t;
            }
            T t = transaction.execute();
            return t;
        }
        finally {
            this.currentTransaction.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doExecute(Transaction<T> transaction, TransactionalRepository transactionalRepository) {
        T result;
        Isolation.Level isolationLevel = TransactionAnnotations.getIsolation(transaction);
        boolean commit = false;
        try {
            transactionalRepository.startTransaction(isolationLevel.getLevel());
            result = transaction.execute();
            commit = true;
        }
        finally {
            transactionalRepository.endTransaction(commit);
        }
        return result;
    }

    private void init() {
        if (Configuration.available("MjInit")) {
            Transaction init = Configuration.getClazz("MjInit", Transaction.class, new Object[0]);
            init.execute();
        }
    }
}

