/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.helper.cache;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.call.GetCategoriesCall;
import com.ebay.sdk.helper.cache.BaseDownloader;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.GetCategoriesRequestType;
import com.ebay.soap.eBLBaseComponents.GetCategoriesResponseType;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CategoriesDownloader
extends BaseDownloader {
    public CategoriesDownloader(ApiContext apiContext) {
        super(apiContext);
        this.FILE_EXTENSION = "cats";
        this.FILE_PREFIX = "AllCategories";
    }

    @Override
    protected String getLastUpdateTime() throws Exception {
        GetCategoriesCall api = new GetCategoriesCall(this.apiContext);
        GetCategoriesRequestType req = new GetCategoriesRequestType();
        req.setOutputSelector(new String[]{"UpdateTime"});
        api.execute((AbstractRequestType)req);
        GetCategoriesResponseType resp = (GetCategoriesResponseType)api.execute((AbstractRequestType)req);
        Date date = resp.getUpdateTime().getTime();
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_hh_mm_ss");
        String time = df.format(date);
        return time;
    }

    @Override
    protected Object individualCall() throws Exception {
        GetCategoriesCall apiCall = new GetCategoriesCall(this.apiContext);
        apiCall.setViewAllNodes(Boolean.valueOf(true));
        DetailLevelCodeType[] detailLevels = new DetailLevelCodeType[]{DetailLevelCodeType.RETURN_ALL};
        apiCall.setDetailLevel(detailLevels);
        apiCall.setCategorySiteID(this.apiContext.getSite());
        apiCall.getCategories();
        return apiCall.getResponse();
    }

    public CategoryType[] getAllCategories() throws Exception {
        Object obj = this.getObject();
        GetCategoriesResponseType crt = (GetCategoriesResponseType)obj;
        return crt.getCategoryArray().getCategory();
    }
}

