/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.TimeFilter;
import com.ebay.sdk.pictureservice.PictureInfo;
import com.ebay.sdk.pictureservice.PictureService;
import com.ebay.sdk.pictureservice.eps.eBayPictureServiceFactory;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.DiscountReasonCodeType;
import com.ebay.soap.eBLBaseComponents.FeesType;
import com.ebay.soap.eBLBaseComponents.GalleryTypeCodeType;
import com.ebay.soap.eBLBaseComponents.ItemType;
import com.ebay.soap.eBLBaseComponents.ListingRecommendationsType;
import com.ebay.soap.eBLBaseComponents.PhotoDisplayCodeType;
import com.ebay.soap.eBLBaseComponents.PictureDetailsType;
import com.ebay.soap.eBLBaseComponents.PictureSourceCodeType;
import com.ebay.soap.eBLBaseComponents.ProductSuggestionsType;
import com.ebay.soap.eBLBaseComponents.ReviseItemRequestType;
import com.ebay.soap.eBLBaseComponents.ReviseItemResponseType;
import java.util.Calendar;

public class ReviseItemCall
extends ApiCall {
    private ItemType itemToBeRevised = null;
    private String[] deletedField = null;
    private Boolean verifyOnly = null;
    private String returnedItemID = null;
    private Calendar returnedStartTime = null;
    private Calendar returnedEndTime = null;
    private FeesType listingFees = null;
    private String returnedCategoryID = null;
    private String returnedCategory2ID = null;
    private Boolean returnedVerifyOnly = null;
    private DiscountReasonCodeType[] returnedDiscountReason = null;
    private ProductSuggestionsType returnedProductSuggestions = null;
    private ListingRecommendationsType returnedListingRecommendations = null;
    private TimeFilter listingDuration = null;
    private PictureService pictureService;

    public ReviseItemCall() {
    }

    public ReviseItemCall(ApiContext apiContext) {
        super(apiContext);
        this.pictureService = eBayPictureServiceFactory.getPictureService((ApiContext)apiContext);
    }

    public FeesType reviseItem() throws ApiException, SdkException, Exception {
        ReviseItemRequestType req = new ReviseItemRequestType();
        if (this.itemToBeRevised == null) {
            throw new SdkException("ItemToBeRevised property is not set.");
        }
        if (this.itemToBeRevised != null) {
            req.setItem(this.itemToBeRevised);
        }
        if (this.deletedField != null) {
            req.setDeletedField(this.deletedField);
        }
        if (this.verifyOnly != null) {
            req.setVerifyOnly(this.verifyOnly);
        }
        ReviseItemResponseType resp = (ReviseItemResponseType)this.execute((AbstractRequestType)req);
        this.returnedItemID = resp.getItemID();
        this.returnedStartTime = resp.getStartTime();
        this.returnedEndTime = resp.getEndTime();
        this.listingFees = resp.getFees();
        this.returnedCategoryID = resp.getCategoryID();
        this.returnedCategory2ID = resp.getCategory2ID();
        this.returnedVerifyOnly = resp.isVerifyOnly();
        this.returnedDiscountReason = resp.getDiscountReason();
        this.returnedProductSuggestions = resp.getProductSuggestions();
        this.returnedListingRecommendations = resp.getListingRecommendations();
        Calendar startTime = resp.getStartTime();
        if (null != startTime) {
            this.listingDuration = new TimeFilter(startTime, resp.getEndTime());
        }
        return this.getListingFees();
    }

    public String[] getDeletedField() {
        return this.deletedField;
    }

    public void setDeletedField(String[] deletedField) {
        this.deletedField = deletedField;
    }

    public ItemType getItemToBeRevised() {
        return this.itemToBeRevised;
    }

    public void setItemToBeRevised(ItemType itemToBeRevised) {
        this.itemToBeRevised = itemToBeRevised;
    }

    public Boolean getVerifyOnly() {
        return this.verifyOnly;
    }

    public void setVerifyOnly(Boolean verifyOnly) {
        this.verifyOnly = verifyOnly;
    }

    public TimeFilter getListingDuration() {
        return this.listingDuration;
    }

    public void uploadPictures(String[] pictureFiles, PictureDetailsType pictureDetails) throws SdkException {
        if (pictureFiles == null) {
            return;
        }
        PictureInfo[] pictureInfoArray = new PictureInfo[pictureFiles.length];
        for (int i = 0; i < pictureFiles.length; ++i) {
            pictureInfoArray[i] = new PictureInfo();
            pictureInfoArray[i].setPictureFilePath(pictureFiles[i]);
        }
        this.uploadPictures(pictureInfoArray, pictureDetails);
    }

    public void uploadPictures(PictureInfo[] pictureInfoArray, PictureDetailsType pictureDetails) throws SdkException {
        String epsUrl = this.getApiContext().getEpsServerUrl();
        if (pictureInfoArray == null || epsUrl == null) {
            return;
        }
        if (pictureDetails == null) {
            pictureDetails = new PictureDetailsType();
        }
        if (pictureDetails.getPhotoDisplay() == null) {
            pictureDetails.setPhotoDisplay(PhotoDisplayCodeType.NONE);
        }
        if (pictureDetails.getGalleryType() == null) {
            pictureDetails.setGalleryType(GalleryTypeCodeType.NONE);
        }
        if (pictureDetails.getPictureSource() == null) {
            pictureDetails.setPictureSource(PictureSourceCodeType.VENDOR);
        }
        this.itemToBeRevised.setPictureDetails(pictureDetails);
        int uploads = this.pictureService.uploadPictures(pictureDetails.getPhotoDisplay(), pictureInfoArray);
        if (uploads != pictureInfoArray.length) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < pictureInfoArray.length; ++i) {
                if (!pictureInfoArray[i].hasError()) continue;
                sb.append(pictureInfoArray[i].getErrorType() + " : " + pictureInfoArray[i].getErrorMessage() + "\n");
            }
            throw new SdkException(sb.toString());
        }
        String[] uris = new String[pictureInfoArray.length];
        for (int i = 0; i < pictureInfoArray.length; ++i) {
            uris[i] = pictureInfoArray[i].getURL();
        }
        this.itemToBeRevised.getPictureDetails().setPictureURL(uris);
    }

    public FeesType getListingFees() {
        return this.listingFees;
    }

    public String getReturnedCategory2ID() {
        return this.returnedCategory2ID;
    }

    public String getReturnedCategoryID() {
        return this.returnedCategoryID;
    }

    public DiscountReasonCodeType[] getReturnedDiscountReason() {
        return this.returnedDiscountReason;
    }

    public Calendar getReturnedEndTime() {
        return this.returnedEndTime;
    }

    public String getReturnedItemID() {
        return this.returnedItemID;
    }

    public ListingRecommendationsType getReturnedListingRecommendations() {
        return this.returnedListingRecommendations;
    }

    public ProductSuggestionsType getReturnedProductSuggestions() {
        return this.returnedProductSuggestions;
    }

    public Calendar getReturnedStartTime() {
        return this.returnedStartTime;
    }

    public Boolean getReturnedVerifyOnly() {
        return this.returnedVerifyOnly;
    }
}

