/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.TimeFilter;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.AccountEntrySortTypeCodeType;
import com.ebay.soap.eBLBaseComponents.AccountEntryType;
import com.ebay.soap.eBLBaseComponents.AccountHistorySelectionCodeType;
import com.ebay.soap.eBLBaseComponents.AccountSummaryType;
import com.ebay.soap.eBLBaseComponents.CurrencyCodeType;
import com.ebay.soap.eBLBaseComponents.GetAccountRequestType;
import com.ebay.soap.eBLBaseComponents.GetAccountResponseType;
import com.ebay.soap.eBLBaseComponents.PaginationResultType;
import com.ebay.soap.eBLBaseComponents.PaginationType;
import java.util.Calendar;

public class GetAccountCall
extends ApiCall {
    private AccountHistorySelectionCodeType viewType = AccountHistorySelectionCodeType.LAST_INVOICE;
    private Calendar invoiceDate = null;
    private TimeFilter viewPeriod = null;
    private PaginationType pagination = null;
    private Boolean excludeBalance = null;
    private Boolean excludeSummary = null;
    private Boolean includeConversionRate = null;
    private AccountEntrySortTypeCodeType accountEntrySortType = null;
    private CurrencyCodeType currency = null;
    private String itemID = null;
    private String orderID = null;
    private String accountID = null;
    private AccountSummaryType accountSummary = null;
    private CurrencyCodeType returnedCurrency = null;
    private AccountEntryType[] accountEntries = null;
    private PaginationResultType paginationResult = null;
    private boolean hasMoreEntries = false;
    private Integer returnedEntriesPerPage = null;
    private Integer returnedPageNumber = null;

    public GetAccountCall() {
    }

    public GetAccountCall(ApiContext apiContext) {
        super(apiContext);
    }

    public AccountEntryType[] getAccount() throws ApiException, SdkException, Exception {
        GetAccountRequestType req = new GetAccountRequestType();
        if (this.viewType == null) {
            throw new SdkException("ViewType property is not set.");
        }
        if (this.viewType.equals((Object)AccountHistorySelectionCodeType.BETWEEN_SPECIFIED_DATES)) {
            if (this.viewPeriod == null) {
                throw new SdkException("GetAccountCall.ViewPeriod is not set.");
            }
        } else if (this.viewType.equals((Object)AccountHistorySelectionCodeType.SPECIFIED_INVOICE) && this.invoiceDate == null) {
            throw new SdkException("GetAccountCall.InvoiceDate is not set.");
        }
        req.setDetailLevel(this.getDetailLevel());
        if (this.viewType != null) {
            req.setAccountHistorySelection(this.viewType);
        }
        if (this.invoiceDate != null) {
            req.setInvoiceDate(this.invoiceDate);
        }
        if (this.viewPeriod != null) {
            req.setBeginDate(this.viewPeriod.getTimeFrom());
            req.setEndDate(this.viewPeriod.getTimeTo());
        }
        if (this.pagination != null) {
            req.setPagination(this.pagination);
        }
        if (this.excludeBalance != null) {
            req.setExcludeBalance(this.excludeBalance);
        }
        if (this.excludeSummary != null) {
            req.setExcludeSummary(this.excludeSummary);
        }
        if (this.includeConversionRate != null) {
            req.setIncludeConversionRate(this.includeConversionRate);
        }
        if (this.accountEntrySortType != null) {
            req.setAccountEntrySortType(this.accountEntrySortType);
        }
        if (this.currency != null) {
            req.setCurrency(this.currency);
        }
        if (this.itemID != null) {
            req.setItemID(this.itemID);
        }
        if (this.orderID != null) {
            req.setOrderID(this.orderID);
        }
        GetAccountResponseType resp = (GetAccountResponseType)this.execute((AbstractRequestType)req);
        this.accountID = resp.getAccountID();
        this.accountSummary = resp.getAccountSummary();
        this.returnedCurrency = resp.getCurrency();
        this.accountEntries = resp.getAccountEntries() == null ? null : resp.getAccountEntries().getAccountEntry();
        this.paginationResult = resp.getPaginationResult();
        this.hasMoreEntries = resp.isHasMoreEntries() == null ? false : resp.isHasMoreEntries();
        this.returnedEntriesPerPage = resp.getEntriesPerPage();
        this.returnedPageNumber = resp.getPageNumber();
        return this.getAccountEntries();
    }

    public AccountEntrySortTypeCodeType getAccountEntrySortType() {
        return this.accountEntrySortType;
    }

    public void setAccountEntrySortType(AccountEntrySortTypeCodeType accountEntrySortType) {
        this.accountEntrySortType = accountEntrySortType;
    }

    public CurrencyCodeType getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyCodeType currency) {
        this.currency = currency;
    }

    public Boolean getExcludeBalance() {
        return this.excludeBalance;
    }

    public void setExcludeBalance(Boolean excludeBalance) {
        this.excludeBalance = excludeBalance;
    }

    public Boolean getExcludeSummary() {
        return this.excludeSummary;
    }

    public void setExcludeSummary(Boolean excludeSummary) {
        this.excludeSummary = excludeSummary;
    }

    public Boolean getIncludeConversionRate() {
        return this.includeConversionRate;
    }

    public void setIncludeConversionRate(Boolean includeConversionRate) {
        this.includeConversionRate = includeConversionRate;
    }

    public Calendar getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(Calendar invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public String getOrderID() {
        return this.orderID;
    }

    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    public PaginationType getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationType pagination) {
        this.pagination = pagination;
    }

    public TimeFilter getViewPeriod() {
        return this.viewPeriod;
    }

    public void setViewPeriod(TimeFilter viewPeriod) {
        this.viewPeriod = viewPeriod;
    }

    public AccountHistorySelectionCodeType getViewType() {
        return this.viewType;
    }

    public void setViewType(AccountHistorySelectionCodeType viewType) {
        this.viewType = viewType;
    }

    public AccountEntryType[] getAccountEntries() {
        return this.accountEntries;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public AccountSummaryType getAccountSummary() {
        return this.accountSummary;
    }

    public boolean getHasMoreEntries() {
        return this.hasMoreEntries;
    }

    public PaginationResultType getPaginationResult() {
        return this.paginationResult;
    }

    public CurrencyCodeType getReturnedCurrency() {
        return this.returnedCurrency;
    }

    public Integer getReturnedEntriesPerPage() {
        return this.returnedEntriesPerPage;
    }

    public Integer getReturnedPageNumber() {
        return this.returnedPageNumber;
    }
}

