/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.Serial;
import org.xbill.DNS.TCPClient;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZoneTransferIn {
    private static final int INITIALSOA = 0;
    private static final int FIRSTDATA = 1;
    private static final int IXFR_DELSOA = 2;
    private static final int IXFR_DEL = 3;
    private static final int IXFR_ADDSOA = 4;
    private static final int IXFR_ADD = 5;
    private static final int AXFR = 6;
    private static final int END = 7;
    private Name zname;
    private int qtype;
    private int dclass;
    private long ixfr_serial;
    private boolean want_fallback;
    private ZoneTransferHandler handler;
    private SocketAddress localAddress;
    private SocketAddress address;
    private TCPClient client;
    private TSIG tsig;
    private TSIG.StreamVerifier verifier;
    private long timeout = 900000L;
    private int state;
    private long end_serial;
    private long current_serial;
    private Record initialsoa;
    private int rtype;

    private ZoneTransferIn() {
    }

    private ZoneTransferIn(Name name, int n, long l, boolean bl, SocketAddress socketAddress, TSIG tSIG) {
        this.address = socketAddress;
        this.tsig = tSIG;
        if (name.isAbsolute()) {
            this.zname = name;
        } else {
            try {
                this.zname = Name.concatenate((Name)name, (Name)Name.root);
            }
            catch (NameTooLongException nameTooLongException) {
                throw new IllegalArgumentException("ZoneTransferIn: name too long");
            }
        }
        this.qtype = n;
        this.dclass = 1;
        this.ixfr_serial = l;
        this.want_fallback = bl;
        this.state = 0;
    }

    public static ZoneTransferIn newAXFR(Name name, SocketAddress socketAddress, TSIG tSIG) {
        return new ZoneTransferIn(name, 252, 0L, false, socketAddress, tSIG);
    }

    public static ZoneTransferIn newAXFR(Name name, String string, int n, TSIG tSIG) throws UnknownHostException {
        if (n == 0) {
            n = 53;
        }
        return ZoneTransferIn.newAXFR((Name)name, (SocketAddress)new InetSocketAddress(string, n), (TSIG)tSIG);
    }

    public static ZoneTransferIn newAXFR(Name name, String string, TSIG tSIG) throws UnknownHostException {
        return ZoneTransferIn.newAXFR((Name)name, (String)string, (int)0, (TSIG)tSIG);
    }

    public static ZoneTransferIn newIXFR(Name name, long l, boolean bl, SocketAddress socketAddress, TSIG tSIG) {
        return new ZoneTransferIn(name, 251, l, bl, socketAddress, tSIG);
    }

    public static ZoneTransferIn newIXFR(Name name, long l, boolean bl, String string, int n, TSIG tSIG) throws UnknownHostException {
        if (n == 0) {
            n = 53;
        }
        return ZoneTransferIn.newIXFR((Name)name, (long)l, (boolean)bl, (SocketAddress)new InetSocketAddress(string, n), (TSIG)tSIG);
    }

    public static ZoneTransferIn newIXFR(Name name, long l, boolean bl, String string, TSIG tSIG) throws UnknownHostException {
        return ZoneTransferIn.newIXFR((Name)name, (long)l, (boolean)bl, (String)string, (int)0, (TSIG)tSIG);
    }

    public Name getName() {
        return this.zname;
    }

    public int getType() {
        return this.qtype;
    }

    public void setTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this.timeout = 1000L * (long)n;
    }

    public void setDClass(int n) {
        DClass.check((int)n);
        this.dclass = n;
    }

    public void setLocalAddress(SocketAddress socketAddress) {
        this.localAddress = socketAddress;
    }

    private void openConnection() throws IOException {
        long l = System.currentTimeMillis() + this.timeout;
        this.client = new TCPClient(l);
        if (this.localAddress != null) {
            this.client.bind(this.localAddress);
        }
        this.client.connect(this.address);
    }

    private void sendQuery() throws IOException {
        Object object;
        Record record = Record.newRecord((Name)this.zname, (int)this.qtype, (int)this.dclass);
        Message message = new Message();
        message.getHeader().setOpcode(0);
        message.addRecord(record, 0);
        if (this.qtype == 251) {
            object = new SOARecord(this.zname, this.dclass, 0L, Name.root, Name.root, this.ixfr_serial, 0L, 0L, 0L, 0L);
            message.addRecord((Record)object, 2);
        }
        if (this.tsig != null) {
            this.tsig.apply(message, null);
            this.verifier = new TSIG.StreamVerifier(this.tsig, message.getTSIG());
        }
        object = message.toWire(65535);
        this.client.send(object);
    }

    private static long getSOASerial(Record record) {
        SOARecord sOARecord = (SOARecord)record;
        return sOARecord.getSerial();
    }

    private void logxfr(String string) {
        if (Options.check((String)"verbose")) {
            System.out.println(this.zname + ": " + string);
        }
    }

    private void fail(String string) throws ZoneTransferException {
        throw new ZoneTransferException(string);
    }

    private void fallback() throws ZoneTransferException {
        if (!this.want_fallback) {
            this.fail("server doesn't support IXFR");
        }
        this.logxfr("falling back to AXFR");
        this.qtype = 252;
        this.state = 0;
    }

    private void parseRR(Record record) throws ZoneTransferException {
        int n = record.getType();
        switch (this.state) {
            case 0: {
                if (n != 6) {
                    this.fail("missing initial SOA");
                }
                this.initialsoa = record;
                this.end_serial = ZoneTransferIn.getSOASerial((Record)record);
                if (this.qtype == 251 && Serial.compare((long)this.end_serial, (long)this.ixfr_serial) <= 0) {
                    this.logxfr("up to date");
                    this.state = 7;
                    break;
                }
                this.state = 1;
                break;
            }
            case 1: {
                if (this.qtype == 251 && n == 6 && ZoneTransferIn.getSOASerial((Record)record) == this.ixfr_serial) {
                    this.rtype = 251;
                    this.handler.startIXFR();
                    this.logxfr("got incremental response");
                    this.state = 2;
                } else {
                    this.rtype = 252;
                    this.handler.startAXFR();
                    this.handler.handleRecord(this.initialsoa);
                    this.logxfr("got nonincremental response");
                    this.state = 6;
                }
                this.parseRR(record);
                return;
            }
            case 2: {
                this.handler.startIXFRDeletes(record);
                this.state = 3;
                break;
            }
            case 3: {
                if (n == 6) {
                    this.current_serial = ZoneTransferIn.getSOASerial((Record)record);
                    this.state = 4;
                    this.parseRR(record);
                    return;
                }
                this.handler.handleRecord(record);
                break;
            }
            case 4: {
                this.handler.startIXFRAdds(record);
                this.state = 5;
                break;
            }
            case 5: {
                if (n == 6) {
                    long l = ZoneTransferIn.getSOASerial((Record)record);
                    if (l == this.end_serial) {
                        this.state = 7;
                        break;
                    }
                    if (l != this.current_serial) {
                        this.fail("IXFR out of sync: expected serial " + this.current_serial + " , got " + l);
                    } else {
                        this.state = 2;
                        this.parseRR(record);
                        return;
                    }
                }
                this.handler.handleRecord(record);
                break;
            }
            case 6: {
                if (n == 1 && record.getDClass() != this.dclass) break;
                this.handler.handleRecord(record);
                if (n != 6) break;
                this.state = 7;
                break;
            }
            case 7: {
                this.fail("extra data");
                break;
            }
            default: {
                this.fail("invalid state");
            }
        }
    }

    private void closeConnection() {
        try {
            if (this.client != null) {
                this.client.cleanup();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Message parseMessage(byte[] byArray) throws WireParseException {
        try {
            return new Message(byArray);
        }
        catch (IOException iOException) {
            if (iOException instanceof WireParseException) {
                throw (WireParseException)((Object)iOException);
            }
            throw new WireParseException("Error parsing message");
        }
    }

    private void doxfr() throws IOException, ZoneTransferException {
        this.sendQuery();
        while (this.state != 7) {
            int n;
            TSIGRecord tSIGRecord;
            byte[] byArray = this.client.recv();
            Message message = this.parseMessage(byArray);
            if (message.getHeader().getRcode() == 0 && this.verifier != null) {
                tSIGRecord = message.getTSIG();
                n = this.verifier.verify(message, byArray);
                if (n != 0) {
                    this.fail("TSIG failure");
                }
            }
            tSIGRecord = message.getSectionArray(1);
            if (this.state == 0) {
                Record record;
                n = message.getRcode();
                if (n != 0) {
                    if (this.qtype == 251 && n == 4) {
                        this.fallback();
                        this.doxfr();
                        return;
                    }
                    this.fail(Rcode.string((int)n));
                }
                if ((record = message.getQuestion()) != null && record.getType() != this.qtype) {
                    this.fail("invalid question section");
                }
                if (((TSIGRecord)tSIGRecord).length == 0 && this.qtype == 251) {
                    this.fallback();
                    this.doxfr();
                    return;
                }
            }
            for (n = 0; n < ((TSIGRecord)tSIGRecord).length; ++n) {
                this.parseRR((Record)tSIGRecord[n]);
            }
            if (this.state != 7 || this.verifier == null || message.isVerified()) continue;
            this.fail("last message must be signed");
        }
    }

    public void run(ZoneTransferHandler zoneTransferHandler) throws IOException, ZoneTransferException {
        this.handler = zoneTransferHandler;
        try {
            this.openConnection();
            this.doxfr();
        }
        finally {
            this.closeConnection();
        }
    }

    public List run() throws IOException, ZoneTransferException {
        BasicHandler basicHandler = new BasicHandler();
        this.run((ZoneTransferHandler)basicHandler);
        if (basicHandler.axfr != null) {
            return basicHandler.axfr;
        }
        return basicHandler.ixfr;
    }

    private BasicHandler getBasicHandler() throws IllegalArgumentException {
        if (this.handler instanceof BasicHandler) {
            return (BasicHandler)this.handler;
        }
        throw new IllegalArgumentException("ZoneTransferIn used callback interface");
    }

    public boolean isAXFR() {
        return this.rtype == 252;
    }

    public List getAXFR() {
        BasicHandler basicHandler = this.getBasicHandler();
        return basicHandler.axfr;
    }

    public boolean isIXFR() {
        return this.rtype == 251;
    }

    public List getIXFR() {
        BasicHandler basicHandler = this.getBasicHandler();
        return basicHandler.ixfr;
    }

    public boolean isCurrent() {
        BasicHandler basicHandler = this.getBasicHandler();
        return basicHandler.axfr == null && basicHandler.ixfr == null;
    }
}

