/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

/*
 * Exception performing whole class analysis ignored.
 */
public class X25Record
extends Record {
    private static final long serialVersionUID = 4267576252335579764L;
    private byte[] address;

    X25Record() {
    }

    Record getObject() {
        return new X25Record();
    }

    private static final byte[] checkAndConvertAddress(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) {
                return null;
            }
            byArray[i] = (byte)c;
        }
        return byArray;
    }

    public X25Record(Name name, int n, long l, String string) {
        super(name, 19, n, l);
        this.address = X25Record.checkAndConvertAddress((String)string);
        if (this.address == null) {
            throw new IllegalArgumentException("invalid PSDN address " + string);
        }
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.address = dNSInput.readCountedString();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        String string = tokenizer.getString();
        this.address = X25Record.checkAndConvertAddress((String)string);
        if (this.address == null) {
            throw tokenizer.exception("invalid PSDN address " + string);
        }
    }

    public String getAddress() {
        return X25Record.byteArrayToString((byte[])this.address, (boolean)false);
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeCountedString(this.address);
    }

    String rrToString() {
        return X25Record.byteArrayToString((byte[])this.address, (boolean)true);
    }
}

