/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.security.PrivateKey;
import java.util.Date;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;

public class SIG0 {
    private static final short VALIDITY = 300;

    private SIG0() {
    }

    public static void signMessage(Message message, KEYRecord kEYRecord, PrivateKey privateKey, SIGRecord sIGRecord) throws DNSSEC.DNSSECException {
        int n = Options.intValue((String)"sig0validity");
        if (n < 0) {
            n = 300;
        }
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        Date date2 = new Date(l + (long)(n * 1000));
        SIGRecord sIGRecord2 = DNSSEC.signMessage((Message)message, (SIGRecord)sIGRecord, (KEYRecord)kEYRecord, (PrivateKey)privateKey, (Date)date, (Date)date2);
        message.addRecord((Record)sIGRecord2, 3);
    }

    public static void verifyMessage(Message message, byte[] byArray, KEYRecord kEYRecord, SIGRecord sIGRecord) throws DNSSEC.DNSSECException {
        SIGRecord sIGRecord2 = null;
        Record[] recordArray = message.getSectionArray(3);
        for (int i = 0; i < recordArray.length; ++i) {
            if (recordArray[i].getType() != 24 || ((SIGRecord)recordArray[i]).getTypeCovered() != 0) continue;
            sIGRecord2 = (SIGRecord)recordArray[i];
            break;
        }
        DNSSEC.verifyMessage((Message)message, (byte[])byArray, sIGRecord2, (SIGRecord)sIGRecord, (KEYRecord)kEYRecord);
    }
}

