/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;

public class RRset
implements Serializable {
    private static final long serialVersionUID = -3270249290171239695L;
    private List rrs;
    private short nsigs;
    private short position;

    public RRset() {
        this.rrs = new ArrayList(1);
        this.nsigs = 0;
        this.position = 0;
    }

    public RRset(Record record) {
        this();
        this.safeAddRR(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RRset(RRset rRset) {
        RRset rRset2 = rRset;
        synchronized (rRset2) {
            this.rrs = (List)((ArrayList)rRset.rrs).clone();
            this.nsigs = rRset.nsigs;
            this.position = rRset.position;
        }
    }

    private void safeAddRR(Record record) {
        if (!(record instanceof RRSIGRecord)) {
            if (this.nsigs == 0) {
                this.rrs.add(record);
            } else {
                this.rrs.add(this.rrs.size() - this.nsigs, record);
            }
        } else {
            this.rrs.add(record);
            this.nsigs = (short)(this.nsigs + 1);
        }
    }

    public synchronized void addRR(Record record) {
        if (this.rrs.size() == 0) {
            this.safeAddRR(record);
            return;
        }
        Record record2 = this.first();
        if (!record.sameRRset(record2)) {
            throw new IllegalArgumentException("record does not match rrset");
        }
        if (record.getTTL() != record2.getTTL()) {
            if (record.getTTL() > record2.getTTL()) {
                record = record.cloneRecord();
                record.setTTL(record2.getTTL());
            } else {
                for (int i = 0; i < this.rrs.size(); ++i) {
                    Record record3 = (Record)this.rrs.get(i);
                    record3 = record3.cloneRecord();
                    record3.setTTL(record.getTTL());
                    this.rrs.set(i, record3);
                }
            }
        }
        if (!this.rrs.contains(record)) {
            this.safeAddRR(record);
        }
    }

    public synchronized void deleteRR(Record record) {
        if (this.rrs.remove(record) && record instanceof RRSIGRecord) {
            this.nsigs = (short)(this.nsigs - 1);
        }
    }

    public synchronized void clear() {
        this.rrs.clear();
        this.position = 0;
        this.nsigs = 0;
    }

    private synchronized Iterator iterator(boolean bl, boolean bl2) {
        int n;
        int n2 = this.rrs.size();
        int n3 = bl ? n2 - this.nsigs : this.nsigs;
        if (n3 == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (bl) {
            if (!bl2) {
                n = 0;
            } else {
                if (this.position >= n3) {
                    this.position = 0;
                }
                short s = this.position;
                this.position = (short)(s + 1);
                n = s;
            }
        } else {
            n = n2 - this.nsigs;
        }
        ArrayList arrayList = new ArrayList(n3);
        if (bl) {
            arrayList.addAll(this.rrs.subList(n, n3));
            if (n != 0) {
                arrayList.addAll(this.rrs.subList(0, n));
            }
        } else {
            arrayList.addAll(this.rrs.subList(n, n2));
        }
        return arrayList.iterator();
    }

    public synchronized Iterator rrs(boolean bl) {
        return this.iterator(true, bl);
    }

    public synchronized Iterator rrs() {
        return this.iterator(true, true);
    }

    public synchronized Iterator sigs() {
        return this.iterator(false, false);
    }

    public synchronized int size() {
        return this.rrs.size() - this.nsigs;
    }

    public Name getName() {
        return this.first().getName();
    }

    public int getType() {
        return this.first().getRRsetType();
    }

    public int getDClass() {
        return this.first().getDClass();
    }

    public synchronized long getTTL() {
        return this.first().getTTL();
    }

    public synchronized Record first() {
        if (this.rrs.size() == 0) {
            throw new IllegalStateException("rrset is empty");
        }
        return (Record)this.rrs.get(0);
    }

    private String iteratorToString(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            stringBuffer.append("[");
            stringBuffer.append(record.rdataToString());
            stringBuffer.append("]");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.rrs.size() == 0) {
            return "{empty}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        stringBuffer.append(this.getName() + " ");
        stringBuffer.append(this.getTTL() + " ");
        stringBuffer.append(DClass.string((int)this.getDClass()) + " ");
        stringBuffer.append(Type.string((int)this.getType()) + " ");
        stringBuffer.append(this.iteratorToString(this.iterator(true, false)));
        if (this.nsigs > 0) {
            stringBuffer.append(" sigs: ");
            stringBuffer.append(this.iteratorToString(this.iterator(false, false)));
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }
}

