/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base64;

public class OPENPGPKEYRecord
extends Record {
    private static final long serialVersionUID = -1277262990243423062L;
    private byte[] cert;

    OPENPGPKEYRecord() {
    }

    Record getObject() {
        return new OPENPGPKEYRecord();
    }

    public OPENPGPKEYRecord(Name name, int n, long l, byte[] byArray) {
        super(name, 61, n, l);
        this.cert = byArray;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.cert = dNSInput.readByteArray();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.cert = tokenizer.getBase64();
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cert != null) {
            if (Options.check((String)"multiline")) {
                stringBuffer.append("(\n");
                stringBuffer.append(base64.formatString((byte[])this.cert, (int)64, (String)"\t", (boolean)true));
            } else {
                stringBuffer.append(base64.toString((byte[])this.cert));
            }
        }
        return stringBuffer.toString();
    }

    public byte[] getCert() {
        return this.cert;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeByteArray(this.cert);
    }
}

