/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.WireParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class Name
implements Comparable,
Serializable {
    private static final long serialVersionUID = -7257019940971525644L;
    private static final int LABEL_NORMAL = 0;
    private static final int LABEL_COMPRESSION = 192;
    private static final int LABEL_MASK = 192;
    private byte[] name;
    private long offsets;
    private int hashcode;
    private static final byte[] emptyLabel = new byte[]{0};
    private static final byte[] wildLabel = new byte[]{1, 42};
    public static final Name root;
    public static final Name empty;
    private static final int MAXNAME = 255;
    private static final int MAXLABEL = 63;
    private static final int MAXLABELS = 128;
    private static final int MAXOFFSETS = 7;
    private static final DecimalFormat byteFormat;
    private static final byte[] lowercase;
    private static final Name wild;

    private Name() {
    }

    private final void setoffset(int n, int n2) {
        if (n >= 7) {
            return;
        }
        int n3 = 8 * (7 - n);
        this.offsets &= 255L << n3 ^ 0xFFFFFFFFFFFFFFFFL;
        this.offsets |= (long)n2 << n3;
    }

    private final int offset(int n) {
        if (n == 0 && this.getlabels() == 0) {
            return 0;
        }
        if (n < 0 || n >= this.getlabels()) {
            throw new IllegalArgumentException("label out of range");
        }
        if (n < 7) {
            int n2 = 8 * (7 - n);
            return (int)(this.offsets >>> n2) & 0xFF;
        }
        int n3 = this.offset(6);
        for (int i = 6; i < n; ++i) {
            n3 += this.name[n3] + 1;
        }
        return n3;
    }

    private final void setlabels(int n) {
        this.offsets &= 0xFFFFFFFFFFFFFF00L;
        this.offsets |= (long)n;
    }

    private final int getlabels() {
        return (int)(this.offsets & 0xFFL);
    }

    private static final void copy(Name name, Name name2) {
        if (name.offset(0) == 0) {
            name2.name = name.name;
            name2.offsets = name.offsets;
        } else {
            int n = name.offset(0);
            int n2 = name.name.length - n;
            int n3 = name.labels();
            name2.name = new byte[n2];
            System.arraycopy(name.name, n, name2.name, 0, n2);
            for (int i = 0; i < n3 && i < 7; ++i) {
                name2.setoffset(i, name.offset(i) - n);
            }
            name2.setlabels(n3);
        }
    }

    private final void append(byte[] byArray, int n, int n2) throws NameTooLongException {
        int n3;
        int n4;
        int n5 = this.name == null ? 0 : this.name.length - this.offset(0);
        int n6 = 0;
        int n7 = n;
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = byArray[n7];
            if (n3 > 63) {
                throw new IllegalStateException("invalid label");
            }
            n7 += ++n3;
            n6 += n3;
        }
        n4 = n5 + n6;
        if (n4 > 255) {
            throw new NameTooLongException();
        }
        n7 = this.getlabels();
        n3 = n7 + n2;
        if (n3 > 128) {
            throw new IllegalStateException("too many labels");
        }
        byte[] byArray2 = new byte[n4];
        if (n5 != 0) {
            System.arraycopy(this.name, this.offset(0), byArray2, 0, n5);
        }
        System.arraycopy(byArray, n, byArray2, n5, n6);
        this.name = byArray2;
        int n8 = n5;
        for (int i = 0; i < n2; ++i) {
            this.setoffset(n7 + i, n8);
            n8 += byArray2[n8] + 1;
        }
        this.setlabels(n3);
    }

    private static TextParseException parseException(String string, String string2) {
        return new TextParseException("'" + string + "': " + string2);
    }

    private final void appendFromString(String string, byte[] byArray, int n, int n2) throws TextParseException {
        try {
            this.append(byArray, n, n2);
        }
        catch (NameTooLongException nameTooLongException) {
            throw Name.parseException((String)string, (String)"Name too long");
        }
    }

    private final void appendSafe(byte[] byArray, int n, int n2) {
        try {
            this.append(byArray, n, n2);
        }
        catch (NameTooLongException nameTooLongException) {
            // empty catch block
        }
    }

    public Name(String string, Name name) throws TextParseException {
        if (string.equals("")) {
            throw Name.parseException((String)string, (String)"empty name");
        }
        if (string.equals("@")) {
            if (name == null) {
                Name.copy((Name)empty, (Name)this);
            } else {
                Name.copy((Name)name, (Name)this);
            }
            return;
        }
        if (string.equals(".")) {
            Name.copy((Name)root, (Name)this);
            return;
        }
        int n = -1;
        int n2 = 1;
        byte[] byArray = new byte[64];
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            byte by = (byte)string.charAt(i);
            if (bl) {
                if (by >= 48 && by <= 57 && n3 < 3) {
                    ++n3;
                    n4 *= 10;
                    if ((n4 += by - 48) > 255) {
                        throw Name.parseException((String)string, (String)"bad escape");
                    }
                    if (n3 < 3) continue;
                    by = (byte)n4;
                } else if (n3 > 0 && n3 < 3) {
                    throw Name.parseException((String)string, (String)"bad escape");
                }
                if (n2 > 63) {
                    throw Name.parseException((String)string, (String)"label too long");
                }
                n = n2;
                byArray[n2++] = by;
                bl = false;
                continue;
            }
            if (by == 92) {
                bl = true;
                n3 = 0;
                n4 = 0;
                continue;
            }
            if (by == 46) {
                if (n == -1) {
                    throw Name.parseException((String)string, (String)"invalid empty label");
                }
                byArray[0] = (byte)(n2 - 1);
                this.appendFromString(string, byArray, 0, 1);
                n = -1;
                n2 = 1;
                continue;
            }
            if (n == -1) {
                n = i;
            }
            if (n2 > 63) {
                throw Name.parseException((String)string, (String)"label too long");
            }
            byArray[n2++] = by;
        }
        if (n3 > 0 && n3 < 3) {
            throw Name.parseException((String)string, (String)"bad escape");
        }
        if (bl) {
            throw Name.parseException((String)string, (String)"bad escape");
        }
        if (n == -1) {
            this.appendFromString(string, emptyLabel, 0, 1);
            bl2 = true;
        } else {
            byArray[0] = (byte)(n2 - 1);
            this.appendFromString(string, byArray, 0, 1);
        }
        if (name != null && !bl2) {
            this.appendFromString(string, name.name, name.offset(0), name.getlabels());
        }
    }

    public Name(String string) throws TextParseException {
        this(string, null);
    }

    public static Name fromString(String string, Name name) throws TextParseException {
        if (string.equals("@") && name != null) {
            return name;
        }
        if (string.equals(".")) {
            return root;
        }
        return new Name(string, name);
    }

    public static Name fromString(String string) throws TextParseException {
        return Name.fromString((String)string, null);
    }

    public static Name fromConstantString(String string) {
        try {
            return Name.fromString((String)string, null);
        }
        catch (TextParseException textParseException) {
            throw new IllegalArgumentException("Invalid name '" + string + "'");
        }
    }

    public Name(DNSInput dNSInput) throws WireParseException {
        boolean bl = false;
        byte[] byArray = new byte[64];
        boolean bl2 = false;
        block4: while (!bl) {
            int n = dNSInput.readU8();
            switch (n & 0xC0) {
                case 0: {
                    if (this.getlabels() >= 128) {
                        throw new WireParseException("too many labels");
                    }
                    if (n == 0) {
                        this.append(emptyLabel, 0, 1);
                        bl = true;
                        continue block4;
                    }
                    byArray[0] = (byte)n;
                    dNSInput.readByteArray(byArray, 1, n);
                    this.append(byArray, 0, 1);
                    continue block4;
                }
                case 192: {
                    int n2 = dNSInput.readU8();
                    n2 += (n & 0xFFFFFF3F) << 8;
                    if (Options.check((String)"verbosecompression")) {
                        System.err.println("currently " + dNSInput.current() + ", pointer to " + n2);
                    }
                    if (n2 >= dNSInput.current() - 2) {
                        throw new WireParseException("bad compression");
                    }
                    if (!bl2) {
                        dNSInput.save();
                        bl2 = true;
                    }
                    dNSInput.jump(n2);
                    if (!Options.check((String)"verbosecompression")) continue block4;
                    System.err.println("current name '" + this + "', seeking to " + n2);
                    continue block4;
                }
            }
            throw new WireParseException("bad label type");
        }
        if (bl2) {
            dNSInput.restore();
        }
    }

    public Name(byte[] byArray) throws IOException {
        this(new DNSInput(byArray));
    }

    public Name(Name name, int n) {
        int n2 = name.labels();
        if (n > n2) {
            throw new IllegalArgumentException("attempted to remove too many labels");
        }
        this.name = name.name;
        this.setlabels(n2 - n);
        for (int i = 0; i < 7 && i < n2 - n; ++i) {
            this.setoffset(i, name.offset(i + n));
        }
    }

    public static Name concatenate(Name name, Name name2) throws NameTooLongException {
        if (name.isAbsolute()) {
            return name;
        }
        Name name3 = new Name();
        Name.copy((Name)name, (Name)name3);
        name3.append(name2.name, name2.offset(0), name2.getlabels());
        return name3;
    }

    public Name relativize(Name name) {
        if (name == null || !this.subdomain(name)) {
            return this;
        }
        Name name2 = new Name();
        Name.copy((Name)this, (Name)name2);
        int n = this.length() - name.length();
        int n2 = name2.labels() - name.labels();
        name2.setlabels(n2);
        name2.name = new byte[n];
        System.arraycopy(this.name, this.offset(0), name2.name, 0, n);
        return name2;
    }

    public Name wild(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("must replace 1 or more labels");
        }
        try {
            Name name = new Name();
            Name.copy((Name)wild, (Name)name);
            name.append(this.name, this.offset(n), this.getlabels() - n);
            return name;
        }
        catch (NameTooLongException nameTooLongException) {
            throw new IllegalStateException("Name.wild: concatenate failed");
        }
    }

    public Name canonicalize() {
        boolean bl = true;
        for (int i = 0; i < this.name.length; ++i) {
            if (lowercase[this.name[i] & 0xFF] == this.name[i]) continue;
            bl = false;
            break;
        }
        if (bl) {
            return this;
        }
        Name name = new Name();
        name.appendSafe(this.name, this.offset(0), this.getlabels());
        for (int i = 0; i < name.name.length; ++i) {
            name.name[i] = lowercase[name.name[i] & 0xFF];
        }
        return name;
    }

    public Name fromDNAME(DNAMERecord dNAMERecord) throws NameTooLongException {
        Name name = dNAMERecord.getName();
        Name name2 = dNAMERecord.getTarget();
        if (!this.subdomain(name)) {
            return null;
        }
        int n = this.labels() - name.labels();
        int n2 = this.length() - name.length();
        int n3 = this.offset(0);
        int n4 = name2.labels();
        short s = name2.length();
        if (n2 + s > 255) {
            throw new NameTooLongException();
        }
        Name name3 = new Name();
        name3.setlabels(n + n4);
        name3.name = new byte[n2 + s];
        System.arraycopy(this.name, n3, name3.name, 0, n2);
        System.arraycopy(name2.name, 0, name3.name, n2, s);
        int n5 = 0;
        for (int i = 0; i < 7 && i < n + n4; ++i) {
            name3.setoffset(i, n5);
            n5 += name3.name[n5] + 1;
        }
        return name3;
    }

    public boolean isWild() {
        if (this.labels() == 0) {
            return false;
        }
        return this.name[0] == 1 && this.name[1] == 42;
    }

    public boolean isAbsolute() {
        int n = this.labels();
        if (n == 0) {
            return false;
        }
        return this.name[this.offset(n - 1)] == 0;
    }

    public short length() {
        if (this.getlabels() == 0) {
            return 0;
        }
        return (short)(this.name.length - this.offset(0));
    }

    public int labels() {
        return this.getlabels();
    }

    public boolean subdomain(Name name) {
        int n = this.labels();
        int n2 = name.labels();
        if (n2 > n) {
            return false;
        }
        if (n2 == n) {
            return this.equals((Object)name);
        }
        return name.equals(this.name, this.offset(n - n2));
    }

    private String byteString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = byArray[n++];
        for (int i = n; i < n + by; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (n2 <= 32 || n2 >= 127) {
                stringBuffer.append('\\');
                stringBuffer.append(byteFormat.format(n2));
                continue;
            }
            if (n2 == 34 || n2 == 40 || n2 == 41 || n2 == 46 || n2 == 59 || n2 == 92 || n2 == 64 || n2 == 36) {
                stringBuffer.append('\\');
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public String toString(boolean bl) {
        int n = this.labels();
        if (n == 0) {
            return "@";
        }
        if (n == 1 && this.name[this.offset(0)] == 0) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.offset(0);
        for (int i = 0; i < n; ++i) {
            byte by = this.name[n2];
            if (by > 63) {
                throw new IllegalStateException("invalid label");
            }
            if (by == 0) {
                if (bl) break;
                stringBuffer.append('.');
                break;
            }
            if (i > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.byteString(this.name, n2));
            n2 += 1 + by;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] getLabel(int n) {
        int n2 = this.offset(n);
        byte by = (byte)(this.name[n2] + 1);
        byte[] byArray = new byte[by];
        System.arraycopy(this.name, n2, byArray, 0, by);
        return byArray;
    }

    public String getLabelString(int n) {
        int n2 = this.offset(n);
        return this.byteString(this.name, n2);
    }

    public void toWire(DNSOutput dNSOutput, Compression compression) {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("toWire() called on non-absolute name");
        }
        int n = this.labels();
        for (int i = 0; i < n - 1; ++i) {
            Name name = i == 0 ? this : new Name(this, i);
            int n2 = -1;
            if (compression != null) {
                n2 = compression.get(name);
            }
            if (n2 >= 0) {
                dNSOutput.writeU16(n2 |= 0xC000);
                return;
            }
            if (compression != null) {
                compression.add(dNSOutput.current(), name);
            }
            int n3 = this.offset(i);
            dNSOutput.writeByteArray(this.name, n3, this.name[n3] + 1);
        }
        dNSOutput.writeU8(0);
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput, null);
        return dNSOutput.toByteArray();
    }

    public void toWireCanonical(DNSOutput dNSOutput) {
        byte[] byArray = this.toWireCanonical();
        dNSOutput.writeByteArray(byArray);
    }

    public byte[] toWireCanonical() {
        int n = this.labels();
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.name.length - this.offset(0)];
        int n2 = this.offset(0);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = this.name[n2];
            if (n4 > 63) {
                throw new IllegalStateException("invalid label");
            }
            byArray[n3++] = this.name[n2++];
            for (int j = 0; j < n4; ++j) {
                byArray[n3++] = lowercase[this.name[n2++] & 0xFF];
            }
        }
        return byArray;
    }

    public void toWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        if (bl) {
            this.toWireCanonical(dNSOutput);
        } else {
            this.toWire(dNSOutput, compression);
        }
    }

    private final boolean equals(byte[] byArray, int n) {
        int n2 = this.labels();
        int n3 = this.offset(0);
        for (int i = 0; i < n2; ++i) {
            if (this.name[n3] != byArray[n]) {
                return false;
            }
            int n4 = this.name[n3++];
            ++n;
            if (n4 > 63) {
                throw new IllegalStateException("invalid label");
            }
            for (int j = 0; j < n4; ++j) {
                if (lowercase[this.name[n3++] & 0xFF] == lowercase[byArray[n++] & 0xFF]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        if (name.hashcode == 0) {
            name.hashCode();
        }
        if (this.hashcode == 0) {
            this.hashCode();
        }
        if (name.hashcode != this.hashcode) {
            return false;
        }
        if (name.labels() != this.labels()) {
            return false;
        }
        return this.equals(name.name, name.offset(0));
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        int n = 0;
        for (int i = this.offset(0); i < this.name.length; ++i) {
            n += (n << 3) + lowercase[this.name[i] & 0xFF];
        }
        this.hashcode = n;
        return this.hashcode;
    }

    public int compareTo(Object object) {
        int n;
        Name name = (Name)object;
        if (this == name) {
            return 0;
        }
        int n2 = this.labels();
        int n3 = n2 > (n = name.labels()) ? n : n2;
        for (int i = 1; i <= n3; ++i) {
            int n4 = this.offset(n2 - i);
            int n5 = name.offset(n - i);
            int n6 = this.name[n4];
            byte by = name.name[n5];
            for (int j = 0; j < n6 && j < by; ++j) {
                int n7 = lowercase[this.name[j + n4 + 1] & 0xFF] - lowercase[name.name[j + n5 + 1] & 0xFF];
                if (n7 == 0) continue;
                return n7;
            }
            if (n6 == by) continue;
            return n6 - by;
        }
        return n2 - n;
    }

    static {
        byteFormat = new DecimalFormat();
        lowercase = new byte[256];
        byteFormat.setMinimumIntegerDigits(3);
        for (int i = 0; i < lowercase.length; ++i) {
            Name.lowercase[i] = i < 65 || i > 90 ? (byte)i : (byte)(i - 65 + 97);
        }
        root = new Name();
        root.appendSafe(emptyLabel, 0, 1);
        empty = new Name();
        Name.empty.name = new byte[0];
        wild = new Name();
        wild.appendSafe(wildLabel, 0, 1);
    }
}

