/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base16;

/*
 * Exception performing whole class analysis ignored.
 */
public class NSAPRecord
extends Record {
    private static final long serialVersionUID = -1037209403185658593L;
    private byte[] address;

    NSAPRecord() {
    }

    Record getObject() {
        return new NSAPRecord();
    }

    private static final byte[] checkAndConvertAddress(String string) {
        if (!string.substring(0, 2).equalsIgnoreCase("0x")) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        for (int i = 2; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') continue;
            int n2 = Character.digit(c, 16);
            if (n2 == -1) {
                return null;
            }
            if (bl) {
                byteArrayOutputStream.write(n += n2);
                bl = false;
                continue;
            }
            n = n2 << 4;
            bl = true;
        }
        if (bl) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public NSAPRecord(Name name, int n, long l, String string) {
        super(name, 22, n, l);
        this.address = NSAPRecord.checkAndConvertAddress((String)string);
        if (this.address == null) {
            throw new IllegalArgumentException("invalid NSAP address " + string);
        }
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.address = dNSInput.readByteArray();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        String string = tokenizer.getString();
        this.address = NSAPRecord.checkAndConvertAddress((String)string);
        if (this.address == null) {
            throw tokenizer.exception("invalid NSAP address " + string);
        }
    }

    public String getAddress() {
        return NSAPRecord.byteArrayToString((byte[])this.address, (boolean)false);
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeByteArray(this.address);
    }

    String rrToString() {
        return "0x" + base16.toString((byte[])this.address);
    }
}

