/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.security.PublicKey;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.base64;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class KEYBase
extends Record {
    private static final long serialVersionUID = 3469321722693285454L;
    protected int flags;
    protected int proto;
    protected int alg;
    protected byte[] key;
    protected int footprint = -1;
    protected PublicKey publicKey = null;

    protected KEYBase() {
    }

    public KEYBase(Name name, int n, int n2, long l, int n3, int n4, int n5, byte[] byArray) {
        super(name, n, n2, l);
        this.flags = KEYBase.checkU16((String)"flags", (int)n3);
        this.proto = KEYBase.checkU8((String)"proto", (int)n4);
        this.alg = KEYBase.checkU8((String)"alg", (int)n5);
        this.key = byArray;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.flags = dNSInput.readU16();
        this.proto = dNSInput.readU8();
        this.alg = dNSInput.readU8();
        if (dNSInput.remaining() > 0) {
            this.key = dNSInput.readByteArray();
        }
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.flags);
        stringBuffer.append(" ");
        stringBuffer.append(this.proto);
        stringBuffer.append(" ");
        stringBuffer.append(this.alg);
        if (this.key != null) {
            if (Options.check((String)"multiline")) {
                stringBuffer.append(" (\n");
                stringBuffer.append(base64.formatString((byte[])this.key, (int)64, (String)"\t", (boolean)true));
                stringBuffer.append(" ; key_tag = ");
                stringBuffer.append(this.getFootprint());
            } else {
                stringBuffer.append(" ");
                stringBuffer.append(base64.toString((byte[])this.key));
            }
        }
        return stringBuffer.toString();
    }

    public int getFlags() {
        return this.flags;
    }

    public int getProtocol() {
        return this.proto;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getFootprint() {
        if (this.footprint >= 0) {
            return this.footprint;
        }
        int n = 0;
        DNSOutput dNSOutput = new DNSOutput();
        this.rrToWire(dNSOutput, null, false);
        byte[] byArray = dNSOutput.toByteArray();
        if (this.alg == 1) {
            int n2 = byArray[byArray.length - 3] & 0xFF;
            int n3 = byArray[byArray.length - 2] & 0xFF;
            n = (n2 << 8) + n3;
        } else {
            int n4;
            int n5;
            for (n5 = 0; n5 < byArray.length - 1; n5 += 2) {
                n4 = byArray[n5] & 0xFF;
                int n6 = byArray[n5 + 1] & 0xFF;
                n += (n4 << 8) + n6;
            }
            if (n5 < byArray.length) {
                n4 = byArray[n5] & 0xFF;
                n += n4 << 8;
            }
            n += n >> 16 & 0xFFFF;
        }
        this.footprint = n & 0xFFFF;
        return this.footprint;
    }

    public PublicKey getPublicKey() throws DNSSEC.DNSSECException {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = DNSSEC.toPublicKey((KEYBase)this);
        return this.publicKey;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU16(this.flags);
        dNSOutput.writeU8(this.proto);
        dNSOutput.writeU8(this.alg);
        if (this.key != null) {
            dNSOutput.writeByteArray(this.key);
        }
    }
}

