/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

/*
 * Exception performing whole class analysis ignored.
 */
public class HINFORecord
extends Record {
    private static final long serialVersionUID = -4732870630947452112L;
    private byte[] cpu;
    private byte[] os;

    HINFORecord() {
    }

    Record getObject() {
        return new HINFORecord();
    }

    public HINFORecord(Name name, int n, long l, String string, String string2) {
        super(name, 13, n, l);
        try {
            this.cpu = HINFORecord.byteArrayFromString((String)string);
            this.os = HINFORecord.byteArrayFromString((String)string2);
        }
        catch (TextParseException textParseException) {
            throw new IllegalArgumentException(textParseException.getMessage());
        }
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.cpu = dNSInput.readCountedString();
        this.os = dNSInput.readCountedString();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        try {
            this.cpu = HINFORecord.byteArrayFromString((String)tokenizer.getString());
            this.os = HINFORecord.byteArrayFromString((String)tokenizer.getString());
        }
        catch (TextParseException textParseException) {
            throw tokenizer.exception(textParseException.getMessage());
        }
    }

    public String getCPU() {
        return HINFORecord.byteArrayToString((byte[])this.cpu, (boolean)false);
    }

    public String getOS() {
        return HINFORecord.byteArrayToString((byte[])this.os, (boolean)false);
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeCountedString(this.cpu);
        dNSOutput.writeCountedString(this.os);
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HINFORecord.byteArrayToString((byte[])this.cpu, (boolean)true));
        stringBuffer.append(" ");
        stringBuffer.append(HINFORecord.byteArrayToString((byte[])this.os, (boolean)true));
        return stringBuffer.toString();
    }
}

