/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

/*
 * Exception performing whole class analysis ignored.
 */
public class Generator {
    public long start;
    public long end;
    public long step;
    public final String namePattern;
    public final int type;
    public final int dclass;
    public final long ttl;
    public final String rdataPattern;
    public final Name origin;
    private long current;

    public static boolean supportedType(int n) {
        Type.check((int)n);
        return n == 12 || n == 5 || n == 39 || n == 1 || n == 28 || n == 2;
    }

    public Generator(long l, long l2, long l3, String string, int n, int n2, long l4, String string2, Name name) {
        if (l < 0L || l2 < 0L || l > l2 || l3 <= 0L) {
            throw new IllegalArgumentException("invalid range specification");
        }
        if (!Generator.supportedType((int)n)) {
            throw new IllegalArgumentException("unsupported type");
        }
        DClass.check((int)n2);
        this.start = l;
        this.end = l2;
        this.step = l3;
        this.namePattern = string;
        this.type = n;
        this.dclass = n2;
        this.ttl = l4;
        this.rdataPattern = string2;
        this.origin = name;
        this.current = l;
    }

    private String substitute(String string, long l) throws IOException {
        boolean bl = false;
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            if (bl) {
                stringBuffer.append(c);
                bl = false;
                continue;
            }
            if (c == '\\') {
                if (i + 1 == byArray.length) {
                    throw new TextParseException("invalid escape character");
                }
                bl = true;
                continue;
            }
            if (c == '$') {
                long l2;
                boolean bl2 = false;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 10L;
                boolean bl3 = false;
                if (i + 1 < byArray.length && byArray[i + 1] == 36) {
                    c = (char)(byArray[++i] & 0xFF);
                    stringBuffer.append(c);
                    continue;
                }
                if (i + 1 < byArray.length && byArray[i + 1] == 123) {
                    if (++i + 1 < byArray.length && byArray[i + 1] == 45) {
                        bl2 = true;
                        ++i;
                    }
                    while (i + 1 < byArray.length && (c = (char)(byArray[++i] & 0xFF)) != ',' && c != '}') {
                        if (c < '0' || c > '9') {
                            throw new TextParseException("invalid offset");
                        }
                        c = (char)(c - 48);
                        l3 *= 10L;
                        l3 += (long)c;
                    }
                    if (bl2) {
                        l3 = -l3;
                    }
                    if (c == ',') {
                        while (i + 1 < byArray.length && (c = (char)(byArray[++i] & 0xFF)) != ',' && c != '}') {
                            if (c < '0' || c > '9') {
                                throw new TextParseException("invalid width");
                            }
                            c = (char)(c - 48);
                            l4 *= 10L;
                            l4 += (long)c;
                        }
                    }
                    if (c == ',') {
                        if (i + 1 == byArray.length) {
                            throw new TextParseException("invalid base");
                        }
                        if ((c = (char)(byArray[++i] & 0xFF)) == 'o') {
                            l5 = 8L;
                        } else if (c == 'x') {
                            l5 = 16L;
                        } else if (c == 'X') {
                            l5 = 16L;
                            bl3 = true;
                        } else if (c != 'd') {
                            throw new TextParseException("invalid base");
                        }
                    }
                    if (i + 1 == byArray.length || byArray[i + 1] != 125) {
                        throw new TextParseException("invalid modifiers");
                    }
                    ++i;
                }
                if ((l2 = l + l3) < 0L) {
                    throw new TextParseException("invalid offset expansion");
                }
                String string2 = l5 == 8L ? Long.toOctalString(l2) : (l5 == 16L ? Long.toHexString(l2) : Long.toString(l2));
                if (bl3) {
                    string2 = string2.toUpperCase();
                }
                if (l4 != 0L && l4 > (long)string2.length()) {
                    int n = (int)l4 - string2.length();
                    while (n-- > 0) {
                        stringBuffer.append('0');
                    }
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public Record nextRecord() throws IOException {
        if (this.current > this.end) {
            return null;
        }
        String string = this.substitute(this.namePattern, this.current);
        Name name = Name.fromString((String)string, (Name)this.origin);
        String string2 = this.substitute(this.rdataPattern, this.current);
        this.current += this.step;
        return Record.fromString((Name)name, (int)this.type, (int)this.dclass, (long)this.ttl, (String)string2, (Name)this.origin);
    }

    public Record[] expand() throws IOException {
        ArrayList<Record> arrayList = new ArrayList<Record>();
        for (long i = this.start; i < this.end; i += this.step) {
            String string = this.substitute(this.namePattern, this.current);
            Name name = Name.fromString((String)string, (Name)this.origin);
            String string2 = this.substitute(this.rdataPattern, this.current);
            arrayList.add(Record.fromString((Name)name, (int)this.type, (int)this.dclass, (long)this.ttl, (String)string2, (Name)this.origin));
        }
        return arrayList.toArray(new Record[arrayList.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("$GENERATE ");
        stringBuffer.append(this.start + "-" + this.end);
        if (this.step > 1L) {
            stringBuffer.append("/" + this.step);
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.namePattern + " ");
        stringBuffer.append(this.ttl + " ");
        if (this.dclass != 1 || !Options.check((String)"noPrintIN")) {
            stringBuffer.append(DClass.string((int)this.dclass) + " ");
        }
        stringBuffer.append(Type.string((int)this.type) + " ");
        stringBuffer.append(this.rdataPattern + " ");
        return stringBuffer.toString();
    }
}

