/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class GPOSRecord
extends Record {
    private static final long serialVersionUID = -6349714958085750705L;
    private byte[] latitude;
    private byte[] longitude;
    private byte[] altitude;

    GPOSRecord() {
    }

    Record getObject() {
        return new GPOSRecord();
    }

    private void validate(double d, double d2) throws IllegalArgumentException {
        if (d < -90.0 || d > 90.0) {
            throw new IllegalArgumentException("illegal longitude " + d);
        }
        if (d2 < -180.0 || d2 > 180.0) {
            throw new IllegalArgumentException("illegal latitude " + d2);
        }
    }

    public GPOSRecord(Name name, int n, long l, double d, double d2, double d3) {
        super(name, 27, n, l);
        this.validate(d, d2);
        this.longitude = Double.toString(d).getBytes();
        this.latitude = Double.toString(d2).getBytes();
        this.altitude = Double.toString(d3).getBytes();
    }

    public GPOSRecord(Name name, int n, long l, String string, String string2, String string3) {
        super(name, 27, n, l);
        try {
            this.longitude = GPOSRecord.byteArrayFromString((String)string);
            this.latitude = GPOSRecord.byteArrayFromString((String)string2);
            this.validate(this.getLongitude(), this.getLatitude());
            this.altitude = GPOSRecord.byteArrayFromString((String)string3);
        }
        catch (TextParseException textParseException) {
            throw new IllegalArgumentException(textParseException.getMessage());
        }
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.longitude = dNSInput.readCountedString();
        this.latitude = dNSInput.readCountedString();
        this.altitude = dNSInput.readCountedString();
        try {
            this.validate(this.getLongitude(), this.getLatitude());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new WireParseException(illegalArgumentException.getMessage());
        }
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        try {
            this.longitude = GPOSRecord.byteArrayFromString((String)tokenizer.getString());
            this.latitude = GPOSRecord.byteArrayFromString((String)tokenizer.getString());
            this.altitude = GPOSRecord.byteArrayFromString((String)tokenizer.getString());
        }
        catch (TextParseException textParseException) {
            throw tokenizer.exception(textParseException.getMessage());
        }
        try {
            this.validate(this.getLongitude(), this.getLatitude());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new WireParseException(illegalArgumentException.getMessage());
        }
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GPOSRecord.byteArrayToString((byte[])this.longitude, (boolean)true));
        stringBuffer.append(" ");
        stringBuffer.append(GPOSRecord.byteArrayToString((byte[])this.latitude, (boolean)true));
        stringBuffer.append(" ");
        stringBuffer.append(GPOSRecord.byteArrayToString((byte[])this.altitude, (boolean)true));
        return stringBuffer.toString();
    }

    public String getLongitudeString() {
        return GPOSRecord.byteArrayToString((byte[])this.longitude, (boolean)false);
    }

    public double getLongitude() {
        return Double.parseDouble(this.getLongitudeString());
    }

    public String getLatitudeString() {
        return GPOSRecord.byteArrayToString((byte[])this.latitude, (boolean)false);
    }

    public double getLatitude() {
        return Double.parseDouble(this.getLatitudeString());
    }

    public String getAltitudeString() {
        return GPOSRecord.byteArrayToString((byte[])this.altitude, (boolean)false);
    }

    public double getAltitude() {
        return Double.parseDouble(this.getAltitudeString());
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeCountedString(this.longitude);
        dNSOutput.writeCountedString(this.latitude);
        dNSOutput.writeCountedString(this.altitude);
    }
}

