/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;

public class ExtendedResolver
implements Resolver {
    private static final int quantum = 5;
    private List resolvers;
    private boolean loadBalance = false;
    private int lbStart = 0;
    private int retries = 3;

    private void init() {
        this.resolvers = new ArrayList();
    }

    public ExtendedResolver() throws UnknownHostException {
        this.init();
        String[] stringArray = ResolverConfig.getCurrentConfig().servers();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                SimpleResolver simpleResolver = new SimpleResolver(stringArray[i]);
                simpleResolver.setTimeout(5);
                this.resolvers.add(simpleResolver);
            }
        } else {
            this.resolvers.add(new SimpleResolver());
        }
    }

    public ExtendedResolver(String[] stringArray) throws UnknownHostException {
        this.init();
        for (int i = 0; i < stringArray.length; ++i) {
            SimpleResolver simpleResolver = new SimpleResolver(stringArray[i]);
            simpleResolver.setTimeout(5);
            this.resolvers.add(simpleResolver);
        }
    }

    public ExtendedResolver(Resolver[] resolverArray) throws UnknownHostException {
        this.init();
        for (int i = 0; i < resolverArray.length; ++i) {
            this.resolvers.add(resolverArray[i]);
        }
    }

    public void setPort(int n) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setPort(n);
        }
    }

    public void setTCP(boolean bl) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTCP(bl);
        }
    }

    public void setIgnoreTruncation(boolean bl) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setIgnoreTruncation(bl);
        }
    }

    public void setEDNS(int n) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setEDNS(n);
        }
    }

    public void setEDNS(int n, int n2, int n3, List list) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setEDNS(n, n2, n3, list);
        }
    }

    public void setTSIGKey(TSIG tSIG) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTSIGKey(tSIG);
        }
    }

    public void setTimeout(int n, int n2) {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ((Resolver)this.resolvers.get(i)).setTimeout(n, n2);
        }
    }

    public void setTimeout(int n) {
        this.setTimeout(n, 0);
    }

    public Message send(Message message) throws IOException {
        Resolution resolution = new Resolution(this, message);
        return resolution.start();
    }

    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Resolution resolution = new Resolution(this, message);
        resolution.startAsync(resolverListener);
        return resolution;
    }

    public Resolver getResolver(int n) {
        if (n < this.resolvers.size()) {
            return (Resolver)this.resolvers.get(n);
        }
        return null;
    }

    public Resolver[] getResolvers() {
        return this.resolvers.toArray(new Resolver[this.resolvers.size()]);
    }

    public void addResolver(Resolver resolver) {
        this.resolvers.add(resolver);
    }

    public void deleteResolver(Resolver resolver) {
        this.resolvers.remove(resolver);
    }

    public void setLoadBalance(boolean bl) {
        this.loadBalance = bl;
    }

    public void setRetries(int n) {
        this.retries = n;
    }
}

