/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.Header;
import org.xbill.DNS.KEYBase;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGBase;
import org.xbill.DNS.SIGRecord;

/*
 * Exception performing whole class analysis ignored.
 */
public class DNSSEC {
    private static final ECKeyInfo GOST = new ECKeyInfo(32, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD97", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD94", "A6", "1", "8D91E471E0989CDA27DF505A453F2B7635294F2DDF23E3B122ACC99C9E9F1E14", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF6C611070995AD10045841B09B761B893");
    private static final ECKeyInfo ECDSA_P256 = new ECKeyInfo(32, "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", "5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", "6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", "4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", "FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551");
    private static final ECKeyInfo ECDSA_P384 = new ECKeyInfo(48, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", "3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973");
    private static final int ASN1_SEQ = 48;
    private static final int ASN1_INT = 2;
    private static final int DSA_LEN = 20;

    private DNSSEC() {
    }

    private static void digestSIG(DNSOutput dNSOutput, SIGBase sIGBase) {
        dNSOutput.writeU16(sIGBase.getTypeCovered());
        dNSOutput.writeU8(sIGBase.getAlgorithm());
        dNSOutput.writeU8(sIGBase.getLabels());
        dNSOutput.writeU32(sIGBase.getOrigTTL());
        dNSOutput.writeU32(sIGBase.getExpire().getTime() / 1000L);
        dNSOutput.writeU32(sIGBase.getTimeSigned().getTime() / 1000L);
        dNSOutput.writeU16(sIGBase.getFootprint());
        sIGBase.getSigner().toWireCanonical(dNSOutput);
    }

    public static byte[] digestRRset(RRSIGRecord rRSIGRecord, RRset rRset) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG((DNSOutput)dNSOutput, (SIGBase)rRSIGRecord);
        int n = rRset.size();
        Object[] objectArray = new Record[n];
        Iterator iterator = rRset.rrs();
        Name name = rRset.getName();
        Name name2 = null;
        int n2 = rRSIGRecord.getLabels() + 1;
        if (name.labels() > n2) {
            name2 = name.wild(name.labels() - n2);
        }
        while (iterator.hasNext()) {
            objectArray[--n] = (Record)iterator.next();
        }
        Arrays.sort(objectArray);
        DNSOutput dNSOutput2 = new DNSOutput();
        if (name2 != null) {
            name2.toWireCanonical(dNSOutput2);
        } else {
            name.toWireCanonical(dNSOutput2);
        }
        dNSOutput2.writeU16(rRset.getType());
        dNSOutput2.writeU16(rRset.getDClass());
        dNSOutput2.writeU32(rRSIGRecord.getOrigTTL());
        for (int i = 0; i < objectArray.length; ++i) {
            dNSOutput.writeByteArray(dNSOutput2.toByteArray());
            int n3 = dNSOutput.current();
            dNSOutput.writeU16(0);
            dNSOutput.writeByteArray(objectArray[i].rdataToWireCanonical());
            int n4 = dNSOutput.current() - n3 - 2;
            dNSOutput.save();
            dNSOutput.jump(n3);
            dNSOutput.writeU16(n4);
            dNSOutput.restore();
        }
        return dNSOutput.toByteArray();
    }

    public static byte[] digestMessage(SIGRecord sIGRecord, Message message, byte[] byArray) {
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG((DNSOutput)dNSOutput, (SIGBase)sIGRecord);
        if (byArray != null) {
            dNSOutput.writeByteArray(byArray);
        }
        message.toWire(dNSOutput);
        return dNSOutput.toByteArray();
    }

    private static int BigIntegerLength(BigInteger bigInteger) {
        return (bigInteger.bitLength() + 7) / 8;
    }

    private static BigInteger readBigInteger(DNSInput dNSInput, int n) throws IOException {
        byte[] byArray = dNSInput.readByteArray(n);
        return new BigInteger(1, byArray);
    }

    private static BigInteger readBigInteger(DNSInput dNSInput) {
        byte[] byArray = dNSInput.readByteArray();
        return new BigInteger(1, byArray);
    }

    private static byte[] trimByteArray(byte[] byArray) {
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        return byArray;
    }

    private static void reverseByteArray(byte[] byArray) {
        for (int i = 0; i < byArray.length / 2; ++i) {
            int n = byArray.length - i - 1;
            byte by = byArray[i];
            byArray[i] = byArray[n];
            byArray[n] = by;
        }
    }

    private static BigInteger readBigIntegerLittleEndian(DNSInput dNSInput, int n) throws IOException {
        byte[] byArray = dNSInput.readByteArray(n);
        DNSSEC.reverseByteArray((byte[])byArray);
        return new BigInteger(1, byArray);
    }

    private static void writeBigInteger(DNSOutput dNSOutput, BigInteger bigInteger) {
        byte[] byArray = DNSSEC.trimByteArray((byte[])bigInteger.toByteArray());
        dNSOutput.writeByteArray(byArray);
    }

    private static void writePaddedBigInteger(DNSOutput dNSOutput, BigInteger bigInteger, int n) {
        byte[] byArray = DNSSEC.trimByteArray((byte[])bigInteger.toByteArray());
        if (byArray.length > n) {
            throw new IllegalArgumentException();
        }
        if (byArray.length < n) {
            byte[] byArray2 = new byte[n - byArray.length];
            dNSOutput.writeByteArray(byArray2);
        }
        dNSOutput.writeByteArray(byArray);
    }

    private static void writePaddedBigIntegerLittleEndian(DNSOutput dNSOutput, BigInteger bigInteger, int n) {
        byte[] byArray = DNSSEC.trimByteArray((byte[])bigInteger.toByteArray());
        if (byArray.length > n) {
            throw new IllegalArgumentException();
        }
        DNSSEC.reverseByteArray((byte[])byArray);
        dNSOutput.writeByteArray(byArray);
        if (byArray.length < n) {
            byte[] byArray2 = new byte[n - byArray.length];
            dNSOutput.writeByteArray(byArray2);
        }
    }

    private static PublicKey toRSAPublicKey(KEYBase kEYBase) throws IOException, GeneralSecurityException {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        int n = dNSInput.readU8();
        if (n == 0) {
            n = dNSInput.readU16();
        }
        BigInteger bigInteger = DNSSEC.readBigInteger((DNSInput)dNSInput, (int)n);
        BigInteger bigInteger2 = DNSSEC.readBigInteger((DNSInput)dNSInput);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger2, bigInteger));
    }

    private static PublicKey toDSAPublicKey(KEYBase kEYBase) throws IOException, GeneralSecurityException, MalformedKeyException {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        int n = dNSInput.readU8();
        if (n > 8) {
            throw new MalformedKeyException(kEYBase);
        }
        BigInteger bigInteger = DNSSEC.readBigInteger((DNSInput)dNSInput, (int)20);
        BigInteger bigInteger2 = DNSSEC.readBigInteger((DNSInput)dNSInput, (int)(64 + n * 8));
        BigInteger bigInteger3 = DNSSEC.readBigInteger((DNSInput)dNSInput, (int)(64 + n * 8));
        BigInteger bigInteger4 = DNSSEC.readBigInteger((DNSInput)dNSInput, (int)(64 + n * 8));
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        return keyFactory.generatePublic(new DSAPublicKeySpec(bigInteger4, bigInteger2, bigInteger, bigInteger3));
    }

    private static PublicKey toECGOSTPublicKey(KEYBase kEYBase, ECKeyInfo eCKeyInfo) throws IOException, GeneralSecurityException, MalformedKeyException {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        BigInteger bigInteger = DNSSEC.readBigIntegerLittleEndian((DNSInput)dNSInput, (int)eCKeyInfo.length);
        BigInteger bigInteger2 = DNSSEC.readBigIntegerLittleEndian((DNSInput)dNSInput, (int)eCKeyInfo.length);
        ECPoint eCPoint = new ECPoint(bigInteger, bigInteger2);
        KeyFactory keyFactory = KeyFactory.getInstance("ECGOST3410");
        return keyFactory.generatePublic(new ECPublicKeySpec(eCPoint, eCKeyInfo.spec));
    }

    private static PublicKey toECDSAPublicKey(KEYBase kEYBase, ECKeyInfo eCKeyInfo) throws IOException, GeneralSecurityException, MalformedKeyException {
        DNSInput dNSInput = new DNSInput(kEYBase.getKey());
        BigInteger bigInteger = DNSSEC.readBigInteger((DNSInput)dNSInput, (int)eCKeyInfo.length);
        BigInteger bigInteger2 = DNSSEC.readBigInteger((DNSInput)dNSInput, (int)eCKeyInfo.length);
        ECPoint eCPoint = new ECPoint(bigInteger, bigInteger2);
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePublic(new ECPublicKeySpec(eCPoint, eCKeyInfo.spec));
    }

    static PublicKey toPublicKey(KEYBase kEYBase) throws DNSSECException {
        int n = kEYBase.getAlgorithm();
        try {
            switch (n) {
                case 1: 
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    return DNSSEC.toRSAPublicKey((KEYBase)kEYBase);
                }
                case 3: 
                case 6: {
                    return DNSSEC.toDSAPublicKey((KEYBase)kEYBase);
                }
                case 12: {
                    return DNSSEC.toECGOSTPublicKey((KEYBase)kEYBase, (ECKeyInfo)GOST);
                }
                case 13: {
                    return DNSSEC.toECDSAPublicKey((KEYBase)kEYBase, (ECKeyInfo)ECDSA_P256);
                }
                case 14: {
                    return DNSSEC.toECDSAPublicKey((KEYBase)kEYBase, (ECKeyInfo)ECDSA_P384);
                }
            }
            throw new UnsupportedAlgorithmException(n);
        }
        catch (IOException iOException) {
            throw new MalformedKeyException(kEYBase);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DNSSECException(generalSecurityException.toString());
        }
    }

    private static byte[] fromRSAPublicKey(RSAPublicKey rSAPublicKey) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        int n = DNSSEC.BigIntegerLength((BigInteger)bigInteger);
        if (n < 256) {
            dNSOutput.writeU8(n);
        } else {
            dNSOutput.writeU8(0);
            dNSOutput.writeU16(n);
        }
        DNSSEC.writeBigInteger((DNSOutput)dNSOutput, (BigInteger)bigInteger);
        DNSSEC.writeBigInteger((DNSOutput)dNSOutput, (BigInteger)bigInteger2);
        return dNSOutput.toByteArray();
    }

    private static byte[] fromDSAPublicKey(DSAPublicKey dSAPublicKey) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = dSAPublicKey.getParams().getQ();
        BigInteger bigInteger2 = dSAPublicKey.getParams().getP();
        BigInteger bigInteger3 = dSAPublicKey.getParams().getG();
        BigInteger bigInteger4 = dSAPublicKey.getY();
        int n = (bigInteger2.toByteArray().length - 64) / 8;
        dNSOutput.writeU8(n);
        DNSSEC.writeBigInteger((DNSOutput)dNSOutput, (BigInteger)bigInteger);
        DNSSEC.writeBigInteger((DNSOutput)dNSOutput, (BigInteger)bigInteger2);
        DNSSEC.writePaddedBigInteger((DNSOutput)dNSOutput, (BigInteger)bigInteger3, (int)(8 * n + 64));
        DNSSEC.writePaddedBigInteger((DNSOutput)dNSOutput, (BigInteger)bigInteger4, (int)(8 * n + 64));
        return dNSOutput.toByteArray();
    }

    private static byte[] fromECGOSTPublicKey(ECPublicKey eCPublicKey, ECKeyInfo eCKeyInfo) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = eCPublicKey.getW().getAffineX();
        BigInteger bigInteger2 = eCPublicKey.getW().getAffineY();
        DNSSEC.writePaddedBigIntegerLittleEndian((DNSOutput)dNSOutput, (BigInteger)bigInteger, (int)eCKeyInfo.length);
        DNSSEC.writePaddedBigIntegerLittleEndian((DNSOutput)dNSOutput, (BigInteger)bigInteger2, (int)eCKeyInfo.length);
        return dNSOutput.toByteArray();
    }

    private static byte[] fromECDSAPublicKey(ECPublicKey eCPublicKey, ECKeyInfo eCKeyInfo) {
        DNSOutput dNSOutput = new DNSOutput();
        BigInteger bigInteger = eCPublicKey.getW().getAffineX();
        BigInteger bigInteger2 = eCPublicKey.getW().getAffineY();
        DNSSEC.writePaddedBigInteger((DNSOutput)dNSOutput, (BigInteger)bigInteger, (int)eCKeyInfo.length);
        DNSSEC.writePaddedBigInteger((DNSOutput)dNSOutput, (BigInteger)bigInteger2, (int)eCKeyInfo.length);
        return dNSOutput.toByteArray();
    }

    static byte[] fromPublicKey(PublicKey publicKey, int n) throws DNSSECException {
        switch (n) {
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                if (!(publicKey instanceof RSAPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromRSAPublicKey((RSAPublicKey)((RSAPublicKey)publicKey));
            }
            case 3: 
            case 6: {
                if (!(publicKey instanceof DSAPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromDSAPublicKey((DSAPublicKey)((DSAPublicKey)publicKey));
            }
            case 12: {
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromECGOSTPublicKey((ECPublicKey)((ECPublicKey)publicKey), (ECKeyInfo)GOST);
            }
            case 13: {
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromECDSAPublicKey((ECPublicKey)((ECPublicKey)publicKey), (ECKeyInfo)ECDSA_P256);
            }
            case 14: {
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new IncompatibleKeyException();
                }
                return DNSSEC.fromECDSAPublicKey((ECPublicKey)((ECPublicKey)publicKey), (ECKeyInfo)ECDSA_P384);
            }
        }
        throw new UnsupportedAlgorithmException(n);
    }

    public static String algString(int n) throws UnsupportedAlgorithmException {
        switch (n) {
            case 1: {
                return "MD5withRSA";
            }
            case 3: 
            case 6: {
                return "SHA1withDSA";
            }
            case 5: 
            case 7: {
                return "SHA1withRSA";
            }
            case 8: {
                return "SHA256withRSA";
            }
            case 10: {
                return "SHA512withRSA";
            }
            case 12: {
                return "GOST3411withECGOST3410";
            }
            case 13: {
                return "SHA256withECDSA";
            }
            case 14: {
                return "SHA384withECDSA";
            }
        }
        throw new UnsupportedAlgorithmException(n);
    }

    private static byte[] DSASignaturefromDNS(byte[] byArray) throws DNSSECException, IOException {
        if (byArray.length != 41) {
            throw new SignatureVerificationException();
        }
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        int n = dNSInput.readU8();
        byte[] byArray2 = dNSInput.readByteArray(20);
        int n2 = 20;
        if (byArray2[0] < 0) {
            ++n2;
        }
        byte[] byArray3 = dNSInput.readByteArray(20);
        int n3 = 20;
        if (byArray3[0] < 0) {
            ++n3;
        }
        dNSOutput.writeU8(48);
        dNSOutput.writeU8(n2 + n3 + 4);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n2);
        if (n2 > 20) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray2);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n3);
        if (n3 > 20) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray3);
        return dNSOutput.toByteArray();
    }

    private static byte[] DSASignaturetoDNS(byte[] byArray, int n) throws IOException {
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        dNSOutput.writeU8(n);
        int n2 = dNSInput.readU8();
        if (n2 != 48) {
            throw new IOException();
        }
        int n3 = dNSInput.readU8();
        n2 = dNSInput.readU8();
        if (n2 != 2) {
            throw new IOException();
        }
        int n4 = dNSInput.readU8();
        if (n4 == 21 ? dNSInput.readU8() != 0 : n4 != 20) {
            throw new IOException();
        }
        byte[] byArray2 = dNSInput.readByteArray(20);
        dNSOutput.writeByteArray(byArray2);
        n2 = dNSInput.readU8();
        if (n2 != 2) {
            throw new IOException();
        }
        int n5 = dNSInput.readU8();
        if (n5 == 21 ? dNSInput.readU8() != 0 : n5 != 20) {
            throw new IOException();
        }
        byArray2 = dNSInput.readByteArray(20);
        dNSOutput.writeByteArray(byArray2);
        return dNSOutput.toByteArray();
    }

    private static byte[] ECGOSTSignaturefromDNS(byte[] byArray, ECKeyInfo eCKeyInfo) throws DNSSECException, IOException {
        if (byArray.length != eCKeyInfo.length * 2) {
            throw new SignatureVerificationException();
        }
        return byArray;
    }

    private static byte[] ECDSASignaturefromDNS(byte[] byArray, ECKeyInfo eCKeyInfo) throws DNSSECException, IOException {
        if (byArray.length != eCKeyInfo.length * 2) {
            throw new SignatureVerificationException();
        }
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        byte[] byArray2 = dNSInput.readByteArray(eCKeyInfo.length);
        int n = eCKeyInfo.length;
        if (byArray2[0] < 0) {
            ++n;
        }
        byte[] byArray3 = dNSInput.readByteArray(eCKeyInfo.length);
        int n2 = eCKeyInfo.length;
        if (byArray3[0] < 0) {
            ++n2;
        }
        dNSOutput.writeU8(48);
        dNSOutput.writeU8(n + n2 + 4);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n);
        if (n > eCKeyInfo.length) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray2);
        dNSOutput.writeU8(2);
        dNSOutput.writeU8(n2);
        if (n2 > eCKeyInfo.length) {
            dNSOutput.writeU8(0);
        }
        dNSOutput.writeByteArray(byArray3);
        return dNSOutput.toByteArray();
    }

    private static byte[] ECDSASignaturetoDNS(byte[] byArray, ECKeyInfo eCKeyInfo) throws IOException {
        DNSInput dNSInput = new DNSInput(byArray);
        DNSOutput dNSOutput = new DNSOutput();
        int n = dNSInput.readU8();
        if (n != 48) {
            throw new IOException();
        }
        int n2 = dNSInput.readU8();
        n = dNSInput.readU8();
        if (n != 2) {
            throw new IOException();
        }
        int n3 = dNSInput.readU8();
        if (n3 == eCKeyInfo.length + 1 ? dNSInput.readU8() != 0 : n3 != eCKeyInfo.length) {
            throw new IOException();
        }
        byte[] byArray2 = dNSInput.readByteArray(eCKeyInfo.length);
        dNSOutput.writeByteArray(byArray2);
        n = dNSInput.readU8();
        if (n != 2) {
            throw new IOException();
        }
        int n4 = dNSInput.readU8();
        if (n4 == eCKeyInfo.length + 1 ? dNSInput.readU8() != 0 : n4 != eCKeyInfo.length) {
            throw new IOException();
        }
        byArray2 = dNSInput.readByteArray(eCKeyInfo.length);
        dNSOutput.writeByteArray(byArray2);
        return dNSOutput.toByteArray();
    }

    private static void verify(PublicKey publicKey, int n, byte[] byArray, byte[] byArray2) throws DNSSECException {
        if (publicKey instanceof DSAPublicKey) {
            try {
                byArray2 = DNSSEC.DSASignaturefromDNS((byte[])byArray2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
        }
        if (publicKey instanceof ECPublicKey) {
            try {
                switch (n) {
                    case 12: {
                        byArray2 = DNSSEC.ECGOSTSignaturefromDNS((byte[])byArray2, (ECKeyInfo)GOST);
                        break;
                    }
                    case 13: {
                        byArray2 = DNSSEC.ECDSASignaturefromDNS((byte[])byArray2, (ECKeyInfo)ECDSA_P256);
                        break;
                    }
                    case 14: {
                        byArray2 = DNSSEC.ECDSASignaturefromDNS((byte[])byArray2, (ECKeyInfo)ECDSA_P384);
                        break;
                    }
                    default: {
                        throw new UnsupportedAlgorithmException(n);
                    }
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
        }
        try {
            Signature signature = Signature.getInstance(DNSSEC.algString((int)n));
            signature.initVerify(publicKey);
            signature.update(byArray);
            if (!signature.verify(byArray2)) {
                throw new SignatureVerificationException();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DNSSECException(generalSecurityException.toString());
        }
    }

    private static boolean matches(SIGBase sIGBase, KEYBase kEYBase) {
        return kEYBase.getAlgorithm() == sIGBase.getAlgorithm() && kEYBase.getFootprint() == sIGBase.getFootprint() && kEYBase.getName().equals((Object)sIGBase.getSigner());
    }

    public static void verify(RRset rRset, RRSIGRecord rRSIGRecord, DNSKEYRecord dNSKEYRecord) throws DNSSECException {
        if (!DNSSEC.matches((SIGBase)rRSIGRecord, (KEYBase)dNSKEYRecord)) {
            throw new KeyMismatchException((KEYBase)dNSKEYRecord, (SIGBase)rRSIGRecord);
        }
        Date date = new Date();
        if (date.compareTo(rRSIGRecord.getExpire()) > 0) {
            throw new SignatureExpiredException(rRSIGRecord.getExpire(), date);
        }
        if (date.compareTo(rRSIGRecord.getTimeSigned()) < 0) {
            throw new SignatureNotYetValidException(rRSIGRecord.getTimeSigned(), date);
        }
        DNSSEC.verify((PublicKey)dNSKEYRecord.getPublicKey(), (int)rRSIGRecord.getAlgorithm(), (byte[])DNSSEC.digestRRset((RRSIGRecord)rRSIGRecord, (RRset)rRset), (byte[])rRSIGRecord.getSignature());
    }

    private static byte[] sign(PrivateKey privateKey, PublicKey publicKey, int n, byte[] byArray, String string) throws DNSSECException {
        byte[] byArray2;
        Object object;
        try {
            object = string != null ? Signature.getInstance(DNSSEC.algString((int)n), string) : Signature.getInstance(DNSSEC.algString((int)n));
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray);
            byArray2 = ((Signature)object).sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new DNSSECException(generalSecurityException.toString());
        }
        if (publicKey instanceof DSAPublicKey) {
            try {
                object = (DSAPublicKey)publicKey;
                BigInteger bigInteger = object.getParams().getP();
                int n2 = (DNSSEC.BigIntegerLength((BigInteger)bigInteger) - 64) / 8;
                byArray2 = DNSSEC.DSASignaturetoDNS((byte[])byArray2, (int)n2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
        }
        if (publicKey instanceof ECPublicKey) {
            try {
                switch (n) {
                    case 12: {
                        break;
                    }
                    case 13: {
                        byArray2 = DNSSEC.ECDSASignaturetoDNS((byte[])byArray2, (ECKeyInfo)ECDSA_P256);
                        break;
                    }
                    case 14: {
                        byArray2 = DNSSEC.ECDSASignaturetoDNS((byte[])byArray2, (ECKeyInfo)ECDSA_P384);
                        break;
                    }
                    default: {
                        throw new UnsupportedAlgorithmException(n);
                    }
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException();
            }
        }
        return byArray2;
    }

    static void checkAlgorithm(PrivateKey privateKey, int n) throws UnsupportedAlgorithmException {
        switch (n) {
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                if (privateKey instanceof RSAPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            case 3: 
            case 6: {
                if (privateKey instanceof DSAPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            case 12: 
            case 13: 
            case 14: {
                if (privateKey instanceof ECPrivateKey) break;
                throw new IncompatibleKeyException();
            }
            default: {
                throw new UnsupportedAlgorithmException(n);
            }
        }
    }

    public static RRSIGRecord sign(RRset rRset, DNSKEYRecord dNSKEYRecord, PrivateKey privateKey, Date date, Date date2) throws DNSSECException {
        return DNSSEC.sign((RRset)rRset, (DNSKEYRecord)dNSKEYRecord, (PrivateKey)privateKey, (Date)date, (Date)date2, null);
    }

    public static RRSIGRecord sign(RRset rRset, DNSKEYRecord dNSKEYRecord, PrivateKey privateKey, Date date, Date date2, String string) throws DNSSECException {
        int n = dNSKEYRecord.getAlgorithm();
        DNSSEC.checkAlgorithm((PrivateKey)privateKey, (int)n);
        RRSIGRecord rRSIGRecord = new RRSIGRecord(rRset.getName(), rRset.getDClass(), rRset.getTTL(), rRset.getType(), n, rRset.getTTL(), date2, date, dNSKEYRecord.getFootprint(), dNSKEYRecord.getName(), null);
        rRSIGRecord.setSignature(DNSSEC.sign((PrivateKey)privateKey, (PublicKey)dNSKEYRecord.getPublicKey(), (int)n, (byte[])DNSSEC.digestRRset((RRSIGRecord)rRSIGRecord, (RRset)rRset), (String)string));
        return rRSIGRecord;
    }

    static SIGRecord signMessage(Message message, SIGRecord sIGRecord, KEYRecord kEYRecord, PrivateKey privateKey, Date date, Date date2) throws DNSSECException {
        int n = kEYRecord.getAlgorithm();
        DNSSEC.checkAlgorithm((PrivateKey)privateKey, (int)n);
        SIGRecord sIGRecord2 = new SIGRecord(Name.root, 255, 0L, 0, n, 0L, date2, date, kEYRecord.getFootprint(), kEYRecord.getName(), null);
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG((DNSOutput)dNSOutput, (SIGBase)sIGRecord2);
        if (sIGRecord != null) {
            dNSOutput.writeByteArray(sIGRecord.getSignature());
        }
        dNSOutput.writeByteArray(message.toWire());
        sIGRecord2.setSignature(DNSSEC.sign((PrivateKey)privateKey, (PublicKey)kEYRecord.getPublicKey(), (int)n, (byte[])dNSOutput.toByteArray(), null));
        return sIGRecord2;
    }

    static void verifyMessage(Message message, byte[] byArray, SIGRecord sIGRecord, SIGRecord sIGRecord2, KEYRecord kEYRecord) throws DNSSECException {
        if (message.sig0start == 0) {
            throw new NoSignatureException();
        }
        if (!DNSSEC.matches((SIGBase)sIGRecord, (KEYBase)kEYRecord)) {
            throw new KeyMismatchException((KEYBase)kEYRecord, (SIGBase)sIGRecord);
        }
        Date date = new Date();
        if (date.compareTo(sIGRecord.getExpire()) > 0) {
            throw new SignatureExpiredException(sIGRecord.getExpire(), date);
        }
        if (date.compareTo(sIGRecord.getTimeSigned()) < 0) {
            throw new SignatureNotYetValidException(sIGRecord.getTimeSigned(), date);
        }
        DNSOutput dNSOutput = new DNSOutput();
        DNSSEC.digestSIG((DNSOutput)dNSOutput, (SIGBase)sIGRecord);
        if (sIGRecord2 != null) {
            dNSOutput.writeByteArray(sIGRecord2.getSignature());
        }
        Header header = (Header)message.getHeader().clone();
        header.decCount(3);
        dNSOutput.writeByteArray(header.toWire());
        dNSOutput.writeByteArray(byArray, 12, message.sig0start - 12);
        DNSSEC.verify((PublicKey)kEYRecord.getPublicKey(), (int)sIGRecord.getAlgorithm(), (byte[])dNSOutput.toByteArray(), (byte[])sIGRecord.getSignature());
    }

    static byte[] generateDSDigest(DNSKEYRecord dNSKEYRecord, int n) {
        MessageDigest messageDigest;
        try {
            switch (n) {
                case 1: {
                    messageDigest = MessageDigest.getInstance("sha-1");
                    break;
                }
                case 2: {
                    messageDigest = MessageDigest.getInstance("sha-256");
                    break;
                }
                case 3: {
                    messageDigest = MessageDigest.getInstance("GOST3411");
                    break;
                }
                case 4: {
                    messageDigest = MessageDigest.getInstance("sha-384");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown DS digest type " + n);
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("no message digest support");
        }
        messageDigest.update(dNSKEYRecord.getName().toWireCanonical());
        messageDigest.update(dNSKEYRecord.rdataToWireCanonical());
        return messageDigest.digest();
    }
}

