/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EDNSOption;
import org.xbill.DNS.WireParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientSubnetOption
extends EDNSOption {
    private static final long serialVersionUID = -3868158449890266347L;
    private int family;
    private int sourceNetmask;
    private int scopeNetmask;
    private InetAddress address;

    ClientSubnetOption() {
        super(8);
    }

    private static int checkMaskLength(String string, int n, int n2) {
        int n3 = Address.addressLength((int)n) * 8;
        if (n2 < 0 || n2 > n3) {
            throw new IllegalArgumentException("\"" + string + "\" " + n2 + " must be in the range [0.." + n3 + "]");
        }
        return n2;
    }

    public ClientSubnetOption(int n, int n2, InetAddress inetAddress) {
        super(8);
        this.family = Address.familyOf((InetAddress)inetAddress);
        this.sourceNetmask = ClientSubnetOption.checkMaskLength((String)"source netmask", (int)this.family, (int)n);
        this.scopeNetmask = ClientSubnetOption.checkMaskLength((String)"scope netmask", (int)this.family, (int)n2);
        this.address = Address.truncate((InetAddress)inetAddress, (int)n);
        if (!inetAddress.equals(this.address)) {
            throw new IllegalArgumentException("source netmask is not valid for address");
        }
    }

    public ClientSubnetOption(int n, InetAddress inetAddress) {
        this(n, 0, inetAddress);
    }

    public int getFamily() {
        return this.family;
    }

    public int getSourceNetmask() {
        return this.sourceNetmask;
    }

    public int getScopeNetmask() {
        return this.scopeNetmask;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    void optionFromWire(DNSInput dNSInput) throws WireParseException {
        this.family = dNSInput.readU16();
        if (this.family != 1 && this.family != 2) {
            throw new WireParseException("unknown address family");
        }
        this.sourceNetmask = dNSInput.readU8();
        if (this.sourceNetmask > Address.addressLength((int)this.family) * 8) {
            throw new WireParseException("invalid source netmask");
        }
        this.scopeNetmask = dNSInput.readU8();
        if (this.scopeNetmask > Address.addressLength((int)this.family) * 8) {
            throw new WireParseException("invalid scope netmask");
        }
        byte[] byArray = dNSInput.readByteArray();
        if (byArray.length != (this.sourceNetmask + 7) / 8) {
            throw new WireParseException("invalid address");
        }
        byte[] byArray2 = new byte[Address.addressLength((int)this.family)];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        try {
            this.address = InetAddress.getByAddress(byArray2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new WireParseException("invalid address", (Throwable)unknownHostException);
        }
        InetAddress inetAddress = Address.truncate((InetAddress)this.address, (int)this.sourceNetmask);
        if (!inetAddress.equals(this.address)) {
            throw new WireParseException("invalid padding");
        }
    }

    void optionToWire(DNSOutput dNSOutput) {
        dNSOutput.writeU16(this.family);
        dNSOutput.writeU8(this.sourceNetmask);
        dNSOutput.writeU8(this.scopeNetmask);
        dNSOutput.writeByteArray(this.address.getAddress(), 0, (this.sourceNetmask + 7) / 8);
    }

    String optionToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.address.getHostAddress());
        stringBuffer.append("/");
        stringBuffer.append(this.sourceNetmask);
        stringBuffer.append(", scope netmask ");
        stringBuffer.append(this.scopeNetmask);
        return stringBuffer.toString();
    }
}

