/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.xbill.DNS.Options;
import org.xbill.DNS.PacketLogger;
import org.xbill.DNS.utils.hexdump;

class Client {
    protected long endTime;
    protected SelectionKey key;
    private static PacketLogger packetLogger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Client(SelectableChannel selectableChannel, long l) throws IOException {
        boolean bl = false;
        Selector selector = null;
        this.endTime = l;
        try {
            selector = Selector.open();
            selectableChannel.configureBlocking(false);
            this.key = selectableChannel.register(selector, 1);
            bl = true;
        }
        finally {
            if (!bl && selector != null) {
                selector.close();
            }
            if (!bl) {
                selectableChannel.close();
            }
        }
    }

    protected static void blockUntil(SelectionKey selectionKey, long l) throws IOException {
        long l2 = l - System.currentTimeMillis();
        int n = 0;
        if (l2 > 0L) {
            n = selectionKey.selector().select(l2);
        } else if (l2 == 0L) {
            n = selectionKey.selector().selectNow();
        }
        if (n == 0) {
            throw new SocketTimeoutException();
        }
    }

    protected static void verboseLog(String string, SocketAddress socketAddress, SocketAddress socketAddress2, byte[] byArray) {
        if (Options.check((String)"verbosemsg")) {
            System.err.println(hexdump.dump((String)string, (byte[])byArray));
        }
        if (packetLogger != null) {
            packetLogger.log(string, socketAddress, socketAddress2, byArray);
        }
    }

    void cleanup() throws IOException {
        this.key.selector().close();
        this.key.channel().close();
    }

    static void setPacketLogger(PacketLogger packetLogger) {
        Client.packetLogger = packetLogger;
    }
}

