/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.Type;

/*
 * Exception performing whole class analysis ignored.
 */
public class Cache {
    private CacheMap data;
    private int maxncache = -1;
    private int maxcache = -1;
    private int dclass;
    private static final int defaultMaxEntries = 50000;

    private static int limitExpire(long l, long l2) {
        long l3;
        if (l2 >= 0L && l2 < l) {
            l = l2;
        }
        if ((l3 = System.currentTimeMillis() / 1000L + l) < 0L || l3 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    public Cache(int n) {
        this.dclass = n;
        this.data = new CacheMap(50000);
    }

    public Cache() {
        this(1);
    }

    public Cache(String string) throws IOException {
        Record record;
        this.data = new CacheMap(50000);
        Master master = new Master(string);
        while ((record = master.nextRecord()) != null) {
            this.addRecord(record, 0, (Object)master);
        }
    }

    private synchronized Object exactName(Name name) {
        return this.data.get((Object)name);
    }

    private synchronized void removeName(Name name) {
        this.data.remove((Object)name);
    }

    private synchronized Element[] allElements(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            return list.toArray(new Element[n]);
        }
        Element element = (Element)object;
        return new Element[]{element};
    }

    private synchronized Element oneElement(Name name, Object object, int n, int n2) {
        Element element = null;
        if (n == 255) {
            throw new IllegalArgumentException("oneElement(ANY)");
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                if (element2.getType() != n) continue;
                element = element2;
                break;
            }
        } else {
            Element element3 = (Element)object;
            if (element3.getType() == n) {
                element = element3;
            }
        }
        if (element == null) {
            return null;
        }
        if (element.expired()) {
            this.removeElement(name, n);
            return null;
        }
        if (element.compareCredibility(n2) < 0) {
            return null;
        }
        return element;
    }

    private synchronized Element findElement(Name name, int n, int n2) {
        Object object = this.exactName(name);
        if (object == null) {
            return null;
        }
        return this.oneElement(name, object, n, n2);
    }

    private synchronized void addElement(Name name, Element element) {
        Object object = this.data.get((Object)name);
        if (object == null) {
            this.data.put((Object)name, (Object)element);
            return;
        }
        int n = element.getType();
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                if (element2.getType() != n) continue;
                list.set(i, element);
                return;
            }
            list.add(element);
        } else {
            Element element3 = (Element)object;
            if (element3.getType() == n) {
                this.data.put((Object)name, (Object)element);
            } else {
                LinkedList<Element> linkedList = new LinkedList<Element>();
                linkedList.add(element3);
                linkedList.add(element);
                this.data.put((Object)name, linkedList);
            }
        }
    }

    private synchronized void removeElement(Name name, int n) {
        Object object = this.data.get((Object)name);
        if (object == null) {
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                Element element = (Element)list.get(i);
                if (element.getType() != n) continue;
                list.remove(i);
                if (list.size() == 0) {
                    this.data.remove((Object)name);
                }
                return;
            }
        } else {
            Element element = (Element)object;
            if (element.getType() != n) {
                return;
            }
            this.data.remove((Object)name);
        }
    }

    public synchronized void clearCache() {
        this.data.clear();
    }

    public synchronized void addRecord(Record record, int n, Object object) {
        Name name = record.getName();
        int n2 = record.getRRsetType();
        if (!Type.isRR((int)n2)) {
            return;
        }
        Element element = this.findElement(name, n2, n);
        if (element == null) {
            CacheRRset cacheRRset = new CacheRRset(record, n, (long)this.maxcache);
            this.addRRset((RRset)cacheRRset, n);
        } else if (element.compareCredibility(n) == 0 && element instanceof CacheRRset) {
            CacheRRset cacheRRset = (CacheRRset)element;
            cacheRRset.addRR(record);
        }
    }

    public synchronized void addRRset(RRset rRset, int n) {
        long l = rRset.getTTL();
        Name name = rRset.getName();
        int n2 = rRset.getType();
        Element element = this.findElement(name, n2, 0);
        if (l == 0L) {
            if (element != null && element.compareCredibility(n) <= 0) {
                this.removeElement(name, n2);
            }
        } else {
            if (element != null && element.compareCredibility(n) <= 0) {
                element = null;
            }
            if (element == null) {
                CacheRRset cacheRRset = rRset instanceof CacheRRset ? (CacheRRset)rRset : new CacheRRset(rRset, n, (long)this.maxcache);
                this.addElement(name, (Element)cacheRRset);
            }
        }
    }

    public synchronized void addNegative(Name name, int n, SOARecord sOARecord, int n2) {
        long l = 0L;
        if (sOARecord != null) {
            l = sOARecord.getTTL();
        }
        Element element = this.findElement(name, n, 0);
        if (l == 0L) {
            if (element != null && element.compareCredibility(n2) <= 0) {
                this.removeElement(name, n);
            }
        } else {
            if (element != null && element.compareCredibility(n2) <= 0) {
                element = null;
            }
            if (element == null) {
                this.addElement(name, (Element)new NegativeElement(name, n, sOARecord, n2, (long)this.maxncache));
            }
        }
    }

    protected synchronized SetResponse lookup(Name name, int n, int n2) {
        int n3;
        for (int i = n3 = name.labels(); i >= 1; --i) {
            Element element;
            boolean bl;
            boolean bl2 = i == 1;
            boolean bl3 = bl = i == n3;
            Name name2 = bl2 ? Name.root : (bl ? name : new Name(name, n3 - i));
            Object object = this.data.get((Object)name2);
            if (object == null) continue;
            if (bl && n == 255) {
                var9_9 = new SetResponse(6);
                Element[] elementArray = this.allElements(object);
                int n4 = 0;
                for (int j = 0; j < elementArray.length; ++j) {
                    element = elementArray[j];
                    if (element.expired()) {
                        this.removeElement(name2, element.getType());
                        continue;
                    }
                    if (!(element instanceof CacheRRset) || element.compareCredibility(n2) < 0) continue;
                    var9_9.addRRset((RRset)((CacheRRset)element));
                    ++n4;
                }
                if (n4 > 0) {
                    return var9_9;
                }
            } else if (bl) {
                element = this.oneElement(name2, object, n, n2);
                if (element != null && element instanceof CacheRRset) {
                    var9_9 = new SetResponse(6);
                    var9_9.addRRset((RRset)((CacheRRset)element));
                    return var9_9;
                }
                if (element != null) {
                    var9_9 = new SetResponse(2);
                    return var9_9;
                }
                element = this.oneElement(name2, object, 5, n2);
                if (element != null && element instanceof CacheRRset) {
                    return new SetResponse(4, (RRset)((CacheRRset)element));
                }
            } else {
                element = this.oneElement(name2, object, 39, n2);
                if (element != null && element instanceof CacheRRset) {
                    return new SetResponse(5, (RRset)((CacheRRset)element));
                }
            }
            if ((element = this.oneElement(name2, object, 2, n2)) != null && element instanceof CacheRRset) {
                return new SetResponse(3, (RRset)((CacheRRset)element));
            }
            if (!bl || (element = this.oneElement(name2, object, 0, n2)) == null) continue;
            return SetResponse.ofType((int)1);
        }
        return SetResponse.ofType((int)0);
    }

    public SetResponse lookupRecords(Name name, int n, int n2) {
        return this.lookup(name, n, n2);
    }

    private RRset[] findRecords(Name name, int n, int n2) {
        SetResponse setResponse = this.lookupRecords(name, n, n2);
        if (setResponse.isSuccessful()) {
            return setResponse.answers();
        }
        return null;
    }

    public RRset[] findRecords(Name name, int n) {
        return this.findRecords(name, n, 3);
    }

    public RRset[] findAnyRecords(Name name, int n) {
        return this.findRecords(name, n, 2);
    }

    private final int getCred(int n, boolean bl) {
        if (n == 1) {
            if (bl) {
                return 4;
            }
            return 3;
        }
        if (n == 2) {
            if (bl) {
                return 4;
            }
            return 3;
        }
        if (n == 3) {
            return 1;
        }
        throw new IllegalArgumentException("getCred: invalid section");
    }

    private static void markAdditional(RRset rRset, Set set) {
        Record record = rRset.first();
        if (record.getAdditionalName() == null) {
            return;
        }
        Iterator iterator = rRset.rrs();
        while (iterator.hasNext()) {
            Record record2 = (Record)iterator.next();
            Name name = record2.getAdditionalName();
            if (name == null) continue;
            set.add(name);
        }
    }

    public SetResponse addMessage(Message message) {
        int n;
        SOARecord sOARecord;
        int n2;
        boolean bl = message.getHeader().getFlag(5);
        Record record = message.getQuestion();
        int n3 = message.getHeader().getRcode();
        boolean bl2 = false;
        SetResponse setResponse = null;
        boolean bl3 = Options.check((String)"verbosecache");
        if (n3 != 0 && n3 != 3 || record == null) {
            return null;
        }
        Name name = record.getName();
        int n4 = record.getType();
        int n5 = record.getDClass();
        Name name2 = name;
        HashSet hashSet = new HashSet();
        RRset[] rRsetArray = message.getSectionRRsets(1);
        for (int i = 0; i < rRsetArray.length; ++i) {
            if (rRsetArray[i].getDClass() != n5) continue;
            int n6 = rRsetArray[i].getType();
            Name name3 = rRsetArray[i].getName();
            n2 = this.getCred(1, bl);
            if ((n6 == n4 || n4 == 255) && name3.equals((Object)name2)) {
                this.addRRset(rRsetArray[i], n2);
                bl2 = true;
                if (name2 == name) {
                    if (setResponse == null) {
                        setResponse = new SetResponse(6);
                    }
                    setResponse.addRRset(rRsetArray[i]);
                }
                Cache.markAdditional((RRset)rRsetArray[i], hashSet);
                continue;
            }
            if (n6 == 5 && name3.equals((Object)name2)) {
                this.addRRset(rRsetArray[i], n2);
                if (name2 == name) {
                    setResponse = new SetResponse(4, rRsetArray[i]);
                }
                sOARecord = (CNAMERecord)rRsetArray[i].first();
                name2 = sOARecord.getTarget();
                continue;
            }
            if (n6 != 39 || !name2.subdomain(name3)) continue;
            this.addRRset(rRsetArray[i], n2);
            if (name2 == name) {
                setResponse = new SetResponse(5, rRsetArray[i]);
            }
            sOARecord = (DNAMERecord)rRsetArray[i].first();
            try {
                name2 = name2.fromDNAME((DNAMERecord)sOARecord);
                continue;
            }
            catch (NameTooLongException nameTooLongException) {
                break;
            }
        }
        RRset[] rRsetArray2 = message.getSectionRRsets(2);
        RRset rRset = null;
        RRset rRset2 = null;
        for (n = 0; n < rRsetArray2.length; ++n) {
            if (rRsetArray2[n].getType() == 6 && name2.subdomain(rRsetArray2[n].getName())) {
                rRset = rRsetArray2[n];
                continue;
            }
            if (rRsetArray2[n].getType() != 2 || !name2.subdomain(rRsetArray2[n].getName())) continue;
            rRset2 = rRsetArray2[n];
        }
        if (!bl2) {
            int n7 = n = n3 == 3 ? 0 : n4;
            if (n3 == 3 || rRset != null || rRset2 == null) {
                n2 = this.getCred(2, bl);
                sOARecord = null;
                if (rRset != null) {
                    sOARecord = (SOARecord)rRset.first();
                }
                this.addNegative(name2, n, sOARecord, n2);
                if (setResponse == null) {
                    int n8 = n3 == 3 ? 1 : 2;
                    setResponse = SetResponse.ofType((int)n8);
                }
            } else {
                n2 = this.getCred(2, bl);
                this.addRRset(rRset2, n2);
                Cache.markAdditional((RRset)rRset2, hashSet);
                if (setResponse == null) {
                    setResponse = new SetResponse(3, rRset2);
                }
            }
        } else if (n3 == 0 && rRset2 != null) {
            n2 = this.getCred(2, bl);
            this.addRRset(rRset2, n2);
            Cache.markAdditional(rRset2, hashSet);
        }
        RRset[] rRsetArray3 = message.getSectionRRsets(3);
        for (n = 0; n < rRsetArray3.length; ++n) {
            Name name4;
            int n9 = rRsetArray3[n].getType();
            if (n9 != 1 && n9 != 28 && n9 != 38 || !hashSet.contains(name4 = rRsetArray3[n].getName())) continue;
            n2 = this.getCred(3, bl);
            this.addRRset(rRsetArray3[n], n2);
        }
        if (bl3) {
            System.out.println("addMessage: " + setResponse);
        }
        return setResponse;
    }

    public void flushSet(Name name, int n) {
        this.removeElement(name, n);
    }

    public void flushName(Name name) {
        this.removeName(name);
    }

    public void setMaxNCache(int n) {
        this.maxncache = n;
    }

    public int getMaxNCache() {
        return this.maxncache;
    }

    public void setMaxCache(int n) {
        this.maxcache = n;
    }

    public int getMaxCache() {
        return this.maxcache;
    }

    public int getSize() {
        return this.data.size();
    }

    public int getMaxEntries() {
        return this.data.getMaxSize();
    }

    public void setMaxEntries(int n) {
        this.data.setMaxSize(n);
    }

    public int getDClass() {
        return this.dclass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Cache cache = this;
        synchronized (cache) {
            Iterator iterator = this.data.values().iterator();
            while (iterator.hasNext()) {
                Element[] elementArray = this.allElements(iterator.next());
                for (int i = 0; i < elementArray.length; ++i) {
                    stringBuffer.append(elementArray[i]);
                    stringBuffer.append("\n");
                }
            }
        }
        return stringBuffer.toString();
    }
}

