/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class AAAARecord
extends Record {
    private static final long serialVersionUID = -4588601512069748050L;
    private byte[] address;

    AAAARecord() {
    }

    Record getObject() {
        return new AAAARecord();
    }

    public AAAARecord(Name name, int n, long l, InetAddress inetAddress) {
        super(name, 28, n, l);
        if (Address.familyOf((InetAddress)inetAddress) != 2) {
            throw new IllegalArgumentException("invalid IPv6 address");
        }
        this.address = inetAddress.getAddress();
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.address = dNSInput.readByteArray(16);
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.address = tokenizer.getAddressBytes(2);
    }

    String rrToString() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByAddress(null, this.address);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        if (inetAddress.getAddress().length == 4) {
            StringBuffer stringBuffer = new StringBuffer("0:0:0:0:0:ffff:");
            int n = ((this.address[12] & 0xFF) << 8) + (this.address[13] & 0xFF);
            int n2 = ((this.address[14] & 0xFF) << 8) + (this.address[15] & 0xFF);
            stringBuffer.append(Integer.toHexString(n));
            stringBuffer.append(':');
            stringBuffer.append(Integer.toHexString(n2));
            return stringBuffer.toString();
        }
        return inetAddress.getHostAddress();
    }

    public InetAddress getAddress() {
        try {
            if (this.name == null) {
                return InetAddress.getByAddress(this.address);
            }
            return InetAddress.getByAddress(this.name.toString(), this.address);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeByteArray(this.address);
    }
}

