/*
 * Decompiled with CFR 0.152.
 */
package jrdesktop.server;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jrdesktop.utilities.ImageUtility;

public class robot {
    private Robot rt;
    private Toolkit tk = Toolkit.getDefaultToolkit();
    private Rectangle screenRect = new Rectangle(this.tk.getScreenSize());

    public robot() {
        try {
            this.rt = new Robot();
        }
        catch (AWTException aWTException) {
            aWTException.getStackTrace();
        }
    }

    public BufferedImage captureScreen() {
        this.screenRect = new Rectangle(this.tk.getScreenSize());
        return this.rt.createScreenCapture(this.screenRect);
    }

    public byte[] CaptureScreenByteArray() {
        return ImageUtility.toByteArray((BufferedImage)this.captureScreen());
    }

    public Rectangle getScreenRect() {
        return this.screenRect;
    }

    public void updateData(Object object) {
        ArrayList arrayList = (ArrayList)object;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e instanceof MouseEvent) {
                this.applyMouseEvent((MouseEvent)e);
                continue;
            }
            if (!(e instanceof KeyEvent)) continue;
            this.applyKeyEvent((KeyEvent)e);
        }
    }

    public void applyMouseEvent(MouseEvent mouseEvent) {
        this.rt.mouseMove(mouseEvent.getX(), mouseEvent.getY());
        int n = 0;
        int n2 = mouseEvent.getButton();
        if (n2 == 1) {
            n = 16;
        }
        if (n2 == 2) {
            n |= 8;
        }
        if (n2 == 3) {
            n |= 4;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this.rt.mousePress(n);
                break;
            }
            case 502: {
                this.rt.mouseRelease(n);
                break;
            }
            case 507: {
                this.rt.mouseWheel(((MouseWheelEvent)mouseEvent).getUnitsToScroll());
            }
        }
    }

    public void applyKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                this.rt.keyPress(keyEvent.getKeyCode());
                break;
            }
            case 402: {
                this.rt.keyRelease(keyEvent.getKeyCode());
            }
        }
    }
}

