/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.SocketListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;

public class Status
extends Plugin
implements VisualPlugin,
Runnable {
    private static final int debug = 0;
    private JLabel status;
    private JLabel host;
    private JPanel sPanel;
    private String address;
    private String port;
    private String infoURL;
    private int interval;
    private Thread infoThread;
    private Hashtable ports = new Hashtable();

    public Status(PluginBus bus, final String id) {
        super(bus, id);
        bus.registerPluginListener(new ConfigurationListener(){

            @Override
            public void setConfiguration(PluginConfig config) {
                String tmp;
                Status.this.infoURL = config.getProperty("Status", id, "info");
                if (Status.this.infoURL != null) {
                    Status.this.host.setAlignmentX(0.0f);
                }
                if ((tmp = config.getProperty("Status", id, "font")) != null) {
                    String fontStyle;
                    String font = tmp;
                    int style = 0;
                    int fsize = 12;
                    tmp = config.getProperty("Status", id, "fontSize");
                    if (tmp != null) {
                        fsize = Integer.parseInt(tmp);
                    }
                    if ((fontStyle = config.getProperty("Status", id, "fontStyle")) == null || fontStyle.equals("plain")) {
                        style = 0;
                    } else if (fontStyle.equals("bold")) {
                        style = 1;
                    } else if (fontStyle.equals("italic")) {
                        style = 2;
                    } else if (fontStyle.equals("bold+italic")) {
                        style = 3;
                    }
                    Status.this.host.setFont(new Font(font, style, fsize));
                }
                if ((tmp = config.getProperty("Status", id, "foreground")) != null) {
                    Status.this.host.setForeground(Color.decode(tmp));
                }
                if ((tmp = config.getProperty("Status", id, "background")) != null) {
                    Status.this.host.setBackground(Color.decode(tmp));
                }
                if (config.getProperty("Status", id, "interval") != null) {
                    try {
                        Status.this.interval = Integer.parseInt(config.getProperty("Status", id, "interval"));
                        Status.this.infoThread = new Thread(Status.this);
                        Status.this.infoThread.start();
                    }
                    catch (NumberFormatException e) {
                        Status.this.error("interval is not a number");
                    }
                }
            }
        });
        this.ports.put("22", "ssh");
        this.ports.put("23", "telnet");
        this.ports.put("25", "smtp");
        this.sPanel = new JPanel(new BorderLayout());
        this.host = new JLabel("Not connected.", 2);
        bus.registerPluginListener(new SocketListener(){

            @Override
            public void connect(String addr, int p) {
                Status.this.address = addr;
                if (Status.this.address == null || Status.this.address.length() == 0) {
                    Status.this.address = "<unknown host>";
                }
                if (Status.this.ports.get("" + p) != null) {
                    Status.this.port = (String)Status.this.ports.get("" + p);
                } else {
                    Status.this.port = "" + p;
                }
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Trying " + Status.this.address + " " + Status.this.port + " ...");
                }
            }

            @Override
            public void disconnect() {
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Not connected.");
                }
            }
        });
        this.sPanel.add("Center", this.host);
        this.status = new JLabel("offline", 0);
        bus.registerPluginListener(new OnlineStatusListener(){

            @Override
            public void online() {
                Status.this.status.setText("online");
                Status.this.status.setForeground(Color.green);
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Connected to " + Status.this.address + " " + Status.this.port);
                }
                Status.this.status.repaint();
            }

            @Override
            public void offline() {
                Status.this.status.setText("offline");
                Status.this.status.setForeground(Color.red);
                if (Status.this.infoURL == null) {
                    Status.this.host.setText("Not connected.");
                }
                Status.this.status.repaint();
            }
        });
        this.sPanel.add("East", this.status);
    }

    @Override
    public void run() {
        URL url = null;
        try {
            url = new URL(this.infoURL);
        }
        catch (Exception e) {
            this.error("infoURL is not valid: " + e);
            this.infoURL = null;
            return;
        }
        while (url != null && this.infoThread != null) {
            try {
                BufferedReader content = new BufferedReader(new InputStreamReader(url.openStream()));
                try {
                    String line;
                    while ((line = content.readLine()) != null) {
                        if (line.startsWith("#")) {
                            String color = line.substring(1, 7);
                            line = line.substring(8);
                            this.host.setForeground(Color.decode("#" + color));
                        }
                        this.host.setText(line);
                        Thread.sleep(10 * this.interval);
                    }
                }
                catch (IOException e) {
                    this.error("error while loading info ...");
                }
                Thread.sleep(100 * this.interval);
            }
            catch (Exception e) {
                this.error("error retrieving info content: " + e);
                e.printStackTrace();
                this.host.setForeground(Color.red);
                this.host.setText("error retrieving info content");
                this.infoURL = null;
                return;
            }
        }
    }

    @Override
    public JComponent getPluginVisual() {
        return this.sPanel;
    }

    @Override
    public JMenu getPluginMenu() {
        return null;
    }
}

