/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Capture
extends Plugin
implements FilterPlugin,
VisualPlugin,
ActionListener {
    private static final boolean personalJava = false;
    private static final int debug = 0;
    protected Hashtable remoteUrlList = new Hashtable();
    protected JMenu menu;
    protected JDialog errorDialog;
    protected JDialog fileDialog;
    protected JDialog doneDialog;
    protected boolean captureEnabled = false;
    private JMenuItem start;
    private JMenuItem stop;
    private JMenuItem clear;
    private JFrame frame = new JFrame("Java Telnet Applet: Captured Text");
    private JTextArea textArea;
    private JTextField fileName;
    protected FilterPlugin source;

    public Capture(PluginBus bus, final String id) {
        super(bus, id);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea(24, 80);
        this.frame.getContentPane().add((Component)this.textArea, "Center");
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Capture.this.frame.setVisible(false);
            }
        });
        this.frame.pack();
        this.errorDialog = new JDialog(this.frame, "Error", true);
        this.errorDialog.getContentPane().setLayout(new BorderLayout());
        this.errorDialog.getContentPane().add((Component)new JLabel("Cannot store data on remote server!"), "North");
        JPanel panel = new JPanel();
        JButton button = new JButton("Close Dialog");
        panel.add(button);
        this.errorDialog.getContentPane().add((Component)panel, "South");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Capture.this.errorDialog.setVisible(false);
            }
        });
        this.doneDialog = new JDialog(this.frame, "Success", true);
        this.doneDialog.getContentPane().setLayout(new BorderLayout());
        this.doneDialog.getContentPane().add((Component)new JLabel("Successfully saved data!"), "North");
        panel = new JPanel();
        button = new JButton("Close Dialog");
        panel.add(button);
        this.doneDialog.getContentPane().add((Component)panel, "South");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Capture.this.errorDialog.setVisible(false);
            }
        });
        this.fileDialog = new JDialog(this.frame, "Enter File Name", true);
        this.fileDialog.getContentPane().setLayout(new BorderLayout());
        ActionListener saveFileListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String params = (String)Capture.this.remoteUrlList.get("URL.file.params.orig");
                params = params == null ? "" : params + "&";
                Capture.this.remoteUrlList.put("URL.file.params", params + "file=" + URLEncoder.encode(Capture.this.fileName.getText()));
                Capture.this.saveFile("URL.file");
                Capture.this.fileDialog.setVisible(false);
            }
        };
        panel = new JPanel();
        panel.add(new JLabel("File Name: "));
        this.fileName = new JTextField(30);
        panel.add(this.fileName);
        this.fileName.addActionListener(saveFileListener);
        this.fileDialog.getContentPane().add((Component)panel, "Center");
        panel = new JPanel();
        button = new JButton("Cancel");
        panel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Capture.this.fileDialog.setVisible(false);
            }
        });
        button = new JButton("Save File");
        panel.add(button);
        button.addActionListener(saveFileListener);
        this.fileDialog.getContentPane().add((Component)panel, "South");
        this.fileDialog.pack();
        this.menu = new JMenu("Capture");
        this.start = new JMenuItem("Start");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Capture.this.captureEnabled = true;
                Capture.this.start.setEnabled(false);
                Capture.this.stop.setEnabled(true);
            }
        });
        this.menu.add(this.start);
        this.stop = new JMenuItem("Stop");
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Capture.this.captureEnabled = false;
                Capture.this.start.setEnabled(true);
                Capture.this.stop.setEnabled(false);
            }
        });
        this.stop.setEnabled(false);
        this.menu.add(this.stop);
        this.clear = new JMenuItem("Clear");
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Capture.this.textArea.setText("");
            }
        });
        this.menu.add(this.clear);
        this.menu.addSeparator();
        JMenuItem view = new JMenuItem("View/Hide Text");
        view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Capture.this.frame.isVisible()) {
                    Capture.this.frame.setVisible(false);
                    Capture.this.frame.hide();
                } else {
                    Capture.this.frame.setVisible(true);
                    Capture.this.frame.show();
                }
            }
        });
        this.menu.add(view);
        bus.registerPluginListener(new ConfigurationListener(){

            @Override
            public void setConfiguration(PluginConfig config) {
                JMenuItem save = new JMenuItem("Save As File");
                Capture.this.menu.add(save);
                String tmp = config.getProperty("Capture", id, "file.url");
                if (tmp != null) {
                    try {
                        Capture.this.remoteUrlList.put("URL.file", new URL(tmp));
                        tmp = config.getProperty("Capture", id, "file.params");
                        if (tmp != null) {
                            Capture.this.remoteUrlList.put("URL.file.params.orig", tmp);
                        }
                        save.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Capture.this.fileDialog.setVisible(true);
                            }
                        });
                        save.setActionCommand("URL.file");
                    }
                    catch (MalformedURLException e) {
                        System.err.println("capture url invalid: " + e);
                    }
                } else {
                    save.setEnabled(false);
                }
                int i = 1;
                while ((tmp = config.getProperty("Capture", id, i + ".url")) != null) {
                    try {
                        String urlID = "URL." + i;
                        URL remoteURL = new URL(tmp);
                        Capture.this.remoteUrlList.put(urlID, remoteURL);
                        tmp = config.getProperty("Capture", id, i + ".params");
                        if (tmp != null) {
                            Capture.this.remoteUrlList.put(urlID + ".params", tmp);
                        }
                        save = (tmp = config.getProperty("Capture", id, i + ".name")) != null ? new JMenuItem("Save As " + tmp) : new JMenuItem("Save As " + remoteURL.toString());
                        save.setEnabled(true);
                        save.addActionListener(Capture.this);
                        save.setActionCommand(urlID);
                        Capture.this.menu.add(save);
                        ++i;
                    }
                    catch (MalformedURLException e) {
                        System.err.println("capture url invalid: " + e);
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String urlID = e.getActionCommand();
        this.saveFile(urlID);
    }

    private void saveFile(String urlID) {
        URL url = (URL)this.remoteUrlList.get(urlID);
        try {
            String str;
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream out = new DataOutputStream(urlConnection.getOutputStream());
            String content = (String)this.remoteUrlList.get(urlID + ".params");
            content = (content == null ? "" : content + "&") + "content=" + URLEncoder.encode(this.textArea.getText());
            out.writeBytes(content);
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while (null != (str = in.readLine())) {
                System.out.println("Capture: " + str);
            }
            in.close();
            this.doneDialog.pack();
            this.doneDialog.setVisible(true);
        }
        catch (IOException ioe) {
            System.err.println("Capture: cannot store text on remote server: " + url);
            ioe.printStackTrace();
            JTextArea errorMsg = new JTextArea(ioe.toString(), 5, 30);
            errorMsg.setEditable(false);
            this.errorDialog.add((Component)errorMsg, "Center");
            this.errorDialog.pack();
            this.errorDialog.setVisible(true);
        }
    }

    @Override
    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    @Override
    public FilterPlugin getFilterSource() {
        return this.source;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int size = this.source.read(b);
        if (this.captureEnabled && size > 0) {
            String tmp = new String(b, 0, size);
            this.textArea.append(tmp);
        }
        return size;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.captureEnabled) {
            this.textArea.append(new String(b));
        }
        this.source.write(b);
    }

    @Override
    public JComponent getPluginVisual() {
        return null;
    }

    @Override
    public JMenu getPluginMenu() {
        return this.menu;
    }
}

