/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.ReturnFocusRequest;
import de.mud.jta.event.SocketRequest;
import de.mud.jta.event.TelnetCommandRequest;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ButtonBar
extends Plugin
implements FilterPlugin,
VisualPlugin,
ActionListener,
ListSelectionListener {
    protected JPanel panel = new JPanel();
    private Map buttons = null;
    private Map choices = null;
    private Map fields = null;
    private boolean clearFields = true;
    FilterPlugin source;

    public ButtonBar(PluginBus bus, final String id) {
        super(bus, id);
        bus.registerPluginListener(new ConfigurationListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setConfiguration(PluginConfig cfg) {
                String file = cfg.getProperty("ButtonBar", id, "setup");
                ButtonBar.this.clearFields = new Boolean(cfg.getProperty("ButtonBar", id, "clearFields"));
                if (file == null) {
                    ButtonBar.this.error("no setup file");
                    return;
                }
                StreamTokenizer setup = null;
                InputStream is = null;
                try {
                    is = this.getClass().getResourceAsStream(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (is == null) {
                    try {
                        is = new URL(file).openStream();
                    }
                    catch (Exception ue) {
                        ButtonBar.this.error("could not find: " + file);
                        return;
                    }
                }
                try {
                    InputStreamReader ir = new InputStreamReader(is);
                    setup = new StreamTokenizer(new BufferedReader(ir));
                }
                catch (Exception e) {
                    ButtonBar.this.error("cannot load " + file + ": " + e);
                    return;
                }
                setup.commentChar(35);
                setup.quoteChar(34);
                ButtonBar.this.fields = new HashMap();
                ButtonBar.this.buttons = new HashMap();
                ButtonBar.this.choices = new HashMap();
                GridBagLayout l = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                ButtonBar.this.panel.setLayout(l);
                c.fill = 1;
                int ChoiceCount = 0;
                try {
                    int token;
                    block11: while ((token = setup.nextToken()) != -1) {
                        JList list;
                        String ident;
                        switch (token) {
                            case -3: {
                                String descr;
                                c.gridwidth = 1;
                                c.weightx = 0.0;
                                c.weighty = 0.0;
                                if (setup.sval.equals("button")) {
                                    token = setup.nextToken();
                                    if (token != -1) {
                                        descr = setup.sval;
                                        token = setup.nextToken();
                                        if (token != -1) {
                                            JButton b = new JButton(descr);
                                            ButtonBar.this.buttons.put(b, setup.sval);
                                            b.addActionListener(ButtonBar.this);
                                            l.setConstraints(b, ButtonBar.this.constraints(c, setup));
                                            ButtonBar.this.panel.add(b);
                                            continue block11;
                                        }
                                        ButtonBar.this.error(descr + ": missing button command");
                                        continue block11;
                                    }
                                    ButtonBar.this.error("unexpected end of file");
                                    continue block11;
                                }
                                if (setup.sval.equals("label")) {
                                    token = setup.nextToken();
                                    if (token != -1) {
                                        descr = setup.sval;
                                        JLabel b = new JLabel(descr);
                                        l.setConstraints(b, ButtonBar.this.constraints(c, setup));
                                        ButtonBar.this.panel.add(b);
                                        continue block11;
                                    }
                                    ButtonBar.this.error("unexpected end of file");
                                    continue block11;
                                }
                                if (setup.sval.equals("choice")) {
                                    ident = "C" + ++ChoiceCount + ".";
                                    list = new JList();
                                    ButtonBar.this.choices.put(list, ident);
                                    list.addListSelectionListener(ButtonBar.this);
                                    l.setConstraints(list, ButtonBar.this.constraints(c, setup));
                                    ButtonBar.this.panel.add(list);
                                    break;
                                }
                                if (!setup.sval.equals("input")) continue block11;
                                token = setup.nextToken();
                                if (token != -1) {
                                    descr = setup.sval;
                                    token = setup.nextToken();
                                    if (token == -2) {
                                        int size = (int)setup.nval;
                                        String init = "";
                                        String command = "";
                                        token = setup.nextToken();
                                        if (ButtonBar.isKeyword(setup.sval)) {
                                            setup.pushBack();
                                        } else {
                                            command = setup.sval;
                                        }
                                        token = setup.nextToken();
                                        if (ButtonBar.isKeyword(setup.sval)) {
                                            setup.pushBack();
                                            init = command;
                                        } else {
                                            init = setup.sval;
                                        }
                                        JTextField t = new JTextField(init, size);
                                        if (!init.equals(command)) {
                                            ButtonBar.this.buttons.put(t, command);
                                            t.addActionListener(ButtonBar.this);
                                        }
                                        ButtonBar.this.fields.put(descr, t);
                                        l.setConstraints(t, ButtonBar.this.constraints(c, setup));
                                        ButtonBar.this.panel.add(t);
                                        continue block11;
                                    }
                                    ButtonBar.this.error(descr + ": missing field size");
                                    continue block11;
                                }
                                ButtonBar.this.error("unexpected end of file");
                                continue block11;
                            }
                            default: {
                                ButtonBar.this.error("syntax error at line " + setup.lineno());
                                continue block11;
                            }
                        }
                        while ((token = setup.nextToken()) != -1) {
                            if (ButtonBar.isKeyword(setup.sval)) {
                                setup.pushBack();
                                break;
                            }
                            String descr = setup.sval;
                            token = setup.nextToken();
                            if (token == -1) {
                                ButtonBar.this.error("unexpected end of file");
                                continue;
                            }
                            String value = setup.sval;
                            if (ButtonBar.isKeyword(value)) {
                                System.err.println(descr + ": missing choice command");
                                setup.pushBack();
                                break;
                            }
                            System.out.println("choice: name='" + descr + "', value='" + value);
                            list.add(descr, new JLabel(descr));
                            ButtonBar.this.choices.put(ident + descr, value);
                        }
                        ButtonBar.this.error("choices hash: " + ButtonBar.this.choices);
                    }
                }
                catch (IOException e) {
                    ButtonBar.this.error("unexpected error while reading setup: " + e);
                }
                ButtonBar.this.panel.validate();
            }
        });
    }

    private GridBagConstraints constraints(GridBagConstraints c, StreamTokenizer setup) throws IOException {
        if (setup.nextToken() == -3) {
            if (setup.sval.equals("break")) {
                c.gridwidth = 0;
            } else if (setup.sval.equals("stretch")) {
                c.weightx = 1.0;
            } else {
                setup.pushBack();
            }
        } else {
            setup.pushBack();
        }
        return c;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        String ident = (String)this.choices.get(evt.getSource());
        if (ident != null) {
            JList list = (JList)evt.getSource();
            String tmp = (String)this.choices.get(ident + list.getSelectedValue());
            if (tmp != null) {
                this.processEvent(tmp);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String tmp = (String)this.buttons.get(evt.getSource());
        if (tmp != null) {
            this.processEvent(tmp);
        }
    }

    private void processEvent(String tmp) {
        String cmd = "";
        String function = null;
        int idx = 0;
        int oldidx = 0;
        block16: while ((idx = tmp.indexOf(92, oldidx)) >= 0 && ++idx <= tmp.length()) {
            cmd = cmd + tmp.substring(oldidx, idx - 1);
            switch (tmp.charAt(idx)) {
                case 'b': {
                    cmd = cmd + "\b";
                    break;
                }
                case 'e': {
                    cmd = cmd + "\u001b";
                    break;
                }
                case 'n': {
                    cmd = cmd + "\n";
                    break;
                }
                case 'r': {
                    cmd = cmd + "\r";
                    break;
                }
                case '$': {
                    int ni = tmp.indexOf(40, idx + 1);
                    if (ni < idx) {
                        this.error("ERROR: Function: missing '('");
                        break;
                    }
                    if (ni == ++idx) {
                        this.error("ERROR: Function: missing name");
                        break;
                    }
                    function = tmp.substring(idx, ni);
                    idx = ni + 1;
                    if ((ni = tmp.indexOf(41, idx)) < idx) {
                        this.error("ERROR: Function: missing ')'");
                        break;
                    }
                    tmp = tmp.substring(idx, ni);
                    oldidx = 0;
                    idx = 0;
                    continue block16;
                }
                case '@': {
                    JTextField t;
                    int ni = tmp.indexOf(64, idx + 1);
                    if (ni < idx) {
                        this.error("ERROR: Input Field: '@'-End Marker not found");
                        break;
                    }
                    if (ni == ++idx) {
                        this.error("ERROR: Input Field: no name specified");
                        break;
                    }
                    String name = tmp.substring(idx, ni);
                    idx = ni;
                    if (this.fields == null || (t = (JTextField)this.fields.get(name)) == null) {
                        this.error("ERROR: Input Field: requested input \"" + name + "\" does not exist");
                        break;
                    }
                    cmd = cmd + t.getText();
                    if (!this.clearFields) break;
                    t.setText("");
                    break;
                }
                default: {
                    cmd = cmd + tmp.substring(idx++, idx);
                }
            }
            oldidx = ++idx;
        }
        if (oldidx <= tmp.length()) {
            cmd = cmd + tmp.substring(oldidx, tmp.length());
        }
        if (function != null) {
            block39: {
                if (function.equals("break")) {
                    this.bus.broadcast(new TelnetCommandRequest(-13));
                    return;
                }
                if (function.equals("exit")) {
                    try {
                        System.exit(0);
                    }
                    catch (Exception e) {
                        this.error("cannot exit: " + e);
                    }
                }
                if (function.equals("connect")) {
                    String address = null;
                    int port = -1;
                    try {
                        idx = cmd.indexOf(",");
                        if (idx >= 0) {
                            try {
                                port = Integer.parseInt(cmd.substring(idx + 1, cmd.length()));
                            }
                            catch (Exception e) {
                                port = -1;
                            }
                            cmd = cmd.substring(0, idx);
                        }
                        if (cmd.length() > 0) {
                            address = cmd;
                        }
                        if (address != null) {
                            if (port != -1) {
                                this.bus.broadcast(new SocketRequest(address, port));
                            } else {
                                this.bus.broadcast(new SocketRequest(address, 23));
                            }
                            break block39;
                        }
                        this.error("connect: no address");
                    }
                    catch (Exception e) {
                        this.error("connect(): failed");
                        e.printStackTrace();
                    }
                } else if (function.equals("disconnect")) {
                    this.bus.broadcast(new SocketRequest());
                } else if (function.equals("detach")) {
                    this.error("detach not implemented yet");
                } else {
                    this.error("ERROR: function not implemented: \"" + function + "\"");
                }
            }
            return;
        }
        if (cmd.length() > 0) {
            try {
                this.write(cmd.getBytes());
                this.bus.broadcast(new ReturnFocusRequest());
            }
            catch (IOException e) {
                this.error("send: " + e);
            }
        }
    }

    @Override
    public JComponent getPluginVisual() {
        return this.panel;
    }

    @Override
    public JMenu getPluginMenu() {
        return null;
    }

    @Override
    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    @Override
    public FilterPlugin getFilterSource() {
        return this.source;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.source.read(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.source.write(b);
    }

    private static boolean isKeyword(String txt) {
        return txt.equals("button") || txt.equals("label") || txt.equals("input") || txt.equals("stretch") || txt.equals("choice") || txt.equals("break");
    }
}

