/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.telnet.TelnetProtocolHandler;
import de.mud.terminal.SwingTerminal;
import de.mud.terminal.vt320;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SmallApplet
extends Applet
implements Runnable {
    private static final int debug = 0;
    private String host;
    private String port;
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private Thread reader;
    private vt320 emulation;
    private SwingTerminal terminal;
    private TelnetProtocolHandler telnet;
    private boolean localecho = false;
    boolean running = false;

    @Override
    public void init() {
        this.host = this.getParameter("host");
        this.port = this.getParameter("port");
        this.emulation = new vt320(){

            @Override
            public void write(byte[] b) {
                try {
                    if (SmallApplet.this.localecho) {
                        SmallApplet.this.emulation.putString(new String(b));
                    }
                    SmallApplet.this.telnet.transpose(b);
                }
                catch (IOException e) {
                    System.err.println("jta: error sending data: " + e);
                }
            }
        };
        this.terminal = new SwingTerminal(this.emulation);
        this.setLayout(new BorderLayout());
        this.add("Center", this.terminal);
        this.telnet = new TelnetProtocolHandler(){

            @Override
            public String getTerminalType() {
                return SmallApplet.this.emulation.getTerminalID();
            }

            @Override
            public Dimension getWindowSize() {
                return new Dimension(SmallApplet.this.emulation.getColumns(), SmallApplet.this.emulation.getRows());
            }

            @Override
            public void setLocalEcho(boolean echo) {
                SmallApplet.this.localecho = true;
            }

            @Override
            public void notifyEndOfRecord() {
            }

            @Override
            public void write(byte[] b) throws IOException {
                SmallApplet.this.os.write(b);
            }
        };
    }

    @Override
    public void start() {
        if (this.socket != null) {
            this.stop();
        }
        try {
            this.socket = new Socket(this.host, Integer.parseInt(this.port));
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
            this.reader = new Thread(this);
            this.running = true;
            this.reader.start();
        }
        catch (Exception e) {
            System.err.println("jta: error connecting: " + e);
            this.stop();
        }
    }

    @Override
    public void stop() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                System.err.println("jta: could not cleanly disconnect: " + e);
            }
            this.socket = null;
            try {
                this.running = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reader = null;
        }
    }

    @Override
    public void run() {
        byte[] b = new byte[256];
        int n = 0;
        while (this.running && n >= 0) {
            try {
                do {
                    if ((n = this.telnet.negotiate(b)) <= 0) continue;
                    this.emulation.putString(new String(b, 0, n));
                } while (this.running && n > 0);
                n = this.is.read(b);
                this.telnet.inputfeed(b, n);
            }
            catch (IOException e) {
                this.stop();
                break;
            }
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

