/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginListener;
import de.mud.jta.PluginMessage;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PluginLoader
implements PluginBus {
    public static final String ID = "$Id$";
    private static final int debug = 0;
    private Vector PATH = null;
    private List filter = new ArrayList();
    private Map plugins;
    private Vector listener = new Vector();

    public PluginLoader() {
        this(null);
    }

    public PluginLoader(Vector path) {
        this.plugins = new HashMap();
        if (path == null) {
            this.PATH = new Vector();
            this.PATH.addElement("de.mud.jta.plugin");
        } else {
            this.PATH = path;
        }
    }

    public Plugin addPlugin(String name, String id) {
        Plugin plugin = this.loadPlugin(name, id);
        if (plugin == null) {
            plugin = this.loadPlugin(null, name, id);
        }
        if (plugin == null) {
            System.err.println("plugin loader: plugin '" + name + "' was not found!");
            return null;
        }
        if (plugin instanceof FilterPlugin) {
            if (this.filter.size() > 0) {
                ((FilterPlugin)((Object)plugin)).setFilterSource((FilterPlugin)this.filter.get(this.filter.size() - 1));
            }
            this.filter.add(plugin);
        }
        this.plugins.put(name + (id == null ? "" : "(" + id + ")"), plugin);
        return plugin;
    }

    public Plugin replacePlugin(String name, String id) {
        Plugin oldPlugin;
        Plugin plugin = this.loadPlugin(name, id);
        if (plugin != null && this.filter.contains(oldPlugin = (Plugin)this.plugins.get(name + (id == null ? "" : "(" + id + ")")))) {
            int index = this.filter.indexOf(oldPlugin);
            this.filter.set(index, plugin);
            ((FilterPlugin)((Object)plugin)).setFilterSource(((FilterPlugin)((Object)oldPlugin)).getFilterSource());
            if (index < this.filter.size() - 1) {
                ((FilterPlugin)this.filter.get(index + 1)).setFilterSource((FilterPlugin)((Object)plugin));
            }
        }
        return plugin;
    }

    private Plugin loadPlugin(String name, String id) {
        Plugin plugin = null;
        Enumeration pathList = this.PATH.elements();
        while (pathList.hasMoreElements()) {
            String path = (String)pathList.nextElement();
            plugin = this.loadPlugin(path, name, id);
            if (plugin == null) continue;
            return plugin;
        }
        plugin = this.loadPlugin(null, name, id);
        return plugin;
    }

    private Plugin loadPlugin(String path, String name, String id) {
        Plugin plugin = null;
        String fullClassName = path == null ? name : path + "." + name;
        try {
            Class<?> c = Class.forName(fullClassName);
            Constructor<?> cc = c.getConstructor(PluginBus.class, String.class);
            plugin = (Plugin)cc.newInstance(this, id);
            return plugin;
        }
        catch (ClassNotFoundException c) {
        }
        catch (Exception e) {
            System.err.println("plugin loader: can't load plugin: " + fullClassName);
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void registerPluginListener(PluginListener l) {
        this.listener.addElement(l);
    }

    @Override
    public Object broadcast(PluginMessage message) {
        if (message == null || this.listener == null) {
            return null;
        }
        Enumeration e = this.listener.elements();
        Object res = null;
        while (res == null && e.hasMoreElements()) {
            res = message.firePluginMessage((PluginListener)e.nextElement());
        }
        return res;
    }

    public Map getPlugins() {
        return this.plugins;
    }
}

