/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.pictureservice.eps;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.SiteIDUtil;
import com.ebay.sdk.pictureservice.PictureInfo;
import com.ebay.sdk.pictureservice.PictureService;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.sdk.util.eBayUtil;
import com.ebay.soap.eBLBaseComponents.AbstractResponseType;
import com.ebay.soap.eBLBaseComponents.AckCodeType;
import com.ebay.soap.eBLBaseComponents.ObjectFactory;
import com.ebay.soap.eBLBaseComponents.PhotoDisplayCodeType;
import com.ebay.soap.eBLBaseComponents.PictureSetCodeType;
import com.ebay.soap.eBLBaseComponents.UploadSiteHostedPicturesRequestType;
import com.ebay.soap.eBLBaseComponents.UploadSiteHostedPicturesResponseType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class eBayPictureServiceXMLCall
implements PictureService {
    private ApiContext apiContext;
    private static final Logger log = LoggerFactory.getLogger(eBayPictureServiceXMLCall.class);
    private static final String EBAY_NAMESPACE = "urn:ebay:apis:eBLBaseComponents";
    private static final String API_CALL_NAME = "UploadSiteHostedPictures";
    private static final String BOUNDARY = "gc0p4Jq0M2Yt08jU534c0p";
    private static final String CRLF = "\r\n";

    public eBayPictureServiceXMLCall(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    @Override
    public UploadSiteHostedPicturesResponseType uploadSiteHostedPictures(UploadSiteHostedPicturesRequestType uploadSiteHostedPicturesRequestType) {
        ApiLogging apiLogging = this.apiContext.getApiLogging();
        UploadSiteHostedPicturesResponseType uploadSiteHostedPicturesResponseType = null;
        try {
            String string;
            Document document = this.marshal(uploadSiteHostedPicturesRequestType);
            this.addAuthToken(document);
            if (apiLogging != null && apiLogging.isLogSOAPMessages()) {
                string = XmlUtil.getXmlStringFromDom(document);
                this.logMessage("UploadSiteHostedPicturesRequest", string);
            }
            string = this.xmlToString(document);
            String string2 = this.sendHttpRequest(string);
            if (apiLogging != null && apiLogging.isLogSOAPMessages()) {
                Document document2 = XmlUtil.createDom(string2);
                String string3 = XmlUtil.getXmlStringFromDom(document2);
                this.logMessage("UploadSiteHostedPicturesResponse", string3);
            }
            uploadSiteHostedPicturesResponseType = this.unmarshal(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uploadSiteHostedPicturesResponseType;
    }

    private String sendHttpRequest(String string) {
        try {
            String string2;
            URL uRL = new URL(this.apiContext.getEpsServerUrl());
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestProperty("Content-Type", "text/xml");
            httpsURLConnection.addRequestProperty("X-EBAY-API-SITEID", String.valueOf(SiteIDUtil.toNumericalID(this.apiContext.getSite())));
            httpsURLConnection.setRequestProperty("X-EBAY-API-CALL-NAME", API_CALL_NAME);
            httpsURLConnection.addRequestProperty("X-EBAY-API-COMPATIBILITY-LEVEL", this.apiContext.getWSDLVersion());
            String string3 = this.apiContext.getApiCredential().getOAuthToken();
            String string4 = this.apiContext.getApiCredential().geteBayToken();
            if (!(string3 == null && string3.trim().length() <= 0 || string4 != null && string4.trim().length() != 0)) {
                httpsURLConnection.addRequestProperty("X-EBAY-API-IAF-TOKEN", string3);
            }
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(httpsURLConnection.getOutputStream()));
            printWriter.println(string);
            printWriter.close();
            httpsURLConnection.connect();
            InputStreamReader inputStreamReader = new InputStreamReader(httpsURLConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
            String string5 = stringBuffer.toString();
            inputStreamReader.close();
            bufferedReader.close();
            return string5;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean UpLoadSiteHostedPicture(PictureInfo pictureInfo, UploadSiteHostedPicturesRequestType uploadSiteHostedPicturesRequestType) {
        ApiLogging apiLogging = this.apiContext.getApiLogging();
        try {
            Object object;
            String string;
            Document document = this.marshal(uploadSiteHostedPicturesRequestType);
            this.addAuthToken(document);
            if (apiLogging != null && apiLogging.isLogSOAPMessages()) {
                string = XmlUtil.getXmlStringFromDom(document);
                this.logMessage("UploadSiteHostedPicturesRequest", string);
            }
            string = this.xmlToString(document);
            String string2 = this.sendFile(pictureInfo.getPictureFilePath(), string);
            if (apiLogging != null && apiLogging.isLogSOAPMessages()) {
                object = XmlUtil.createDom(string2);
                String string3 = XmlUtil.getXmlStringFromDom((Document)object);
                this.logMessage("UploadSiteHostedPicturesResponse", string3);
            }
            object = this.unmarshal(string2);
            pictureInfo.setReponse((UploadSiteHostedPicturesResponseType)object);
            if (((AbstractResponseType)object).getErrors() == null || ((AbstractResponseType)object).getErrors().length == 0) {
                pictureInfo.setURL(((UploadSiteHostedPicturesResponseType)object).getSiteHostedPictureDetails().getFullURL());
                return true;
            }
            if (((AbstractResponseType)object).getErrors().length > 0 && ((AbstractResponseType)object).getAck() == AckCodeType.WARNING) {
                pictureInfo.setURL(((UploadSiteHostedPicturesResponseType)object).getSiteHostedPictureDetails().getFullURL());
                pictureInfo.setErrorType("PICTURE SERVICE RESPONSE WARNING");
                pictureInfo.setErrorMessage(((AbstractResponseType)object).getErrors()[0].getShortMessage());
                if (apiLogging != null && apiLogging.isLogExceptions()) {
                    log.warn("PICTURE SERVICE RESPONSE WARNING");
                    log.warn(((AbstractResponseType)object).getErrors()[0].getShortMessage());
                }
                return true;
            }
            pictureInfo.setErrorType("PICTURE SERVICE RESPONSE ERROR");
            pictureInfo.setErrorMessage(((AbstractResponseType)object).getErrors()[0].getShortMessage());
            if (apiLogging != null && apiLogging.isLogExceptions()) {
                log.error("PICTURE SERVICE RESPONSE ERROR");
                log.error(((AbstractResponseType)object).getErrors()[0].getShortMessage());
            }
            return false;
        }
        catch (Exception exception) {
            pictureInfo.setErrorType("PICTURE SERVICE UPLOAD ERROR");
            pictureInfo.setErrorMessage(exception.getMessage());
            if (apiLogging != null && apiLogging.isLogExceptions()) {
                log.error("fail to upload picture to eBay picture server!");
                log.error(exception.getMessage());
            }
            return false;
        }
    }

    private void logMessage(String string, String string2) {
        String string3 = eBayUtil.toAPITimeString(Calendar.getInstance().getTime());
        log.info(MessageFormat.format("[{0}][{1}][{2}]\n", string, string3, this.apiContext.getEpsServerUrl()));
        log.info(string2);
    }

    @Override
    public boolean uploadPicture(PhotoDisplayCodeType photoDisplayCodeType, PictureInfo pictureInfo) {
        UploadSiteHostedPicturesRequestType uploadSiteHostedPicturesRequestType = new UploadSiteHostedPicturesRequestType();
        if (photoDisplayCodeType.equals((Object)PhotoDisplayCodeType.SUPER_SIZE) || photoDisplayCodeType.equals((Object)PhotoDisplayCodeType.PICTURE_PACK)) {
            uploadSiteHostedPicturesRequestType.setPictureSet(PictureSetCodeType.SUPERSIZE);
        }
        return this.UpLoadSiteHostedPicture(pictureInfo, uploadSiteHostedPicturesRequestType);
    }

    @Override
    public int uploadPictures(PhotoDisplayCodeType photoDisplayCodeType, PictureInfo[] pictureInfoArray) {
        int n = 0;
        for (int i = 0; i < pictureInfoArray.length; ++i) {
            if (!this.uploadPicture(photoDisplayCodeType, pictureInfoArray[i])) continue;
            ++n;
        }
        return n;
    }

    private String xmlToString(Document document) throws TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(dOMSource, streamResult);
        return stringWriter.getBuffer().toString();
    }

    private Document marshal(UploadSiteHostedPicturesRequestType uploadSiteHostedPicturesRequestType) throws JAXBException, ParserConfigurationException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{UploadSiteHostedPicturesRequestType.class});
        Marshaller marshaller = jAXBContext.createMarshaller();
        if (uploadSiteHostedPicturesRequestType == null) {
            uploadSiteHostedPicturesRequestType = new UploadSiteHostedPicturesRequestType();
        }
        JAXBElement<UploadSiteHostedPicturesRequestType> jAXBElement = new ObjectFactory().createUploadSiteHostedPicturesRequest(uploadSiteHostedPicturesRequestType);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        marshaller.marshal(jAXBElement, (Node)document);
        return document;
    }

    private UploadSiteHostedPicturesResponseType unmarshal(String string) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{UploadSiteHostedPicturesResponseType.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((Source)new StreamSource(new StringReader(string)));
        UploadSiteHostedPicturesResponseType uploadSiteHostedPicturesResponseType = (UploadSiteHostedPicturesResponseType)jAXBElement.getValue();
        return uploadSiteHostedPicturesResponseType;
    }

    private String sendFile(String string, String string2) throws IOException {
        URL uRL = new URL(this.apiContext.getEpsServerUrl());
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        this.setConnectionProperty(httpURLConnection);
        String string3 = "--gc0p4Jq0M2Yt08jU534c0p\r\nContent-Disposition: form-data; name=document\r\nContent-Type: text/xml; charset=\"UTF-8\"\r\n\r\n" + string2 + CRLF + "--" + BOUNDARY + CRLF + "Content-Disposition: form-data; name=image; filename=image" + CRLF + "Content-Transfer-Encoding: binary" + CRLF + "Content-Type: application/octet-stream" + CRLF + CRLF;
        String string4 = "\r\n--gc0p4Jq0M2Yt08jU534c0p--\r\n";
        byte[] byArray = this.readInFile(string);
        httpURLConnection.connect();
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(string3.getBytes());
        outputStream.write(byArray);
        outputStream.write(string4.getBytes());
        outputStream.flush();
        outputStream.close();
        StringBuffer stringBuffer = this.readInResponse(httpURLConnection);
        httpURLConnection.disconnect();
        return stringBuffer.toString();
    }

    private StringBuffer readInResponse(HttpURLConnection httpURLConnection) throws IOException {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string + "\n");
        }
        inputStreamReader.close();
        bufferedReader.close();
        return stringBuffer;
    }

    private byte[] readInFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    private void setConnectionProperty(HttpURLConnection httpURLConnection) throws ProtocolException {
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=gc0p4Jq0M2Yt08jU534c0p");
        httpURLConnection.addRequestProperty("X-EBAY-API-COMPATIBILITY-LEVEL", this.apiContext.getWSDLVersion());
        httpURLConnection.addRequestProperty("X-EBAY-API-CALL-NAME", API_CALL_NAME);
        httpURLConnection.addRequestProperty("X-EBAY-API-SITEID", String.valueOf(SiteIDUtil.toNumericalID(this.apiContext.getSite())));
        httpURLConnection.addRequestProperty("X-EBAY-API-DETAIL-LEVEL", "0");
        String string = this.apiContext.getApiCredential().geteBayToken();
        String string2 = this.apiContext.getApiCredential().getOAuthToken();
        if (!(string2 == null && string2.trim().length() <= 0 || string != null && string.trim().length() != 0)) {
            httpURLConnection.addRequestProperty("X-EBAY-API-IAF-TOKEN", string2);
        }
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
    }

    private void addAuthToken(Document document) throws SdkException {
        Node node = XmlUtil.getChildByName(document, "UploadSiteHostedPicturesRequest");
        String string = this.apiContext.getApiCredential().geteBayToken();
        String string2 = this.apiContext.getApiCredential().getOAuthToken();
        if (string == null || string.trim().length() == 0) {
            if (string2 == null || string2.trim().length() == 0) {
                throw new SdkException("No Token Found!!!");
            }
        } else if (string != null || string.trim().length() > 0) {
            Element element = XmlUtil.appendChildNode(document, EBAY_NAMESPACE, node, "RequesterCredentials");
            XmlUtil.appendChildNode(document, (Node)element, "eBayAuthToken", string);
        }
    }
}

