/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.SdkHTTPException;
import com.ebay.sdk.SdkSoapException;
import com.ebay.soap.eBLBaseComponents.ErrorType;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ExceptionFilter {
    private String[] triggerApiErrorCodes;
    private int[] triggerHTTPErrorCodes;
    private Class[] triggerExceptions;

    public ExceptionFilter() {
    }

    public ExceptionFilter(String string, String string2, String string3) {
        this.triggerApiErrorCodes = this.parseTriggerErrorCodes(string);
        this.triggerHTTPErrorCodes = this.parseTriggerHttpStatusCodes(string3);
        this.triggerExceptions = this.parseTriggerExceptions(string2);
    }

    private Class[] parseTriggerExceptions(String string) {
        Class[] classArray;
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ArrayList<Class> arrayList = new ArrayList<Class>();
        while (stringTokenizer.hasMoreTokens()) {
            classArray = stringTokenizer.nextToken();
            Class clazz = ExceptionFilter.getClassFromName((String)classArray);
            arrayList.add(clazz);
        }
        classArray = new Class[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            classArray[i] = (Class)arrayList.get(i);
        }
        return classArray;
    }

    private static Class getClassFromName(String string) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private int[] parseTriggerHttpStatusCodes(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int[] nArray = new int[stringTokenizer.countTokens()];
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = stringTokenizer.nextToken();
            nArray[i] = Integer.parseInt(string2);
        }
        return nArray;
    }

    private String[] parseTriggerErrorCodes(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return (String[])arrayList.toArray();
    }

    public Class[] getTriggerExceptions() {
        return this.triggerExceptions;
    }

    public void setTriggerExceptions(Class[] classArray) {
        this.triggerExceptions = classArray;
    }

    public String[] getTriggerApiErrorCodes() {
        return this.triggerApiErrorCodes;
    }

    public void setTriggerApiErrorCodes(String[] stringArray) {
        this.triggerApiErrorCodes = stringArray;
    }

    public int[] getTriggerHTTPErrorCodes() {
        return this.triggerHTTPErrorCodes;
    }

    public void setTriggerHTTPErrorCodes(int[] nArray) {
        this.triggerHTTPErrorCodes = nArray;
    }

    private boolean containsErrorCode(String string, ErrorType[] errorTypeArray) {
        for (int i = 0; i < errorTypeArray.length; ++i) {
            String string2 = errorTypeArray[i].getErrorCode();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean containsException(Class[] classArray, Class clazz) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].getName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean containsInt(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean matches(Exception exception) {
        ErrorType[] errorTypeArray;
        if (exception == null) {
            return false;
        }
        if (this.triggerExceptions == null ? this.triggerApiErrorCodes == null && this.triggerHTTPErrorCodes == null : this.containsException(this.triggerExceptions, exception.getClass())) {
            return true;
        }
        if (this.triggerApiErrorCodes != null) {
            SdkException sdkException;
            errorTypeArray = null;
            if (exception instanceof ApiException) {
                sdkException = (ApiException)exception;
                errorTypeArray = ((ApiException)sdkException).getErrors();
            } else if (exception instanceof SdkSoapException) {
                sdkException = (SdkSoapException)exception;
                errorTypeArray = new ErrorType[]{((SdkSoapException)sdkException).getErrorType()};
            }
            if (errorTypeArray != null) {
                for (int i = 0; i < this.triggerApiErrorCodes.length; ++i) {
                    if (!this.containsErrorCode(this.triggerApiErrorCodes[i], errorTypeArray)) continue;
                    return true;
                }
            }
        }
        return this.triggerHTTPErrorCodes != null && exception instanceof SdkHTTPException && this.containsInt(this.triggerHTTPErrorCodes, (errorTypeArray = (ErrorType[])exception).getErrorCode());
    }
}

