/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk;

import com.ebay.sdk.ApiAccount;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiCredential;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.ApiLogging;
import com.ebay.sdk.CallRetry;
import com.ebay.sdk.ExceptionFilter;
import com.ebay.sdk.RequestContext;
import com.ebay.sdk.SdkAPIInterfaceServiceLocator;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.SdkHTTPException;
import com.ebay.sdk.SdkSoapException;
import com.ebay.sdk.SendApiRequestListener;
import com.ebay.sdk.SiteIDUtil;
import com.ebay.sdk.logging.MetricsLogger;
import com.ebay.sdk.util.eBayUtil;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.AbstractResponseType;
import com.ebay.soap.eBLBaseComponents.BotBlockRequestType;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.EBayAPIInterface;
import com.ebay.soap.eBLBaseComponents.ErrorHandlingCodeType;
import com.ebay.soap.eBLBaseComponents.ErrorType;
import com.ebay.soap.eBLBaseComponents.SiteCodeType;
import com.ebay.soap.eBLBaseComponents.WarningLevelCodeType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.event.EventListenerList;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPFaultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCall {
    private SiteCodeType site = null;
    private ApiContext apiContext;
    private DetailLevelCodeType[] detailLevel = new DetailLevelCodeType[0];
    private CallRetry callRetry;
    private AbstractResponseType response = null;
    private String[] outputSelector = new String[0];
    protected EventListenerList sendReqListeners = new EventListenerList();
    private String messageID = null;
    private String endUserIP = null;
    private ErrorHandlingCodeType errorHandling;
    private String invocationID = null;
    private WarningLevelCodeType warningLevel = null;
    private BotBlockRequestType botBlock = null;
    private boolean enableHTTPCompression = true;
    private String[] callsNeedFullCredentials = new String[]{"GetTokenStatus", "RevokeToken"};
    private String[] callsNeedApiAccountOnly = new String[]{"GetSessionID", "FetchToken"};
    private String[] OAuthIsNotSupportedAPI = new String[]{"GetSessionID", "FetchToken", "GetTokenStatus", "RevokeToken"};
    private boolean enableoAuthTokenHTTPHeader = false;
    private static final Logger log = LoggerFactory.getLogger(ApiCall.class);
    protected ApiException apiException;

    public void setEnableoAuthTokenHTTPHeader(boolean bl) {
        this.enableoAuthTokenHTTPHeader = bl;
    }

    public boolean isEnableoAuthTokenHTTPHeader() {
        return this.enableoAuthTokenHTTPHeader;
    }

    public ApiCall() {
    }

    private boolean isOauthDisabledAPI(String string) {
        for (String string2 : this.OAuthIsNotSupportedAPI) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isFullCredentials(String string) {
        for (String string2 : this.callsNeedFullCredentials) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isApiAccountOnly(String string) {
        for (String string2 : this.callsNeedApiAccountOnly) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public ApiCall(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    public ApiContext getApiContext() {
        return this.apiContext;
    }

    public void setApiContext(ApiContext apiContext) {
        this.apiContext = apiContext;
    }

    public void addSendRequestListener(SendApiRequestListener sendApiRequestListener) {
        if (sendApiRequestListener != null) {
            this.sendReqListeners.add(SendApiRequestListener.class, sendApiRequestListener);
        }
    }

    public void removeSendRequestListener(SendApiRequestListener sendApiRequestListener) {
        if (sendApiRequestListener != null) {
            this.sendReqListeners.remove(SendApiRequestListener.class, sendApiRequestListener);
        }
    }

    public DetailLevelCodeType[] getDetailLevel() {
        return this.detailLevel;
    }

    public void setDetailLevel(DetailLevelCodeType[] detailLevelCodeTypeArray) {
        this.detailLevel = detailLevelCodeTypeArray == null ? new DetailLevelCodeType[0] : detailLevelCodeTypeArray;
    }

    public void addDetailLevel(DetailLevelCodeType detailLevelCodeType) {
        int n = this.detailLevel != null ? this.detailLevel.length : 0;
        DetailLevelCodeType[] detailLevelCodeTypeArray = new DetailLevelCodeType[++n];
        if (this.detailLevel != null) {
            for (int i = 0; i < this.detailLevel.length; ++i) {
                detailLevelCodeTypeArray[i] = this.detailLevel[i];
            }
        }
        detailLevelCodeTypeArray[n - 1] = detailLevelCodeType;
        this.detailLevel = detailLevelCodeTypeArray;
    }

    public CallRetry getCallRetry() {
        return this.callRetry;
    }

    public void setCallRetry(CallRetry callRetry) {
        this.callRetry = callRetry;
    }

    public ApiException getApiException() {
        return this.apiException;
    }

    public boolean hasWarning() {
        return this.apiException != null && this.apiException.getSeverityWarningCount() > 0;
    }

    public boolean hasError() {
        return this.apiException != null && this.apiException.getSeverityErrorCount() > 0;
    }

    public String getRequestXml() {
        return this.apiContext.getRequestXml();
    }

    public String getResponseXml() {
        return this.apiContext.getResponseXml();
    }

    public SiteCodeType getSite() {
        return this.site;
    }

    public boolean getEnableCompression() {
        return this.enableHTTPCompression;
    }

    public void setSite(SiteCodeType siteCodeType) {
        this.site = siteCodeType;
    }

    public void setEnableCompression(boolean bl) {
        this.enableHTTPCompression = bl;
    }

    public AbstractResponseType getResponseObject() {
        return this.response;
    }

    private AbstractResponseType callSOAP(EBayAPIInterface eBayAPIInterface, String string, AbstractRequestType abstractRequestType) throws Exception {
        Method method;
        Object object = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
            method = eBayAPIInterface.getClass().getMethod(stringBuffer.toString(), abstractRequestType.getClass());
        }
        catch (Exception exception) {
            throw new SdkException("ApiCall - call method not found: " + exception.getMessage(), exception);
        }
        object = method.invoke((Object)eBayAPIInterface, abstractRequestType);
        return (AbstractResponseType)object;
    }

    public AbstractResponseType execute(AbstractRequestType abstractRequestType) throws ApiException, SdkSoapException, SdkException {
        String string = abstractRequestType.getClass().getName();
        int n = string.lastIndexOf(46);
        int n2 = string.indexOf("RequestType");
        if (n == -1 || n2 == -1) {
            throw new SdkException("Invalid AbstractRequestType parameter.");
        }
        String string2 = string.substring(++n, n2);
        return this.executeByApiName(string2, abstractRequestType);
    }

    void checkProperties(String string) throws SdkException {
        if (this.apiContext == null) {
            throw new SdkException("Please set valid ApiContext property");
        }
        ApiCredential apiCredential = this.apiContext.getApiCredential();
        if (apiCredential == null) {
            throw new SdkException("Please set valid ApiContext.ApiCredential property");
        }
        if (!this.oAuthTokenCredentialHTTPHeader(apiCredential, string)) {
            if (this.isFullCredentials(string)) {
                if (!this.isValidFullCredentials(apiCredential)) {
                    throw new SdkException("This api call needs full credentials, both eBay token and ApiAccount are needed");
                }
            } else {
                String string2 = apiCredential.geteBayToken();
                if (string2 == null || string2.length() == 0) {
                    ApiAccount apiAccount = apiCredential.getApiAccount();
                    if (apiAccount == null) {
                        throw new SdkException("Please either eBay token or ApiAccount plus eBayAccount as credential.");
                    }
                    if (apiAccount.getDeveloper() == null) {
                        throw new SdkException("Please set the API developer (ApiAccount.setDeveloper()).");
                    }
                    if (apiAccount.getApplication() == null) {
                        throw new SdkException("Please set the API application (ApiAccount.setApplication()).");
                    }
                    if (apiAccount.getCertificate() == null) {
                        throw new SdkException("Please set the API certificate (ApiAccount.setCertificate()).");
                    }
                }
            }
        }
    }

    private boolean oAuthTokenCredentialHTTPHeader(ApiCredential apiCredential, String string) {
        String string2 = apiCredential.getOAuthToken();
        String string3 = apiCredential.geteBayToken();
        if (this.isOauthDisabledAPI(string)) {
            this.setEnableoAuthTokenHTTPHeader(false);
        } else if (string2 != null && string2.length() > 0) {
            if (string3 != null && string3.length() > 0) {
                this.setEnableoAuthTokenHTTPHeader(false);
            } else {
                this.setEnableoAuthTokenHTTPHeader(true);
            }
        } else if (string3 != null && string3.length() > 0) {
            this.setEnableoAuthTokenHTTPHeader(false);
        }
        return this.isEnableoAuthTokenHTTPHeader();
    }

    private boolean isValidFullCredentials(ApiCredential apiCredential) {
        String string = apiCredential.geteBayToken();
        if (string == null || string.length() == 0) {
            return false;
        }
        ApiAccount apiAccount = apiCredential.getApiAccount();
        if (apiAccount == null) {
            return false;
        }
        if (apiAccount.getDeveloper() == null) {
            return false;
        }
        if (apiAccount.getApplication() == null) {
            return false;
        }
        return apiAccount.getCertificate() != null;
    }

    private String getDstUrl(String string) {
        SiteCodeType siteCodeType = this.site != null ? this.site : this.apiContext.getSite();
        String string2 = this.apiContext.getRouting() == null ? "" : "&routing=" + this.apiContext.getRouting();
        String string3 = MessageFormat.format("{0}?siteid={1}{2}&callname={3}&client=java", this.apiContext.getApiServerUrl(), new Integer(SiteIDUtil.toNumericalID(siteCodeType)), string2, string);
        String string4 = "";
        ApiAccount apiAccount = this.apiContext.getApiCredential().getApiAccount();
        if (apiAccount != null) {
            string4 = apiAccount.getApplication();
        }
        if (string4 != null && string4.length() > 0) {
            string3 = string3 + "&appid=" + string4;
        }
        return string3;
    }

    private RequestContext getRequestContext(String string, String string2) {
        RequestContext requestContext = new RequestContext();
        requestContext.setEndPointAddress(string2);
        requestContext.setHttpCompressionEnabled(this.enableHTTPCompression);
        if (this.oAuthTokenCredentialHTTPHeader(this.apiContext.getApiCredential(), string)) {
            this.setEnableoAuthTokenHTTPHeader(true);
            requestContext.setoAuthTokenCredentialHTTPHeader(this.enableoAuthTokenHTTPHeader);
        } else {
            if (this.isFullCredentials(string)) {
                requestContext.setFullCredentialsEnabled(true);
            }
            if (this.isApiAccountOnly(string)) {
                requestContext.setApiAccountOnly(true);
            }
        }
        return requestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractResponseType executeByApiName(String string, AbstractRequestType abstractRequestType) throws ApiException, SdkSoapException, SdkException {
        try {
            Object object;
            MetricsLogger.startRecordingSingleCallMetrics(string);
            this.checkProperties(string);
            AbstractResponseType abstractResponseType = null;
            abstractRequestType.setVersion(this.apiContext.getWSDLVersion());
            ApiLogging apiLogging = this.apiContext.getApiLogging();
            EBayAPIInterface eBayAPIInterface = null;
            try {
                Exception exception;
                object = this.getDstUrl(string);
                RequestContext requestContext = this.getRequestContext(string, (String)object);
                eBayAPIInterface = SdkAPIInterfaceServiceLocator.getEBayAPI(this.apiContext, requestContext);
                int n = 0;
                int n2 = 0;
                CallRetry callRetry = this.getCallRetry();
                if (callRetry == null) {
                    callRetry = this.apiContext.getCallRetry();
                }
                if (callRetry != null) {
                    n2 = callRetry.getMaximumRetries();
                }
                abstractRequestType.setDetailLevel(this.getDetailLevel());
                abstractRequestType.setErrorLanguage(this.getApiContext().getErrorLanguage());
                abstractRequestType.setOutputSelector(this.getOutputSelector());
                abstractRequestType.setMessageID(this.getMessageID());
                abstractRequestType.setEndUserIP(this.getEndUserIP());
                abstractRequestType.setErrorHandling(this.getErrorHandling());
                abstractRequestType.setInvocationID(this.getInvocationID());
                abstractRequestType.setWarningLevel(this.getWarningLevel());
                abstractRequestType.setBotBlock(this.getBotBlock());
                this.fireSendRequestEvent(abstractRequestType);
                do {
                    Exception exception2;
                    abstractResponseType = null;
                    exception = null;
                    try {
                        log.info("Sending SOAP request to: " + (String)object);
                        this.response = abstractResponseType = this.callSOAP(eBayAPIInterface, string, abstractRequestType);
                        this.apiContext.incrementTotalCalls();
                        this.apiException = this.getApiException(abstractResponseType);
                        this.checkHardExpirationWarning(abstractResponseType);
                    }
                    catch (Exception exception3) {
                        if (exception3 instanceof InvocationTargetException) {
                            Throwable throwable = ((InvocationTargetException)exception3).getTargetException();
                            exception2 = throwable instanceof Exception ? (Exception)throwable : new SdkException(throwable);
                        }
                        exception = exception2 instanceof HTTPException ? SdkHTTPException.fromHTTPException((HTTPException)exception2) : (exception2 instanceof SOAPFaultException ? SdkSoapException.fromSOAPFaultException((SOAPFaultException)exception2) : exception2);
                    }
                    if (exception == null && (exception2 = this.getApiException(abstractResponseType)) != null && ((ApiException)exception2).getSeverityErrorCount() > 0) {
                        exception = exception2;
                    }
                    if (exception == null) continue;
                    if (callRetry == null || n >= n2 || !callRetry.shouldRetry(exception)) {
                        throw exception;
                    }
                    Thread.sleep(callRetry.getDelayTime());
                    ++n;
                    if (apiLogging == null || !apiLogging.isLogExceptions()) continue;
                    log.error(exception.toString());
                    log.info("Retry " + string + " #" + n + " ...");
                } while (exception != null && n <= n2);
            }
            catch (Exception exception) {
                try {
                    Exception exception4;
                    Object object2;
                    if (exception instanceof InvocationTargetException) {
                        object2 = (InvocationTargetException)exception;
                        exception4 = (Exception)((InvocationTargetException)object2).getTargetException();
                    }
                    if (apiLogging != null && apiLogging.isLogExceptions()) {
                        object2 = apiLogging.getMessageLoggingFilter();
                        if (object2 != null && ((ExceptionFilter)object2).matches(exception4)) {
                            log.info("Exception based logging enabled.");
                            this.logMessage("Request", this.apiContext.getRequestXml());
                            this.logMessage("Response", this.apiContext.getResponseXml());
                        }
                        log.error(exception4.toString());
                    }
                    if (exception4 instanceof ApiException) {
                        throw (ApiException)exception4;
                    }
                    if (exception4 instanceof SdkSoapException) {
                        throw (SdkSoapException)exception4;
                    }
                    if (exception4 instanceof SdkException) {
                        throw (SdkException)exception4;
                    }
                    throw new SdkException("ApiCall.execute() - " + exception4.getMessage(), exception4);
                }
                catch (Throwable throwable) {
                    SdkAPIInterfaceServiceLocator.releaseEBayAPI(eBayAPIInterface);
                    throw throwable;
                }
            }
            SdkAPIInterfaceServiceLocator.releaseEBayAPI(eBayAPIInterface);
            object = abstractResponseType;
            return object;
        }
        finally {
            MetricsLogger.endRecordingSingleCallMetrics();
        }
    }

    private ApiException getApiException(AbstractResponseType abstractResponseType) {
        if (abstractResponseType == null) {
            return null;
        }
        ApiException apiException = null;
        ErrorType[] errorTypeArray = abstractResponseType.getErrors();
        if (errorTypeArray != null && errorTypeArray.length > 0) {
            apiException = new ApiException(errorTypeArray);
        }
        return apiException;
    }

    private void checkHardExpirationWarning(AbstractResponseType abstractResponseType) throws ParseException {
        if (abstractResponseType == null) {
            return;
        }
        String string = abstractResponseType.getHardExpirationWarning();
        if (string != null && string.length() > 0) {
            log.info("eBay token hard expiration warning received.");
            Date date = eBayUtil.fromAPITimeString(string);
            ApiCredential apiCredential = this.apiContext.getApiCredential();
            apiCredential.fireWarnTokenHardExpiration(date);
        }
    }

    private void logMessage(String string, String string2) {
        if (string2 == null) {
            return;
        }
        String string3 = MessageFormat.format("{0} Message: Length={1}", string, new Integer(string2.length()));
        log.info(string3);
        log.info(string2);
    }

    void fireSendRequestEvent(AbstractRequestType abstractRequestType) throws SdkException {
        SendApiRequestListener[] sendApiRequestListenerArray = (SendApiRequestListener[])this.sendReqListeners.getListeners(SendApiRequestListener.class);
        if (sendApiRequestListenerArray != null) {
            for (int i = sendApiRequestListenerArray.length - 1; i >= 0; --i) {
                sendApiRequestListenerArray[i].FilterApiRequest(abstractRequestType);
            }
        }
    }

    public String[] getOutputSelector() {
        return this.outputSelector;
    }

    public void setOutputSelector(String[] stringArray) {
        this.outputSelector = stringArray;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String string) {
        this.messageID = string;
    }

    public String getEndUserIP() {
        return this.endUserIP;
    }

    public void setEndUserIP(String string) {
        this.endUserIP = string;
    }

    public String getInvocationID() {
        return this.invocationID;
    }

    public void setInvocationID(String string) {
        this.invocationID = string;
    }

    public WarningLevelCodeType getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(WarningLevelCodeType warningLevelCodeType) {
        this.warningLevel = warningLevelCodeType;
    }

    public BotBlockRequestType getBotBlock() {
        return this.botBlock;
    }

    public void setBotBlock(BotBlockRequestType botBlockRequestType) {
        this.botBlock = botBlockRequestType;
    }

    public ErrorHandlingCodeType getErrorHandling() {
        return this.errorHandling;
    }

    public void setErrorHandling(ErrorHandlingCodeType errorHandlingCodeType) {
        this.errorHandling = errorHandlingCodeType;
    }
}

