/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.fs.WithFileAttributeCache;

public class SftpPathImpl
extends SftpPath
implements WithFileAttributeCache {
    private SftpClient.Attributes attributes;
    private int cachingLevel;

    public SftpPathImpl(SftpFileSystem fileSystem, String root, List<String> names) {
        super(fileSystem, root, names);
    }

    protected void cacheAttributes(boolean doCache) {
        if (doCache) {
            if (this.cachingLevel == 0) {
                this.attributes = null;
            }
            ++this.cachingLevel;
        } else if (this.cachingLevel > 0) {
            --this.cachingLevel;
            if (this.cachingLevel == 0) {
                this.attributes = null;
            }
        } else {
            throw new IllegalStateException("SftpPathImpl.cacheAttributes(boolean) not properly nested");
        }
    }

    @Override
    public void setAttributes(SftpClient.Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public SftpClient.Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public <T> T withAttributeCache(IOFunction<Path, T> operation) throws IOException {
        this.cacheAttributes(true);
        try {
            T t = operation.apply(this);
            return t;
        }
        finally {
            this.cacheAttributes(false);
        }
    }
}

