/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.extensions.helpers;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.sftp.client.RawSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpMessage;
import org.apache.sshd.sftp.client.extensions.SftpClientExtension;
import org.apache.sshd.sftp.client.impl.SftpResponse;
import org.apache.sshd.sftp.client.impl.SftpStatus;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.common.SftpException;

public abstract class AbstractSftpClientExtension
extends AbstractLoggingBean
implements SftpClientExtension,
RawSftpClient {
    private final String name;
    private final SftpClient client;
    private final RawSftpClient raw;
    private final boolean supported;

    protected AbstractSftpClientExtension(String name, SftpClient client, RawSftpClient raw, Collection<String> extras) {
        this(name, client, raw, GenericUtils.isNotEmpty(extras) && extras.contains(name));
    }

    protected AbstractSftpClientExtension(String name, SftpClient client, RawSftpClient raw, Map<String, byte[]> extensions) {
        this(name, client, raw, MapEntryUtils.isNotEmpty(extensions) && extensions.containsKey(name));
    }

    protected AbstractSftpClientExtension(String name, SftpClient client, RawSftpClient raw, boolean supported) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No extension name");
        this.client = Objects.requireNonNull(client, "No client instance");
        this.raw = Objects.requireNonNull(raw, "No raw access");
        this.supported = supported;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final SftpClient getClient() {
        return this.client;
    }

    protected void sendAndCheckExtendedCommandStatus(Buffer buffer) throws IOException {
        int reqId = this.sendExtendedCommand(buffer);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendAndCheckExtendedCommandStatus({}) id={}", (Object)this.getName(), (Object)reqId);
        }
        this.checkStatus(this.receive(reqId));
    }

    protected int sendExtendedCommand(Buffer buffer) throws IOException {
        return this.send(200, buffer);
    }

    @Override
    public int send(int cmd, Buffer buffer) throws IOException {
        return this.raw.send(cmd, buffer);
    }

    @Override
    public SftpMessage write(int cmd, Buffer buffer) throws IOException {
        return this.raw.write(cmd, buffer);
    }

    @Override
    public Buffer receive(int id) throws IOException {
        return this.raw.receive(id);
    }

    @Override
    public Buffer receive(int id, long timeout) throws IOException {
        return this.raw.receive(id, timeout);
    }

    @Override
    public Buffer receive(int id, Duration timeout) throws IOException {
        return this.raw.receive(id, timeout);
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    protected void checkStatus(Buffer buffer) throws IOException {
        if (this.checkExtendedReplyBuffer(buffer) != null) {
            throw new StreamCorruptedException("Unexpected extended reply received");
        }
    }

    public Buffer putTarget(Buffer buffer, Object target) {
        if (target instanceof CharSequence) {
            buffer.putString(target.toString());
        } else if (target instanceof byte[]) {
            buffer.putBytes((byte[])target);
        } else if (target instanceof SftpClient.Handle) {
            buffer.putBytes(((SftpClient.Handle)target).getIdentifier());
        } else {
            throw new UnsupportedOperationException("Unknown target type: " + target);
        }
        return buffer;
    }

    protected Buffer getCommandBuffer(Object target) {
        return this.getCommandBuffer(target, 0);
    }

    protected Buffer getCommandBuffer(Object target, int extraSize) {
        if (target instanceof CharSequence) {
            return this.getCommandBuffer(4 + ((CharSequence)target).length() + extraSize);
        }
        if (target instanceof byte[]) {
            return this.getCommandBuffer(4 + ((byte[])target).length + extraSize);
        }
        if (target instanceof SftpClient.Handle) {
            return this.getCommandBuffer(4 + ((SftpClient.Handle)target).length() + extraSize);
        }
        return this.getCommandBuffer(extraSize);
    }

    protected Buffer getCommandBuffer(int extraSize) {
        String opcode = this.getName();
        ByteArrayBuffer buffer = new ByteArrayBuffer(4 + GenericUtils.length(opcode) + extraSize + 8, false);
        buffer.putString(opcode);
        return buffer;
    }

    protected Buffer checkExtendedReplyBuffer(Buffer buffer) throws IOException {
        SftpResponse response = SftpResponse.parse(200, buffer);
        switch (response.getType()) {
            case 201: {
                return response.getBuffer();
            }
            case 101: {
                SftpStatus status = SftpStatus.parse(response);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("checkExtendedReplyBuffer({})[id={}] - status: {}", this.getName(), response.getId(), status);
                }
                if (!status.isOk()) {
                    this.throwStatusException(response.getId(), status);
                }
                return null;
            }
        }
        throw new SshException("Unexpected SFTP packet received: type=" + SftpConstants.getCommandMessageName(response.getType()) + ", id=" + response.getId() + ", length=" + response.getLength());
    }

    protected void throwStatusException(int id, SftpStatus status) throws IOException {
        throw new SftpException(status.getStatusCode(), status.getMessage());
    }
}

