/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.DHG;
import org.apache.sshd.common.kex.DHGroupData;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.kex.AbstractDHServerKeyExchange;
import org.apache.sshd.server.kex.Moduli;
import org.apache.sshd.server.session.ServerSession;

public class DHGEXServer
extends AbstractDHServerKeyExchange {
    protected final DHFactory factory;
    protected DHG dh;
    protected int min;
    protected int prf;
    protected int max;
    protected byte expected;
    protected boolean oldRequest;

    protected DHGEXServer(DHFactory factory, Session session) {
        super(session);
        this.factory = Objects.requireNonNull(factory, "No factory");
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    public static KeyExchangeFactory newFactory(final DHFactory factory) {
        return new KeyExchangeFactory(){

            @Override
            public KeyExchange createKeyExchange(Session session) throws Exception {
                return new DHGEXServer(factory, session);
            }

            @Override
            public String getName() {
                return factory.getName();
            }

            public String toString() {
                return NamedFactory.class.getSimpleName() + "<" + KeyExchange.class.getSimpleName() + ">[" + this.getName() + "]";
            }
        };
    }

    @Override
    public void init(byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        super.init(v_s, v_c, i_s, i_c);
        this.expected = (byte)34;
    }

    @Override
    public boolean next(int cmd, Buffer buffer) throws Exception {
        ServerSession session = this.getServerSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("next({})[{}] process command={} (expected={})", this, session, KeyExchange.getGroupKexOpcodeName(cmd), KeyExchange.getGroupKexOpcodeName(this.expected));
        }
        if (cmd == 30 && this.expected == 34) {
            this.oldRequest = true;
            this.min = CoreModuleProperties.PROP_DHGEX_SERVER_MIN_KEY.get(session).orElse(SecurityUtils.getMinDHGroupExchangeKeySize());
            this.prf = buffer.getInt();
            this.max = CoreModuleProperties.PROP_DHGEX_SERVER_MAX_KEY.get(session).orElse(SecurityUtils.getMaxDHGroupExchangeKeySize());
            if (this.max < this.min || this.prf < this.min || this.max < this.prf) {
                throw new SshException(3, "Protocol error: bad parameters " + this.min + " !< " + this.prf + " !< " + this.max);
            }
            this.dh = this.chooseDH(this.min, this.prf, this.max);
            this.setF(this.dh.getE());
            BigInteger pValue = this.dh.getP();
            this.validateFValue(pValue);
            this.hash = this.dh.getHash();
            this.hash.init();
            if (debugEnabled) {
                this.log.debug("next({})[{}] send (old request) SSH_MSG_KEX_DH_GEX_GROUP - min={}, prf={}, max={}", this, session, this.min, this.prf, this.max);
            }
            buffer = session.createBuffer((byte)31);
            buffer.putMPInt(pValue);
            buffer.putMPInt(this.dh.getG());
            session.writePacket(buffer);
            this.expected = (byte)32;
            return false;
        }
        if (cmd == 34 && this.expected == 34) {
            this.min = buffer.getInt();
            this.prf = buffer.getInt();
            this.max = buffer.getInt();
            if (this.prf < this.min || this.max < this.prf) {
                throw new SshException(3, "Protocol error: bad parameters " + this.min + " !< " + this.prf + " !< " + this.max);
            }
            this.dh = this.chooseDH(this.min, this.prf, this.max);
            this.setF(this.dh.getE());
            BigInteger pValue = this.dh.getP();
            this.validateFValue(pValue);
            this.hash = this.dh.getHash();
            this.hash.init();
            if (debugEnabled) {
                this.log.debug("next({})[{}] Send SSH_MSG_KEX_DH_GEX_GROUP - min={}, prf={}, max={}", this, session, this.min, this.prf, this.max);
            }
            buffer = session.createBuffer((byte)31);
            buffer.putMPInt(pValue);
            buffer.putMPInt(this.dh.getG());
            session.writePacket(buffer);
            this.expected = (byte)32;
            return false;
        }
        if (cmd != this.expected) {
            throw new SshException(3, "Protocol error: expected packet " + KeyExchange.getGroupKexOpcodeName(this.expected) + ", got " + KeyExchange.getGroupKexOpcodeName(cmd));
        }
        if (cmd == 32) {
            byte[] e = this.updateE(buffer.getMPIntAsBytes());
            BigInteger pValue = this.dh.getP();
            this.validateEValue(pValue);
            this.dh.setF(e);
            this.k = this.normalize(this.dh.getK());
            KeyPair kp = Objects.requireNonNull(session.getHostKey(), "No server key pair available");
            String algo = session.getNegotiatedKexParameter(KexProposalOption.SERVERKEYS);
            Signature sig = ValidateUtils.checkNotNull(NamedFactory.create(session.getSignatureFactories(), algo), "Unknown negotiated server keys: %s", (Object)algo);
            sig.initSigner(session, kp.getPrivate());
            buffer = new ByteArrayBuffer();
            buffer.putRawPublicKey(kp.getPublic());
            byte[] k_s = buffer.getCompactData();
            buffer.clear();
            buffer.putBytes(this.v_c);
            buffer.putBytes(this.v_s);
            buffer.putBytes(this.i_c);
            buffer.putBytes(this.i_s);
            buffer.putBytes(k_s);
            if (this.oldRequest) {
                buffer.putInt(this.prf);
            } else {
                buffer.putInt(this.min);
                buffer.putInt(this.prf);
                buffer.putInt(this.max);
            }
            buffer.putMPInt(pValue);
            buffer.putMPInt(this.dh.getG());
            buffer.putMPInt(e);
            byte[] f = this.getF();
            buffer.putMPInt(f);
            buffer.putBytes(this.k);
            this.hash.update(buffer.array(), 0, buffer.available());
            this.h = this.hash.digest();
            sig.update(session, this.h);
            buffer.clear();
            buffer.putString(algo);
            byte[] sigBytes = sig.sign(session);
            buffer.putBytes(sigBytes);
            byte[] sigH = buffer.getCompactData();
            if (this.log.isTraceEnabled()) {
                this.log.trace("next({})[{}][K_S]:  {}", this, session, BufferUtils.toHex(k_s));
                this.log.trace("next({})[{}][f]:    {}", this, session, BufferUtils.toHex(f));
                this.log.trace("next({})[{}][sigH]: {}", this, session, BufferUtils.toHex(sigH));
            }
            if (debugEnabled) {
                this.log.debug("next({})[{}] Send SSH_MSG_KEX_DH_GEX_REPLY - old={}, min={}, prf={}, max={}", this, session, this.oldRequest, this.min, this.prf, this.max);
            }
            buffer = session.prepareBuffer((byte)33, BufferUtils.clear(buffer));
            buffer.putBytes(k_s);
            buffer.putBytes(f);
            buffer.putBytes(sigH);
            session.writePacket(buffer);
            return true;
        }
        return false;
    }

    protected DHG chooseDH(int min, int prf, int max) throws Exception {
        List<Moduli.DhGroup> groups;
        ServerSession session = this.getServerSession();
        List<Moduli.DhGroup> selected = this.selectModuliGroups(session, min, prf, max, groups = this.loadModuliGroups(session));
        if (GenericUtils.isEmpty(selected)) {
            if (!CoreModuleProperties.ALLOW_DHG1_KEX_FALLBACK.getRequired(session).booleanValue()) {
                this.log.error("chooseDH({})[{}][prf={}, min={}, max={}] No suitable primes found - failing", this, session, prf, min, max);
                throw new SshException(3, "No suitable primes found for DH group exchange");
            }
            this.log.warn("chooseDH({})[{}][prf={}, min={}, max={}] No suitable primes found - defaulting to DHG1", this, session, prf, min, max);
            return this.getDH(new BigInteger(DHGroupData.getP1()), new BigInteger(DHGroupData.getG()));
        }
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        Factory<? extends Random> factory = Objects.requireNonNull(manager.getRandomFactory(), "No random factory");
        Random random = Objects.requireNonNull(factory.create(), "No random generator");
        int which = random.random(selected.size());
        Moduli.DhGroup group = selected.get(which);
        if (this.log.isTraceEnabled()) {
            this.log.trace("chooseDH({})[{}][prf={}, min={}, max={}] selected {}", this, session, prf, min, max, group);
        }
        return this.getDH(group.getP(), group.getG());
    }

    protected List<Moduli.DhGroup> selectModuliGroups(ServerSession session, int min, int prf, int max, List<Moduli.DhGroup> groups) throws Exception {
        int maxDHGroupExchangeKeySize = SecurityUtils.getMaxDHGroupExchangeKeySize();
        int minDHGroupExchangeKeySize = SecurityUtils.getMinDHGroupExchangeKeySize();
        min = Math.max(min, minDHGroupExchangeKeySize);
        prf = Math.max(prf, minDHGroupExchangeKeySize);
        prf = Math.min(prf, maxDHGroupExchangeKeySize);
        max = Math.min(max, maxDHGroupExchangeKeySize);
        ArrayList<Moduli.DhGroup> selected = new ArrayList<Moduli.DhGroup>();
        int bestSize = 0;
        boolean traceEnabled = this.log.isTraceEnabled();
        for (Moduli.DhGroup group : groups) {
            int size = group.getSize();
            if (size < min || size > max) {
                if (!traceEnabled) continue;
                this.log.trace("selectModuliGroups({})[{}] - skip group={} - size not in range [{}-{}]", this, session, group, min, max);
                continue;
            }
            if (size > prf && size < bestSize || size > bestSize && bestSize < prf) {
                bestSize = size;
                if (traceEnabled) {
                    this.log.trace("selectModuliGroups({})[{}][prf={}, min={}, max={}] new best size={} from group={}", this, session, prf, min, max, bestSize, group);
                }
                selected.clear();
            }
            if (size != bestSize) continue;
            if (traceEnabled) {
                this.log.trace("selectModuliGroups({})[{}][prf={}, min={}, max={}] selected {}", this, session, prf, min, max, group);
            }
            selected.add(group);
        }
        return selected;
    }

    protected List<Moduli.DhGroup> loadModuliGroups(ServerSession session) throws IOException {
        URL moduli;
        String moduliStr = CoreModuleProperties.MODULI_URL.getOrNull(session);
        List<Moduli.DhGroup> groups = null;
        if (!GenericUtils.isEmpty(moduliStr)) {
            try {
                moduli = new URL(moduliStr);
                groups = Moduli.parseModuli(moduli);
            }
            catch (IOException e) {
                this.log.warn("loadModuliGroups({})[{}] Error ({}) loading external moduli from {}: {}", this, session, e.getClass().getSimpleName(), moduliStr, e.getMessage());
            }
        }
        if (groups == null) {
            moduliStr = "/org/apache/sshd/moduli";
            try {
                moduli = this.getClass().getResource(moduliStr);
                if (moduli == null) {
                    throw new FileNotFoundException("Missing internal moduli file");
                }
                moduliStr = moduli.toExternalForm();
                groups = Moduli.loadInternalModuli(moduli);
            }
            catch (IOException e) {
                this.log.warn("loadModuliGroups({})[{}] Error ({}) loading internal moduli from {}: {}", this, session, e.getClass().getSimpleName(), moduliStr, e.getMessage());
                throw e;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("loadModuliGroups({})[{}] Loaded {} moduli groups from {}", this, session, GenericUtils.size(groups), moduliStr);
        }
        return groups;
    }

    protected DHG getDH(BigInteger p, BigInteger g) throws Exception {
        return (DHG)this.factory.create(p, g);
    }
}

