/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.security.PrivilegedOperations;

public class SshdThreadFactory
extends AbstractLoggingBean
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public SshdThreadFactory(String name) {
        ThreadGroup sg = PrivilegedOperations.getPrivilegedThreadGroup();
        this.group = sg != null ? sg : Thread.currentThread().getThreadGroup();
        String effectiveName = name.replace(' ', '-');
        this.namePrefix = "sshd-" + effectiveName + "-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t;
        try {
            t = PrivilegedOperations.doPrivilegedConditional(() -> new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L));
        }
        catch (PrivilegedOperations.PrivilegeException e) {
            Throwable err = e.getCause();
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            throw new IllegalStateException(err);
        }
        if (!t.isDaemon()) {
            t.setDaemon(true);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("newThread({})[{}] runnable={}", this.group, t.getName(), r);
        }
        return t;
    }
}

