/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.generic;

import java.security.Key;

public final class EdDSAKeyTypeDetector {
    private EdDSAKeyTypeDetector() {
        throw new IllegalStateException("No instantiation");
    }

    public static boolean isEd25519(Key key) {
        if (key == null) {
            return false;
        }
        String algorithm = key.getAlgorithm();
        if ("Ed25519".equalsIgnoreCase(algorithm)) {
            return true;
        }
        return "EdDSA".equalsIgnoreCase(algorithm) && key.getClass().getCanonicalName().startsWith("net.i2p.");
    }
}

