/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityEntityFactory;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.EdDSAAccessor;
import org.apache.sshd.common.util.security.eddsa.EdDSAPublicKeyFactory;

public class EdDSASecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    public static final String PROVIDER_CLASS = "net.i2p.crypto.eddsa.EdDSASecurityProvider";
    private final AtomicReference<Boolean> supportHolder = new AtomicReference<Object>(null);
    private boolean useName = true;

    public EdDSASecurityProviderRegistrar() {
        super("EdDSA");
    }

    @Override
    public boolean isEnabled() {
        return !SecurityUtils.isFipsMode() && super.isEnabled();
    }

    @Override
    public boolean isNamedProviderUsed() {
        return this.useName;
    }

    @Override
    public Provider getSecurityProvider() {
        try {
            return this.getOrCreateProvider(PROVIDER_CLASS);
        }
        catch (ReflectiveOperationException t) {
            Throwable e = ExceptionUtils.peelException(t);
            this.log.error("getSecurityProvider({}) failed ({}) to instantiate {}: {}", this.getName(), e.getClass().getSimpleName(), PROVIDER_CLASS, e.getMessage());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isSecurityEntitySupported(Class<?> entityType, String name) {
        if (!this.isSupported()) {
            return false;
        }
        if (KeyPairGenerator.class.isAssignableFrom(entityType) || KeyFactory.class.isAssignableFrom(entityType)) {
            return "Ed25519".equalsIgnoreCase(name);
        }
        if (Signature.class.isAssignableFrom(entityType)) {
            return "Ed25519".equalsIgnoreCase(name);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported() {
        Boolean supported;
        AtomicReference<Boolean> atomicReference = this.supportHolder;
        synchronized (atomicReference) {
            supported = this.supportHolder.get();
            if (supported != null) {
                return supported;
            }
            supported = EdDSAAccessor.INSTANCE.isSupported();
            if (supported.booleanValue()) {
                Provider provider = Security.getProvider(this.getProviderName());
                this.useName = provider != null;
            }
            this.supportHolder.set(supported);
        }
        return supported;
    }

    @Override
    protected Provider createProviderInstance(String providerClassName) throws ReflectiveOperationException {
        ValidateUtils.checkTrue(PROVIDER_CLASS.equals(providerClassName), "Unexpected class name %s", (Object)providerClassName);
        Provider result = EdDSAAccessor.INSTANCE.createProvider();
        if (result == null) {
            throw new ReflectiveOperationException("Cannot instantiate net.i2p.crypto.eddsa.EdDSASecurityProvider");
        }
        return result;
    }

    @Override
    public SecurityEntityFactory getFactory() {
        return new DelegatingSecurityEntityFactory(super.getFactory());
    }

    @Override
    public PublicKey getPublicKey(PrivateKey key) {
        if (this.isEnabled() && this.isSupported() && "EdDSA".equals(key.getAlgorithm()) && key.getClass().getPackage().getName().startsWith("net.i2p.")) {
            return EdDSAPublicKeyFactory.INSTANCE.getPublicKey(key);
        }
        return super.getPublicKey(key);
    }

    private static class DelegatingSecurityEntityFactory
    implements SecurityEntityFactory {
        private SecurityEntityFactory delegate;

        DelegatingSecurityEntityFactory(SecurityEntityFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public KeyFactory createKeyFactory(String algorithm) throws GeneralSecurityException {
            String effective = algorithm;
            if ("Ed25519".equalsIgnoreCase(effective)) {
                effective = "EdDSA";
            }
            return this.delegate.createKeyFactory(effective);
        }

        @Override
        public KeyPairGenerator createKeyPairGenerator(String algorithm) throws GeneralSecurityException {
            String effective = algorithm;
            if ("Ed25519".equalsIgnoreCase(effective)) {
                effective = "EdDSA";
            }
            return this.delegate.createKeyPairGenerator(effective);
        }

        @Override
        public Signature createSignature(String algorithm) throws GeneralSecurityException {
            String effective = algorithm;
            if ("Ed25519".equalsIgnoreCase(effective)) {
                effective = "NONEwithEdDSA";
            }
            return this.delegate.createSignature(effective);
        }
    }
}

