/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.compression.CompressionInformation;
import org.apache.sshd.common.filter.BufferInputHandler;
import org.apache.sshd.common.filter.DefaultFilterChain;
import org.apache.sshd.common.filter.FilterChain;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.IoFilter;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.GlobalRequestFuture;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.filters.SshIdentHandler;
import org.apache.sshd.common.session.filters.SshTransportFilter;
import org.apache.sshd.common.session.filters.kex.KexListener;
import org.apache.sshd.common.session.helpers.CurrentService;
import org.apache.sshd.common.session.helpers.MissingAttachedSessionException;
import org.apache.sshd.common.session.helpers.MultipleAttachedSessionException;
import org.apache.sshd.common.session.helpers.PacketBuffer;
import org.apache.sshd.common.session.helpers.PendingWriteFuture;
import org.apache.sshd.common.session.helpers.SessionHelper;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class AbstractSession
extends SessionHelper {
    public static final String SESSION = "org.apache.sshd.session";
    protected final Random random;
    protected final Collection<SessionListener> sessionListeners = new CopyOnWriteArraySet<SessionListener>();
    protected final SessionListener sessionListenerProxy;
    protected final Collection<ChannelListener> channelListeners = new CopyOnWriteArraySet<ChannelListener>();
    protected final ChannelListener channelListenerProxy;
    protected final Collection<PortForwardingEventListener> tunnelListeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    protected final PortForwardingEventListener tunnelListenerProxy;
    protected final CurrentService currentService;
    protected String serverVersion;
    protected String clientVersion;
    private final FilterChain filters = new DefaultFilterChain();
    private SshTransportFilter sshTransport;

    protected AbstractSession(boolean serverSession, FactoryManager factoryManager, IoSession ioSession) {
        super(serverSession, factoryManager, ioSession);
        this.currentService = Objects.requireNonNull(this.initializeCurrentService(), "No CurrentService set on the session");
        AbstractSession.attachSession(ioSession, this);
        Factory<? extends Random> factory = ValidateUtils.checkNotNull(factoryManager.getRandomFactory(), "No random factory for %s", (Object)ioSession);
        this.random = ValidateUtils.checkNotNull(factory.create(), "No randomizer instance for %s", (Object)ioSession);
        this.sessionListenerProxy = EventListenerUtils.proxyWrapper(SessionListener.class, this.sessionListeners);
        this.channelListenerProxy = EventListenerUtils.proxyWrapper(ChannelListener.class, this.channelListeners);
        this.tunnelListenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.tunnelListeners);
    }

    protected void start() throws Exception {
        if (this.filters.isEmpty()) {
            this.setupFilterChain();
        }
        this.signalSessionStarting();
        IoFilter ioSessionConnector = new IoFilter(){

            @Override
            public InputHandler in() {
                return this.owner()::passOn;
            }

            @Override
            public OutputHandler out() {
                return (cmd, message) -> AbstractSession.this.getIoSession().writeBuffer(message);
            }
        };
        this.filters.addFirst(ioSessionConnector);
        IoFilter sessionConnector = new IoFilter(){

            @Override
            public InputHandler in() {
                return new BufferInputHandler(){

                    @Override
                    public void handleMessage(Buffer message) throws Exception {
                        AbstractSession.this.handleMessage(message);
                    }
                };
            }

            @Override
            public OutputHandler out() {
                return this.owner()::send;
            }
        };
        this.filters.addLast(sessionConnector);
    }

    protected void setupFilterChain() {
        SshIdentHandler identities = new SshIdentHandler(){

            @Override
            public boolean isServer() {
                return AbstractSession.this.isServerSession();
            }

            @Override
            public List<String> readIdentification(Buffer buffer) {
                try {
                    boolean haveIdent = AbstractSession.this.readIdentification(buffer);
                    if (!haveIdent) {
                        return null;
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
                return Collections.singletonList(this.isServer() ? AbstractSession.this.clientVersion : AbstractSession.this.serverVersion);
            }

            @Override
            public List<String> provideIdentification() {
                ArrayList<String> lines;
                if (!this.isServer()) {
                    AbstractSession.this.clientVersion = AbstractSession.this.resolveIdentificationString(CoreModuleProperties.CLIENT_IDENTIFICATION.getName());
                    try {
                        AbstractSession.this.signalSendIdentification(AbstractSession.this.clientVersion, Collections.emptyList());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                    lines = Collections.singletonList(AbstractSession.this.clientVersion);
                } else {
                    String headerConfig = CoreModuleProperties.SERVER_EXTRA_IDENTIFICATION_LINES.getOrNull(AbstractSession.this);
                    String[] headers = GenericUtils.split(headerConfig, '|');
                    lines = GenericUtils.isEmpty(headers) ? new ArrayList() : new ArrayList<String>(Arrays.asList(headers));
                    AbstractSession.this.serverVersion = AbstractSession.this.resolveIdentificationString(CoreModuleProperties.SERVER_IDENTIFICATION.getName());
                    try {
                        AbstractSession.this.signalSendIdentification(AbstractSession.this.serverVersion, lines);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                    lines.add(AbstractSession.this.serverVersion);
                }
                return lines;
            }
        };
        SessionListener sessionEvents = new SessionListener(){

            @Override
            public void sessionNegotiationStart(Session session, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal) {
                AbstractSession.this.signalNegotiationStart(clientProposal, serverProposal);
            }

            @Override
            public void sessionNegotiationEnd(Session session, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal, Map<KexProposalOption, String> negotiatedOptions, Throwable reason) {
                AbstractSession.this.signalNegotiationEnd(clientProposal, serverProposal, negotiatedOptions, reason);
            }

            @Override
            public void sessionEvent(Session session, SessionListener.Event event) {
                try {
                    AbstractSession.this.signalSessionEvent(event);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeSshException(e.getMessage(), e);
                }
            }
        };
        this.sshTransport = new SshTransportFilter(this, this.random, identities, sessionEvents, this::getKexProposal, this::checkKeys);
        this.filters.addLast(this.sshTransport);
    }

    @Override
    public FilterChain getFilterChain() {
        return this.filters;
    }

    protected SshTransportFilter getTransport() {
        return this.sshTransport;
    }

    protected boolean isConnectionSecure() {
        return this.sshTransport.isSecure();
    }

    public void addKexListener(KexListener listener) {
        this.sshTransport.addKexListener(listener);
    }

    public void removeKexListener(KexListener listener) {
        this.sshTransport.addKexListener(listener);
    }

    protected void initializeKeyExchangePhase() throws Exception {
        KeyExchangeFuture future = this.sshTransport.startKex();
        Throwable t = future.getException();
        if (t != null) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new SshException("Could not start initial KEX", t);
        }
    }

    protected boolean isStrictKex() {
        return this.sshTransport.isStrictKex();
    }

    protected CurrentService initializeCurrentService() {
        return new CurrentService(this);
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public Map<KexProposalOption, String> getServerKexProposals() {
        return this.sshTransport.getServerProposal();
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public Map<KexProposalOption, String> getClientKexProposals() {
        return this.sshTransport.getClientProposal();
    }

    @Override
    public KexState getKexState() {
        return this.sshTransport.getKexState().get();
    }

    @Override
    public byte[] getSessionId() {
        return this.sshTransport.getSessionId();
    }

    @Override
    public Map<KexProposalOption, String> getKexNegotiationResult() {
        return this.sshTransport.getNegotiated();
    }

    @Override
    public String getNegotiatedKexParameter(KexProposalOption paramType) {
        return this.sshTransport.getNegotiated().get((Object)paramType);
    }

    @Override
    public CipherInformation getCipherInformation(boolean incoming) {
        return this.sshTransport.getCipherInformation(incoming);
    }

    @Override
    public CompressionInformation getCompressionInformation(boolean incoming) {
        return this.sshTransport.getCompressionInformation(incoming);
    }

    @Override
    public MacInformation getMacInformation(boolean incoming) {
        return this.sshTransport.getMacInformation(incoming);
    }

    protected void handleMessage(Buffer buffer) throws Exception {
        int cmd = buffer.getUByte();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doHandleMessage({}) process #{} {}", this, this.sshTransport.getLastInputSequenceNumber(), SshConstants.getCommandMessageName(cmd));
        }
        switch (cmd) {
            case 1: {
                this.handleDisconnect(buffer);
                break;
            }
            case 2: {
                this.handleIgnore(buffer);
                break;
            }
            case 3: {
                this.handleUnimplemented(buffer);
                break;
            }
            case 4: {
                this.handleDebug(buffer);
                break;
            }
            case 5: {
                this.handleServiceRequest(buffer);
                break;
            }
            case 6: {
                this.handleServiceAccept(buffer);
                break;
            }
            case 7: {
                this.handleKexExtension(cmd, buffer);
                break;
            }
            case 8: {
                this.handleNewCompression(cmd, buffer);
                break;
            }
            default: {
                if (this.currentService.process(cmd, buffer)) {
                    this.resetIdleTimeout();
                    break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Unsupported command: {}", (Object)this, (Object)SshConstants.getCommandMessageName(cmd));
                }
                this.notImplemented(cmd, buffer);
            }
        }
    }

    protected void handleKexExtension(int cmd, Buffer buffer) throws Exception {
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        int startPos = buffer.rpos();
        if (extHandler != null && extHandler.handleKexExtensionsMessage(this, buffer)) {
            return;
        }
        buffer.rpos(startPos);
        this.notImplemented(cmd, buffer);
    }

    protected void handleNewCompression(int cmd, Buffer buffer) throws Exception {
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        int startPos = buffer.rpos();
        if (extHandler != null && extHandler.handleKexCompressionMessage(this, buffer)) {
            return;
        }
        buffer.rpos(startPos);
        this.notImplemented(cmd, buffer);
    }

    protected void handleServiceRequest(Buffer buffer) throws Exception {
        String serviceName = buffer.getString();
        this.handleServiceRequest(serviceName, buffer);
    }

    protected boolean handleServiceRequest(String serviceName, Buffer buffer) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleServiceRequest({}) SSH_MSG_SERVICE_REQUEST '{}'", (Object)this, (Object)serviceName);
        }
        try {
            this.startService(serviceName, buffer);
        }
        catch (Throwable e) {
            this.debug("handleServiceRequest({}) Service {} rejected: {} = {}", this, serviceName, e.getClass().getSimpleName(), e.getMessage(), e);
            this.disconnect(7, "Bad service request: " + serviceName);
            return false;
        }
        if (debugEnabled) {
            this.log.debug("handleServiceRequest({}) Accepted service {}", (Object)this, (Object)serviceName);
        }
        Buffer response = this.createBuffer((byte)6, 8 + GenericUtils.length(serviceName));
        response.putString(serviceName);
        this.writePacket(response);
        return true;
    }

    protected void handleServiceAccept(Buffer buffer) throws Exception {
        this.handleServiceAccept(buffer.getString(), buffer);
    }

    protected void handleServiceAccept(String serviceName, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServiceAccept({}) SSH_MSG_SERVICE_ACCEPT service={}", (Object)this, (Object)serviceName);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        Closeable closer = this.builder().parallel(this.toString(), this.getServices()).close(this.getIoSession()).build();
        closer.addCloseFutureListener(future -> this.clearAttributes());
        return closer;
    }

    @Override
    protected void preClose() {
        if (this.sshTransport != null) {
            this.sshTransport.shutdown();
        }
        try {
            this.signalSessionClosed();
        }
        finally {
            this.sessionListeners.clear();
            this.channelListeners.clear();
            this.tunnelListeners.clear();
        }
        super.preClose();
    }

    protected List<Service> getServices() {
        Service service = this.currentService.getService();
        return service != null ? Collections.singletonList(service) : Collections.emptyList();
    }

    @Override
    public <T extends Service> T getService(Class<T> clazz) {
        List<Service> registeredServices = this.getServices();
        ValidateUtils.checkState(GenericUtils.isNotEmpty(registeredServices), "No registered services to look for %s", (Object)clazz.getSimpleName());
        for (Service s : registeredServices) {
            if (!clazz.isInstance(s)) continue;
            return (T)((Service)clazz.cast(s));
        }
        throw new IllegalStateException("Attempted to access unknown service " + clazz.getSimpleName());
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        int cmd = buffer.rawByte(buffer.rpos()) & 0xFF;
        return this.filters.getLast().out().send(cmd, buffer);
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        IoWriteFuture writeFuture;
        long timeoutMillis = unit.toMillis(timeout);
        try {
            long start = System.currentTimeMillis();
            writeFuture = this.writePacket(buffer);
            long elapsed = System.currentTimeMillis() - start;
            timeoutMillis = elapsed >= timeoutMillis ? 1L : (timeoutMillis -= elapsed);
        }
        catch (InterruptedIOException e) {
            PendingWriteFuture timedOut = new PendingWriteFuture((Object)this, buffer);
            TimeoutException t = new TimeoutException("Timeout writing packet: " + timeout + " " + (Object)((Object)unit));
            t.initCause(e);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writePacket({}): {}", (Object)this, (Object)t.getMessage());
            }
            timedOut.setValue(t);
            return timedOut;
        }
        if (writeFuture.isDone()) {
            return writeFuture;
        }
        DefaultSshFuture future = (DefaultSshFuture)((Object)writeFuture);
        FactoryManager factoryManager = this.getFactoryManager();
        ScheduledExecutorService executor = factoryManager.getScheduledExecutorService();
        ScheduledFuture<?> sched = executor.schedule(() -> {
            TimeoutException t = new TimeoutException("Timeout writing packet: " + timeout + " " + (Object)((Object)unit));
            if (this.log.isDebugEnabled()) {
                this.log.debug("writePacket({}): {}", (Object)this, (Object)t.getMessage());
            }
            future.setValue(t);
        }, timeoutMillis, TimeUnit.MILLISECONDS);
        future.addListener(f -> sched.cancel(false));
        return writeFuture;
    }

    @Override
    public Buffer request(String request, Buffer buffer, long maxWaitMillis) throws IOException {
        ConnectionService service = this.getCurrentService(ConnectionService.class);
        ValidateUtils.checkNotNull(service, "Current service is not a ConnectionService");
        return service.request(request, buffer, maxWaitMillis);
    }

    @Override
    public GlobalRequestFuture request(Buffer buffer, String request, GlobalRequestFuture.ReplyHandler replyHandler) throws IOException {
        ConnectionService service = this.getCurrentService(ConnectionService.class);
        ValidateUtils.checkNotNull(service, "Current service is not a ConnectionService");
        return service.request(buffer, request, replyHandler);
    }

    @Override
    protected boolean doInvokeUnimplementedMessageHandler(int cmd, Buffer buffer) throws Exception {
        ReservedSessionMessagesHandler service = this.getCurrentService(ReservedSessionMessagesHandler.class);
        if (service != null && service.handleUnimplementedMessage(this, cmd, buffer)) {
            return true;
        }
        return super.doInvokeUnimplementedMessageHandler(cmd, buffer);
    }

    @Override
    public Buffer createBuffer(byte cmd, int len) {
        if (len <= 0) {
            return this.prepareBuffer(cmd, new PacketBuffer());
        }
        int finalLength = len + 5 + 127 + 64;
        return this.prepareBuffer(cmd, new PacketBuffer(new byte[finalLength], false));
    }

    @Override
    public Buffer prepareBuffer(byte cmd, Buffer buffer) {
        buffer = this.validateTargetBuffer(cmd & 0xFF, buffer);
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte(cmd);
        return buffer;
    }

    protected <B extends Buffer> B validateTargetBuffer(int cmd, B buffer) {
        ValidateUtils.checkNotNull(buffer, "No target buffer to examine for command=%d", cmd);
        return buffer;
    }

    protected abstract boolean readIdentification(Buffer var1) throws Exception;

    protected IoWriteFuture notImplemented(int cmd, Buffer buffer) throws Exception {
        if (this.doInvokeUnimplementedMessageHandler(cmd, buffer)) {
            return null;
        }
        return this.sendNotImplemented(this.sshTransport.getLastInputSequenceNumber());
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        SessionListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addSessionListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.sessionListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addSessionListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addSessionListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeSessionListener(SessionListener listener) {
        if (listener == null) {
            return;
        }
        SessionListener.validateListener(listener);
        if (this.sessionListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeSessionListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeSessionListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public SessionListener getSessionListenerProxy() {
        return this.sessionListenerProxy;
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        ChannelListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.channelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        ChannelListener.validateListener(listener);
        if (this.channelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.tunnelListenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        PortForwardingEventListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addPortForwardingEventListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.tunnelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addPortForwardingEventListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addPortForwardingEventListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        PortForwardingEventListener.validateListener(listener);
        if (this.tunnelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removePortForwardingEventListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removePortForwardingEventListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public KeyExchangeFuture reExchangeKeys() throws IOException {
        try {
            return this.sshTransport.startKex();
        }
        catch (GeneralSecurityException e) {
            this.debug("reExchangeKeys({}) failed ({}) to request new keys: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            throw ValidateUtils.initializeExceptionCause(new ProtocolException("Failed (" + e.getClass().getSimpleName() + ") to generate keys for exchange: " + e.getMessage()), e);
        }
        catch (Exception e) {
            ExceptionUtils.rethrowAsIoException(e);
            return null;
        }
    }

    @Override
    protected String resolveSessionKexProposal(String hostKeyTypes) throws IOException {
        String extType;
        String proposal = super.resolveSessionKexProposal(hostKeyTypes);
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        if (extHandler == null || !extHandler.isKexExtensionsAvailable(this, KexExtensionHandler.AvailabilityPhase.PROPOSAL)) {
            return proposal;
        }
        String string = extType = this.isServerSession() ? "ext-info-s" : "ext-info-c";
        if (GenericUtils.isEmpty(proposal)) {
            return extType;
        }
        return proposal + "," + extType;
    }

    protected <T> T getCurrentService(Class<? extends T> type) {
        Service service = this.currentService.getService();
        if (type.isInstance(service)) {
            return type.cast(service);
        }
        return null;
    }

    protected abstract void checkKeys() throws IOException;

    public static AbstractSession getSession(IoSession ioSession) throws MissingAttachedSessionException {
        return AbstractSession.getSession(ioSession, false);
    }

    public static void attachSession(IoSession ioSession, AbstractSession session) throws MultipleAttachedSessionException {
        Objects.requireNonNull(ioSession, "No I/O session");
        Objects.requireNonNull(session, "No SSH session");
        Object prev = ioSession.setAttributeIfAbsent(SESSION, session);
        if (prev != null) {
            throw new MultipleAttachedSessionException("Multiple attached session to " + ioSession + ": " + prev + " and " + session);
        }
    }

    public static AbstractSession getSession(IoSession ioSession, boolean allowNull) throws MissingAttachedSessionException {
        AbstractSession session = (AbstractSession)ioSession.getAttribute(SESSION);
        if (session == null && !allowNull) {
            throw new MissingAttachedSessionException("No session attached to " + ioSession);
        }
        return session;
    }
}

