/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.proxy.ProxyData;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionCreator;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.client.session.filter.ClientProxyFilter;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.helpers.AbstractConnectionService;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class AbstractClientSession
extends AbstractSession
implements ClientSession {
    public static final AttributeRepository.AttributeKey<HostConfigEntry> HOST_CONFIG_ENTRY = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<ProxyData> PROXY_DATA = new AttributeRepository.AttributeKey();
    protected final boolean sendImmediateClientIdentification;
    protected final boolean sendImmediateKexInit;
    private final Set<String> sessionHostKeys = ConcurrentHashMap.newKeySet();
    private final List<Object> identities = new CopyOnWriteArrayList<Object>();
    private final AuthenticationIdentitiesProvider identitiesProvider;
    private final AttributeRepository connectionContext;
    private final HostConfigEntry hostConfig;
    private PublicKey serverKey;
    private ServerKeyVerifier serverKeyVerifier;
    private UserInteraction userInteraction;
    private PasswordIdentityProvider passwordIdentityProvider;
    private PasswordAuthenticationReporter passwordAuthenticationReporter;
    private KeyIdentityProvider keyIdentityProvider;
    private PublicKeyAuthenticationReporter publicKeyAuthenticationReporter;
    private HostBasedAuthenticationReporter hostBasedAuthenticationReporter;
    private List<UserAuthFactory> userAuthFactories;
    private SocketAddress connectAddress;
    private volatile boolean useNoneCipher;

    protected AbstractClientSession(ClientFactoryManager factoryManager, IoSession ioSession) {
        super(false, factoryManager, ioSession);
        this.sendImmediateClientIdentification = CoreModuleProperties.SEND_IMMEDIATE_IDENTIFICATION.getRequired(this);
        this.sendImmediateKexInit = CoreModuleProperties.SEND_IMMEDIATE_KEXINIT.getRequired(this);
        this.identitiesProvider = AuthenticationIdentitiesProvider.wrapIdentities(this.identities);
        this.connectionContext = (AttributeRepository)ioSession.getAttribute(AttributeRepository.class);
        this.hostConfig = this.connectionContext.getAttribute(HOST_CONFIG_ENTRY);
    }

    @Override
    protected void setupFilterChain() {
        super.setupFilterChain();
        ProxyData proxy = this.connectionContext.getAttribute(PROXY_DATA);
        SshdSocketAddress targetAddress = this.connectionContext.getAttribute(ClientSessionCreator.TARGET_SERVER);
        if (proxy != null) {
            if (targetAddress == null) {
                throw new IllegalStateException("Have proxy but no target address");
            }
            this.getFilterChain().addFirst(new ClientProxyFilter(this, proxy, targetAddress.toInetSocketAddress()));
            this.setAttribute(ClientSessionCreator.TARGET_SERVER, targetAddress);
        }
    }

    @Override
    public HostConfigEntry getHostConfigEntry() {
        return this.hostConfig;
    }

    @Override
    public AttributeRepository getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public ClientFactoryManager getFactoryManager() {
        return (ClientFactoryManager)super.getFactoryManager();
    }

    @Override
    public SocketAddress getConnectAddress() {
        return this.resolvePeerAddress(this.connectAddress);
    }

    public void setConnectAddress(SocketAddress connectAddress) {
        this.connectAddress = connectAddress;
    }

    @Override
    public PublicKey getServerKey() {
        return this.serverKey;
    }

    public void setServerKey(PublicKey serverKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setServerKey({}) keyType={}, digest={}", this, KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey));
        }
        this.serverKey = serverKey;
    }

    @Override
    public void registerHostKey(PublicKey hostKey) {
        if (hostKey instanceof OpenSshCertificate) {
            OpenSshCertificate cert = (OpenSshCertificate)hostKey;
            ValidateUtils.checkTrue(OpenSshCertificate.Type.HOST.equals((Object)cert.getType()), "Invalid certificate type");
            this.sessionHostKeys.add("@cert-authority " + PublicKeyEntry.toString(cert.getCaPubKey()));
        } else {
            ValidateUtils.checkNotNull(hostKey, "Null host key cannot be registered");
            this.sessionHostKeys.add(PublicKeyEntry.toString(hostKey));
        }
    }

    @Override
    public Collection<String> getRegisteredHostKeys() {
        return Collections.unmodifiableSet(this.sessionHostKeys);
    }

    @Override
    protected void checkKeys() throws IOException {
        PublicKey hostKey = Objects.requireNonNull(this.getServerKey(), "No server key to verify");
        String serializedKey = hostKey instanceof OpenSshCertificate ? "@cert-authority " + PublicKeyEntry.toString(((OpenSshCertificate)hostKey).getCaPubKey()) : PublicKeyEntry.toString(hostKey);
        if (!this.sessionHostKeys.contains(serializedKey)) {
            ServerKeyVerifier verifier = Objects.requireNonNull(this.getServerKeyVerifier(), "No server key verifier");
            IoSession networkSession = this.getIoSession();
            SocketAddress remoteAddress = networkSession.getRemoteAddress();
            SshdSocketAddress targetServerAddress = this.getAttribute(ClientSessionCreator.TARGET_SERVER);
            if (targetServerAddress != null) {
                remoteAddress = targetServerAddress.toInetSocketAddress();
            }
            boolean verified = verifier.verifyServerKey(this, remoteAddress, hostKey);
            if (this.log.isDebugEnabled()) {
                this.log.debug("checkKeys({}) key={}-{}, verified={}", this, KeyUtils.getKeyType(hostKey), KeyUtils.getFingerPrint(hostKey), verified);
            }
            if (!verified) {
                throw new SshException(9, "Server key did not validate");
            }
            this.sessionHostKeys.add(serializedKey);
        }
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(ServerKeyVerifier.class, this.serverKeyVerifier, manager.getServerKeyVerifier());
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = serverKeyVerifier;
    }

    @Override
    public UserInteraction getUserInteraction() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(UserInteraction.class, this.userInteraction, manager.getUserInteraction());
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public PasswordAuthenticationReporter getPasswordAuthenticationReporter() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(PasswordAuthenticationReporter.class, this.passwordAuthenticationReporter, manager.getPasswordAuthenticationReporter());
    }

    @Override
    public void setPasswordAuthenticationReporter(PasswordAuthenticationReporter reporter) {
        this.passwordAuthenticationReporter = reporter;
    }

    @Override
    public List<UserAuthFactory> getUserAuthFactories() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveFactories(this.userAuthFactories, manager.getUserAuthFactories());
    }

    @Override
    public void setUserAuthFactories(List<UserAuthFactory> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(PasswordIdentityProvider.class, this.passwordIdentityProvider, manager.getPasswordIdentityProvider());
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider provider) {
        this.passwordIdentityProvider = provider;
    }

    @Override
    public KeyIdentityProvider getKeyIdentityProvider() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(KeyIdentityProvider.class, this.keyIdentityProvider, manager.getKeyIdentityProvider());
    }

    @Override
    public void setKeyIdentityProvider(KeyIdentityProvider keyIdentityProvider) {
        this.keyIdentityProvider = keyIdentityProvider;
    }

    @Override
    public PublicKeyAuthenticationReporter getPublicKeyAuthenticationReporter() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(PublicKeyAuthenticationReporter.class, this.publicKeyAuthenticationReporter, manager.getPublicKeyAuthenticationReporter());
    }

    @Override
    public void setPublicKeyAuthenticationReporter(PublicKeyAuthenticationReporter reporter) {
        this.publicKeyAuthenticationReporter = reporter;
    }

    @Override
    public HostBasedAuthenticationReporter getHostBasedAuthenticationReporter() {
        ClientFactoryManager manager = this.getFactoryManager();
        return this.resolveEffectiveProvider(HostBasedAuthenticationReporter.class, this.hostBasedAuthenticationReporter, manager.getHostBasedAuthenticationReporter());
    }

    @Override
    public void setHostBasedAuthenticationReporter(HostBasedAuthenticationReporter reporter) {
        this.hostBasedAuthenticationReporter = reporter;
    }

    @Override
    public void addPasswordIdentity(String password) {
        ValidateUtils.checkTrue(password != null && !password.isEmpty(), "No password provided");
        this.identities.add(password);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(password));
        }
    }

    @Override
    public String removePasswordIdentity(String password) {
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.PASSWORD_IDENTITY_COMPARATOR, password);
        if (index >= 0) {
            return (String)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair kp) {
        Objects.requireNonNull(kp, "No key-pair to add");
        Objects.requireNonNull(kp.getPublic(), "No public key");
        Objects.requireNonNull(kp.getPrivate(), "No private key");
        this.identities.add(kp);
        if (this.log.isDebugEnabled()) {
            PublicKey key = kp.getPublic();
            this.log.debug("addPublicKeyIdentity({}) {}-{}", this, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.KEYPAIR_IDENTITY_COMPARATOR, kp);
        if (index >= 0) {
            return (KeyPair)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public ClientChannel createChannel(String type) throws IOException {
        return this.createChannel(type, null);
    }

    @Override
    public ClientChannel createChannel(String type, String subType) throws IOException {
        if ("shell".equals(type)) {
            return this.createShellChannel();
        }
        if ("exec".equals(type)) {
            return this.createExecChannel(subType);
        }
        if ("subsystem".equals(type)) {
            return this.createSubsystemChannel(subType);
        }
        throw new IllegalArgumentException("Unsupported channel type requested: " + type);
    }

    @Override
    public ChannelExec createExecChannel(String command, Charset charset, PtyChannelConfigurationHolder ptyConfig, Map<String, ?> env) throws IOException {
        ChannelExec channel = new ChannelExec(command, charset, ptyConfig, env);
        ConnectionService service = this.getConnectionService();
        long id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createExecChannel({})[{}] created id={} - PTY={}", this, command, id, ptyConfig);
        }
        return channel;
    }

    @Override
    public ChannelExec createExecChannel(byte[] command, PtyChannelConfigurationHolder ptyConfig, Map<String, ?> env) throws IOException {
        ChannelExec channel = new ChannelExec(command, ptyConfig, env);
        ConnectionService service = this.getConnectionService();
        long id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createExecChannel({})[{}] created id={} - PTY={}", this, new String(command, StandardCharsets.UTF_8), id, ptyConfig);
        }
        return channel;
    }

    @Override
    public ChannelSubsystem createSubsystemChannel(String subsystem) throws IOException {
        ChannelSubsystem channel = new ChannelSubsystem(subsystem);
        ConnectionService service = this.getConnectionService();
        long id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createSubsystemChannel({})[{}] created id={}", this, subsystem, id);
        }
        return channel;
    }

    @Override
    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        ChannelDirectTcpip channel = new ChannelDirectTcpip(local, remote);
        ConnectionService service = this.getConnectionService();
        long id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createDirectTcpipChannel({})[{} => {}] created id={}", this, local, remote, id);
        }
        return channel;
    }

    protected ClientUserAuthService getUserAuthService() {
        return this.getService(ClientUserAuthService.class);
    }

    @Override
    protected ConnectionService getConnectionService() {
        return this.getService(ConnectionService.class);
    }

    @Override
    public SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        Forwarder forwarder = this.getForwarder();
        return forwarder.startLocalPortForwarding(local, remote);
    }

    @Override
    public void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        Forwarder forwarder = this.getForwarder();
        forwarder.stopLocalPortForwarding(local);
    }

    @Override
    public SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        Forwarder forwarder = this.getForwarder();
        return forwarder.startRemotePortForwarding(remote, local);
    }

    @Override
    public void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        Forwarder forwarder = this.getForwarder();
        forwarder.stopRemotePortForwarding(remote);
    }

    @Override
    public SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        Forwarder forwarder = this.getForwarder();
        return forwarder.startDynamicPortForwarding(local);
    }

    @Override
    public void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        Forwarder forwarder = this.getForwarder();
        forwarder.stopDynamicPortForwarding(local);
    }

    @Override
    protected Forwarder getForwarder() {
        ConnectionService service = Objects.requireNonNull(this.getConnectionService(), "No connection service");
        return Objects.requireNonNull(service.getForwarder(), "No forwarder");
    }

    @Override
    protected String resolveAvailableSignaturesProposal(FactoryManager manager) {
        ValidateUtils.checkTrue(manager == this.getFactoryManager(), "Mismatched factory manager instances");
        return NamedResource.getNames(this.getSignatureFactories());
    }

    @Override
    public void startService(String name, Buffer buffer) throws Exception {
        SessionDisconnectHandler handler = this.getSessionDisconnectHandler();
        if (handler != null && handler.handleUnsupportedServiceDisconnectReason(this, 5, name, buffer)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("startService({}) ignore unknown service={} by handler", (Object)this, (Object)name);
            }
            return;
        }
        throw new IllegalStateException("Starting services is not supported on the client side: " + name);
    }

    @Override
    public ChannelShell createShellChannel(PtyChannelConfigurationHolder ptyConfig, Map<String, ?> env) throws IOException {
        if (!this.isConnectionSecure()) {
            throw new IllegalStateException("Interactive channels are not supported with none cipher");
        }
        ChannelShell channel = new ChannelShell(ptyConfig, env);
        ConnectionService service = this.getConnectionService();
        long id = service.registerChannel(channel);
        if (this.log.isDebugEnabled()) {
            this.log.debug("createShellChannel({}) created id={} - PTY={}", this, id, ptyConfig);
        }
        return channel;
    }

    @Override
    protected boolean readIdentification(Buffer buffer) throws Exception {
        List<String> ident = this.doReadIdentification(buffer, false);
        int numLines = GenericUtils.size(ident);
        String string = this.serverVersion = numLines <= 0 ? null : ident.remove(numLines - 1);
        if (this.serverVersion == null) {
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("readIdentification({}) Server version string: {}", (Object)this, (Object)this.serverVersion);
        }
        if (!SessionContext.isValidVersionPrefix(this.serverVersion)) {
            throw new SshException(8, "Unsupported protocol version: " + this.serverVersion);
        }
        this.signalExtraServerVersionInfo(this.serverVersion, ident);
        return true;
    }

    protected void signalExtraServerVersionInfo(String version, List<String> lines) throws Exception {
        this.signalPeerIdentificationReceived(version, lines);
        if (GenericUtils.isEmpty(lines)) {
            return;
        }
        UserInteraction ui = this.getUserInteraction();
        try {
            if (ui != null && ui.isInteractionAllowed(this)) {
                ui.serverVersionInfo(this, lines);
            }
        }
        catch (Error e) {
            this.warn("signalExtraServerVersionInfo({})[{}] failed ({}) to consult interaction: {}", this, version, e.getClass().getSimpleName(), e.getMessage(), e);
            throw new RuntimeSshException(e);
        }
    }

    @Override
    public KeyExchangeFuture switchToNoneCipher() throws IOException {
        Service service = this.currentService.getService();
        if (!(service instanceof AbstractConnectionService) || !GenericUtils.isEmpty(((AbstractConnectionService)service).getChannels())) {
            throw new IllegalStateException("The switch to the none cipher must be done immediately after authentication");
        }
        Map<KexProposalOption, String> serverProposal = this.getServerKexProposals();
        Map<KexProposalOption, String> clientProposal = this.getServerKexProposals();
        boolean c2sEncNone = BuiltinCiphers.Constants.isNoneCipherIncluded(serverProposal.get((Object)KexProposalOption.C2SENC));
        boolean s2cEncNone = BuiltinCiphers.Constants.isNoneCipherIncluded(serverProposal.get((Object)KexProposalOption.S2CENC));
        if (!c2sEncNone || !s2cEncNone) {
            throw new SshException("Server does not support none cipher");
        }
        c2sEncNone = BuiltinCiphers.Constants.isNoneCipherIncluded(clientProposal.get((Object)KexProposalOption.C2SENC));
        s2cEncNone = BuiltinCiphers.Constants.isNoneCipherIncluded(clientProposal.get((Object)KexProposalOption.S2CENC));
        if (!c2sEncNone || !s2cEncNone) {
            throw new SshException("Client does not support none cipher");
        }
        this.useNoneCipher = true;
        return this.reExchangeKeys();
    }

    @Override
    protected Map<KexProposalOption, String> getKexProposal() throws Exception {
        Map<KexProposalOption, String> result = super.getKexProposal();
        if (this.useNoneCipher) {
            result.put(KexProposalOption.C2SENC, BuiltinCiphers.none.getName());
            result.put(KexProposalOption.S2CENC, BuiltinCiphers.none.getName());
        }
        return result;
    }
}

