/*
 * Decompiled with CFR 0.152.
 */
package de.jgsoftware.jdesktop.telnet;

import java.awt.Canvas;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseListener;

class Terminal
extends Canvas {
    private int charWidth;
    private int charHeight = 12;
    private String[] text;
    private final int margin = 4;
    private final int lines = 50;

    Terminal() {
        this.setFont(new Font("Monospaced", 0, this.charHeight));
        this.charWidth = this.getFontMetrics(this.getFont()).stringWidth(" ");
        this.text = new String[50];
        for (int i = 0; i < 50; ++i) {
            this.text[i] = "";
        }
        this.setSize(80 * this.charWidth + 8, 25 * this.charHeight + 8);
        this.requestFocus();
        this.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void put(char c) {
        Graphics graphics = this.getGraphics();
        if (c == '\r') {
            for (int i = 49; i > 0; --i) {
                this.text[i] = this.text[i - 1];
            }
            this.text[0] = "";
            this.update(graphics);
        } else if (c == '\b' || c == '\u007f' || c == '\u00f7') {
            int n = this.text[0].length();
            if (n > 0) {
                this.text[0] = this.text[0].substring(0, --n);
                graphics.setColor(this.getBackground());
                graphics.fillRect(n * this.charWidth + 4, this.getSize().height - 4 - this.charHeight, (n + 1) * this.charWidth + 4, this.getSize().height - 4);
            }
        } else if (c == '\t') {
            this.text[0] = this.text[0] + "        ";
            this.text[0].substring(0, this.text[0].length() & 0xFFFFFFF8);
        } else if (c >= ' ' && c < '\u007f') {
            graphics.drawString("" + c, 4 + this.text[0].length() * this.charWidth, this.getSize().height - 4);
            this.text[0] = this.text[0] + c;
        }
        graphics.dispose();
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getSize().height;
        for (int i = 0; i < 50; ++i) {
            graphics.drawString(this.text[i], 4, n - 4 - i * this.charHeight);
        }
    }
}

